/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.client.service.impl;

import com.zkteco.zkbiosecurity.acc.service.AccCloudService;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceService;
import com.zkteco.zkbiosecurity.acc.vo.AccTransactionItem;
import com.zkteco.zkbiosecurity.core.utils.CollectionUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.license.provider.BaseLicenseProvider;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseClientService;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import com.zkteco.zkbiosecurity.system.app.service.BaseAuthCloudMessageSendService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccCloudServiceImpl
implements AccCloudService {
    @Autowired
    private BaseLicenseService baseLicenseService;
    @Autowired
    private BaseLicenseClientService baseLicenseClientService;
    @Autowired
    private AccDeviceService accDeviceService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private BaseAuthCloudMessageSendService baseAuthCloudMessageSendService;
    @Autowired
    private BaseLicenseProvider baseLicenseProvider;

    public void asyncPushTransactionToCloud(List<AccTransactionItem> accTransactionItemList) {
        if (StringUtils.isNotBlank((CharSequence)this.baseLicenseService.getAppId()) && this.isActiveLicense() && !CollectionUtil.isEmpty(accTransactionItemList)) {
            CompletableFuture.runAsync(() -> {
                List accTransactionItemsList = CollectionUtil.split((Collection)accTransactionItemList, (int)30);
                ZKMessage zkMessage = new ZKMessage();
                zkMessage.setModuleCode("acc");
                zkMessage.setMessageId("accCloudTransactionHandle#getCloudTransaction");
                zkMessage.setAppId(this.baseLicenseService.getAppId());
                accTransactionItemsList.forEach(accTransactionItems -> {
                    for (AccTransactionItem accTransactionItem : accTransactionItems) {
                        accTransactionItem.setVerifyModeName(I18nUtil.i18nCode((String)accTransactionItem.getVerifyModeName(), (Object[])new Object[0]));
                        accTransactionItem.setEventName(I18nUtil.i18nCode((String)accTransactionItem.getEventName(), (Object[])new Object[0]));
                    }
                    zkMessage.setListContent(accTransactionItems);
                    this.baseLicenseClientService.sendMessage(zkMessage);
                });
            });
        }
    }

    public void asyncDevStatusToCloud(String sn) {
        if (StringUtils.isNotBlank((CharSequence)this.baseLicenseService.getAppId()) && this.isActiveLicense() && StringUtils.isNotBlank((CharSequence)sn) && StringUtils.isNotBlank((CharSequence)this.baseSysParamService.getValByName("acc.device.lastPushTime"))) {
            CompletableFuture.runAsync(() -> {
                ZKMessage message = new ZKMessage();
                message.setModuleCode("acc");
                message.setMessageId("accCloudDeviceInfoHandle#asyncDevStatus");
                HashMap<String, String> dataMap = new HashMap<String, String>();
                String status = this.accDeviceService.getStatus(sn);
                dataMap.put("sn", sn);
                dataMap.put("status", status);
                message.setContent(dataMap);
                this.baseLicenseClientService.sendMessage(message);
            });
        }
    }

    public void deleteCloudDevice(List<String> devSnList) {
        if (this.baseAuthCloudMessageSendService.isAllowSendBusinessData() && this.isActiveLicense() && !CollectionUtil.isEmpty(devSnList) && this.accDeviceService.getLastPushTime() != null) {
            CompletableFuture.runAsync(() -> {
                ZKMessage message = new ZKMessage();
                message.setModuleCode("acc");
                message.setMessageId("accCloudDeviceInfoHandle#deleteDeviceBySn");
                message.setListContent(devSnList);
                this.baseLicenseClientService.sendMessage(message);
            });
        }
    }

    public boolean isActiveLicense() {
        List activeModuleCodeList = this.baseLicenseProvider.getActiveModuleLIist();
        return activeModuleCodeList.contains("push") || activeModuleCodeList.contains("pull");
    }
}

