/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sourceforge.jnlp.controlpanel.CachePane;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.ImageResources;
import net.sourceforge.jnlp.util.ScreenFinder;
import net.sourceforge.jnlp.util.logging.JavaConsole;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.jnlp.util.ui.Boxer;
import net.sourceforge.jnlp.util.ui.SwingHelpers;
import net.sourceforge.swing.SwingUtils;

public class BasicExceptionDialog {
    private static final AtomicInteger dialogInstancess = new AtomicInteger();

    public static void show(Exception exception) {
        SwingHelpers.enableDefaultLaF();
        String errorText = exception.getMessage();
        String shortText = SwingHelpers.shortenText(errorText, 256);
        String labelText = SwingHelpers.wrapLabelText(shortText);
        String detailsText = OutputController.exceptionToString(exception);
        final JPanel mainPanel = Boxer.verticalPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JOptionPane optionPane = new JOptionPane(mainPanel, 0);
        final JDialog errorDialog = optionPane.createDialog(Translator.R("Error"));
        errorDialog.setName("BasicExceptionDialog");
        SwingUtils.info(errorDialog);
        errorDialog.setIconImages(ImageResources.INSTANCE.getApplicationImages());
        JPanel quickInfoPanelAll = Boxer.verticalPanel(mainPanel);
        JPanel quickInfoPanelMessage = Boxer.horizontalPanel(quickInfoPanelAll);
        quickInfoPanelAll.add(Box.createVerticalStrut(10));
        JPanel linkPanel = Boxer.horizontalPanel(quickInfoPanelAll);
        linkPanel.add(new JLabel(Translator.R("PEHelpMenu") + ":"));
        linkPanel.add(Box.createHorizontalStrut(10));
        JLabel urlLabel = new JLabel(SwingHelpers.linkify(JNLPRuntime.getHelpUrl()));
        urlLabel.addMouseListener(new SwingHelpers.OpenUrlInBrowserListener(JNLPRuntime.getHelpUrl()));
        urlLabel.setCursor(new Cursor(12));
        linkPanel.add(urlLabel);
        quickInfoPanelAll.add(Box.createVerticalStrut(10));
        JPanel quickInfoPanelButtons = Boxer.horizontalPanel(quickInfoPanelAll);
        JLabel errorLabel = new JLabel(labelText);
        quickInfoPanelMessage.add(errorLabel);
        quickInfoPanelMessage.setPreferredSize(new Dimension(480, 50));
        final JButton viewDetails = new JButton(Translator.R("ButShowDetails"));
        viewDetails.setActionCommand("show");
        quickInfoPanelButtons.add(viewDetails);
        if (!JNLPRuntime.isWindows()) {
            JButton cacheButton = BasicExceptionDialog.getClearCacheButton(errorDialog);
            quickInfoPanelButtons.add(cacheButton);
        }
        if (JavaConsole.isEnabled()) {
            JButton consoleButton = BasicExceptionDialog.getShowButton(errorDialog);
            quickInfoPanelButtons.add(consoleButton);
        }
        quickInfoPanelButtons.add(Box.createHorizontalGlue());
        JTextArea textArea = new JTextArea();
        textArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        textArea.setEditable(false);
        textArea.setText(detailsText);
        final JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setPreferredSize(new Dimension(100, 200));
        viewDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (viewDetails.getActionCommand().equals("show")) {
                    mainPanel.add(scrollPane);
                    viewDetails.setActionCommand("hide");
                    viewDetails.setText(Translator.R("ButHideDetails"));
                    errorDialog.pack();
                } else {
                    mainPanel.remove(scrollPane);
                    viewDetails.setActionCommand("show");
                    viewDetails.setText(Translator.R("ButShowDetails"));
                    errorDialog.pack();
                }
            }
        });
        errorDialog.setResizable(true);
        errorDialog.pack();
        ScreenFinder.centerWindowsToCurrentScreen(errorDialog);
        errorDialog.setVisible(true);
        errorDialog.dispose();
        BasicExceptionDialog.willBeHidden();
    }

    public static JButton getShowButton(final Component parent) {
        JButton consoleButton = new JButton();
        consoleButton.setText(Translator.R("DPJavaConsole"));
        consoleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    JavaConsole.getConsole().showConsoleLater(true);
                }
                catch (Exception ex) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ex);
                    JOptionPane.showConfirmDialog(parent, ex);
                }
            }
        });
        if (!JavaConsole.isEnabled()) {
            consoleButton.setEnabled(false);
            consoleButton.setToolTipText(Translator.R("DPJavaConsoleDisabledHint"));
        }
        return consoleButton;
    }

    public static JButton getClearCacheButton(final Component parent) {
        JButton clearAllButton = new JButton();
        clearAllButton.setText(Translator.R("CVCPCleanCache"));
        clearAllButton.setToolTipText(Translator.R("CVCPCleanCacheTip"));
        clearAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwingUtils.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CachePane.visualCleanCache(parent);
                        }
                        catch (Exception ex) {
                            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, ex);
                        }
                    }
                });
            }
        });
        return clearAllButton;
    }

    private static synchronized int willBeHidden() {
        return dialogInstancess.decrementAndGet();
    }

    public static synchronized int willBeShown() {
        return dialogInstancess.incrementAndGet();
    }

    public static synchronized boolean areShown() {
        return dialogInstancess.intValue() > 0;
    }
}

