/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.utils;

import com.zkteco.zkbiosecurity.core.utils.I18nUtil;

public class PsgEnumUtil {

    public static enum AuxInImage {
        OFFLINE(new String[]{"off"}, 0),
        ONLINE(new String[]{"on"}, 1),
        DISABLE(new String[]{"disable"}, 2);

        private String[] values;
        private int index;

        private AuxInImage(String[] values, int index) {
            this.values = values;
            this.index = index;
        }

        public static String getValue(int index) {
            return AuxInImage.getValue(index, 0);
        }

        public static String getValue(int index, int valueIndex) {
            for (AuxInImage c : AuxInImage.values()) {
                if (c.getIndex() != index) continue;
                return c.values[valueIndex];
            }
            return null;
        }

        public int getIndex() {
            return this.index;
        }

        public String[] getValues() {
            return this.values;
        }
    }

    public static enum GateImage {
        OFFLINE(new String[][]{{"offline", "offline_to_gate"}}, 0),
        ONLINE(new String[][]{{"nosensor", "opened_out", "opened_in"}, {"alarm_nosensor", "alarm_nosensor", "alarm_nosensor"}, {"alarm_infrared_exception", "alarm_infrared_exception", "alarm_infrared_exception"}, {"alarm_error", "alarm_error", "alarm_error"}, {"normalOpened", "normalOpened", "normalOpened"}}, 1),
        DISABLE(new String[][]{{"disabled", "disabled"}}, 2),
        LOCK(new String[][]{{"alwayslocked"}}, 3);

        private String[][] values;
        private int index;

        private GateImage(String[][] values, int index) {
            this.values = values;
            this.index = index;
        }

        public static int getAlarmState(int alarmIndex) {
            if ((alarmIndex & 0xF) != 0) {
                return 1;
            }
            if ((alarmIndex & 0x10) == 16) {
                return 2;
            }
            if ((alarmIndex & 0x20) == 32) {
                return 3;
            }
            if ((alarmIndex & 0x40) == 64) {
                return 4;
            }
            return 0;
        }

        public static String getValue(int index, int devOnline, int alarmIndex, int relayIndex) {
            if (devOnline == 1 && index == 3) {
                return GateImage.LOCK.values[0][0];
            }
            for (GateImage c : GateImage.values()) {
                if (c.getIndex() != devOnline) continue;
                if (devOnline == 0 || devOnline == 2) {
                    return c.values[0][0];
                }
                if (devOnline == 1 && index == 0) {
                    return GateImage.OFFLINE.values[0][1];
                }
                alarmIndex = GateImage.getAlarmState(alarmIndex);
                return c.values[alarmIndex][relayIndex];
            }
            return null;
        }

        public int getIndex() {
            return this.index;
        }

        public String[][] getValues() {
            return this.values;
        }
    }

    public static enum Alarm {
        OFFLINE(new String[]{I18nUtil.i18nCode((String)"common_none", (Object[])new Object[0])}, 0),
        ONLINE(new String[]{I18nUtil.i18nCode((String)"common_none", (Object[])new Object[0]), I18nUtil.i18nCode((String)"psg_rtMonitor_openForce", (Object[])new Object[0]), I18nUtil.i18nCode((String)"psg_rtMonitor_tamper", (Object[])new Object[0]), I18nUtil.i18nCode((String)"psg_rtMonitor_duressPwdOpen", (Object[])new Object[0]), I18nUtil.i18nCode((String)"psg_rtMonitor_duressFingerOpen", (Object[])new Object[0]), I18nUtil.i18nCode((String)"psg_rtMonitor_duressOpen", (Object[])new Object[0]), I18nUtil.i18nCode((String)"psg_rtMonitor_infraredAlarm", (Object[])new Object[0]), I18nUtil.i18nCode((String)"psg_rtMonitor_gateError", (Object[])new Object[0])}, 1),
        DISABLE(new String[]{I18nUtil.i18nCode((String)"psg_rtMonitor_unknown", (Object[])new Object[0])}, 2);

        private String[] values;
        private int index;

        private Alarm(String[] values, int index) {
            this.values = values;
            this.index = index;
        }

        public static int getAlarmType(int alarm) {
            if ((alarm & 8) == 8 && (alarm & 4) == 4) {
                return 5;
            }
            if ((alarm & 8) == 8) {
                return 4;
            }
            if ((alarm & 4) == 4) {
                return 3;
            }
            if ((alarm & 2) == 2) {
                return 2;
            }
            if ((alarm & 1) == 1) {
                return 1;
            }
            if ((alarm & 0x10) == 16) {
                return 6;
            }
            if ((alarm & 0x20) == 32) {
                return 7;
            }
            return 0;
        }

        public static String getValue(int index, int alarmIndex) {
            for (Alarm c : Alarm.values()) {
                if (c.getIndex() != index) continue;
                if (index == 0 || index == 2) {
                    return c.values[0];
                }
                alarmIndex = Alarm.getAlarmType(alarmIndex);
                return c.values[alarmIndex];
            }
            return null;
        }

        public int getIndex() {
            return this.index;
        }

        public String[] getValues() {
            return this.values;
        }
    }

    public static enum Relay {
        OFFLINE(new String[]{I18nUtil.i18nCode((String)"psg_rtMonitor_unknown", (Object[])new Object[0])}, 0),
        ONLINE(new String[]{I18nUtil.i18nCode((String)"common_close", (Object[])new Object[0]), I18nUtil.i18nCode((String)"common_open", (Object[])new Object[0])}, 1),
        DISABLE(new String[]{I18nUtil.i18nCode((String)"psg_rtMonitor_unknown", (Object[])new Object[0])}, 2);

        private String[] values;
        private int index;

        private Relay(String[] values, int index) {
            this.values = values;
            this.index = index;
        }

        public static String getValue(int index, int valueIndex) {
            for (Relay c : Relay.values()) {
                if (c.getIndex() != index) continue;
                return c.values.length == 1 ? c.values[0] : c.values[valueIndex];
            }
            return null;
        }

        public int getIndex() {
            return this.index;
        }

        public String[] getValues() {
            return this.values;
        }
    }

    public static enum Sensor {
        OFFLINE(new String[]{I18nUtil.i18nCode((String)"psg_rtMonitor_unknown", (Object[])new Object[0])}, 0),
        ONLINE(new String[]{I18nUtil.i18nCode((String)"psg_rtMonitor_noSensor", (Object[])new Object[0]), I18nUtil.i18nCode((String)"common_close", (Object[])new Object[0]), I18nUtil.i18nCode((String)"common_open", (Object[])new Object[0])}, 1),
        DISABLE(new String[]{I18nUtil.i18nCode((String)"psg_rtMonitor_unknown", (Object[])new Object[0])}, 2);

        private String[] values;
        private int index;

        private Sensor(String[] values, int index) {
            this.values = values;
            this.index = index;
        }

        public static String getValue(int index, int valueIndex) {
            for (Sensor c : Sensor.values()) {
                if (c.getIndex() != index) continue;
                return c.values.length == 1 ? c.values[0] : c.values[valueIndex];
            }
            return null;
        }

        public int getIndex() {
            return this.index;
        }

        public String[] getValues() {
            return this.values;
        }
    }
}

