/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.psg.remote.PsgThreeRollerGateRemote;
import com.zkteco.zkbiosecurity.psg.service.PsgThreeRollerGateService;
import com.zkteco.zkbiosecurity.psg.vo.PsgThreeRollerGateItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PsgThreeRollerGateController
extends BaseController
implements PsgThreeRollerGateRemote {
    @Autowired
    private PsgThreeRollerGateService psgThreeRollerGateService;

    @RequiresPermissions(value={"psg:threeRollerGate"})
    public ModelAndView index() {
        return new ModelAndView("psg/threeRollerGate/psgThreeRollerGate");
    }

    @RequiresPermissions(value={"psg:threeRollerGate:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.psgThreeRollerGateService.getItemById(id));
        }
        return new ModelAndView("psg/threeRollerGate/editPsgThreeRollerGate");
    }

    @RequiresPermissions(value={"psg:threeRollerGate:edit"})
    @LogRequest(module="psg_module", object="psg_device_threeRollerGate", opType="common_op_edit", requestParams={"name"}, opContent="psg_gate_name")
    public ZKResultMsg save(PsgThreeRollerGateItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.psgThreeRollerGateService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"psg:threeRollerGate:refresh"})
    public DxGrid list(PsgThreeRollerGateItem condition) {
        Pager pager = this.psgThreeRollerGateService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }
}

