/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.psg.remote.PsgPersonLevelByLevelRemote;
import com.zkteco.zkbiosecurity.psg.service.PsgLevelService;
import com.zkteco.zkbiosecurity.psg.service.PsgPersonLevelByLevelService;
import com.zkteco.zkbiosecurity.psg.service.PsgPersonService;
import com.zkteco.zkbiosecurity.psg.vo.PsgPersonLevelByLevelItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgPersonListItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PsgPersonLevelByLevelController
extends ExportController
implements PsgPersonLevelByLevelRemote {
    private Logger logger = LoggerFactory.getLogger(PsgPersonLevelByLevelController.class);
    @Autowired
    private PsgPersonLevelByLevelService psgPersonLevelByLevelService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private PsgPersonService psgPersonService;
    @Autowired
    private PsgLevelService psgLevelService;

    @RequiresPermissions(value={"psg:personLevelByLevel"})
    public ModelAndView index() {
        return new ModelAndView("psg/personLevelByLevel/psgPersonLevelByLevel");
    }

    @RequiresPermissions(value={"psg:personLevelByLevel:refresh"})
    public DxGrid list(PsgPersonLevelByLevelItem codition) {
        Pager pager = this.psgPersonLevelByLevelService.loadPagerByAuthFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"psg:personLevelByLevel:refresh"})
    public DxGrid getLevelPerson(PsgPersonListItem condition) {
        condition.setModelType("PSG_LEVEL");
        Pager pager = this.psgPersonService.getPersonItemList(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"psg:personLevelByLevel:addPerson"})
    @LogRequest(module="psg_module", object="common_leftMenu_levelSetByLevel", opType="pers_common_addPerson", requestParams={"levelName", "personPins"}, opContent="pers_person_pin")
    public ZKResultMsg addPerson(String levelId, String personIds, String deptIds) {
        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>");
        if (StringUtils.isNotBlank((CharSequence)deptIds)) {
            personIds = this.psgPersonService.getPersonIdsByDeptIds(deptIds);
        }
        if (StringUtils.isNotBlank((CharSequence)personIds) && StringUtils.isNotBlank((CharSequence)levelId)) {
            try {
                List personArrayIds = this.psgPersonService.splitPersonIds(personIds, 500);
                int total = personArrayIds.size();
                for (int i = 0; i < total; ++i) {
                    this.psgLevelService.addPersonLevel(levelId, (String)personArrayIds.get(i));
                    personArrayIds.set(i, null);
                    System.gc();
                    Thread.sleep(1000L);
                    this.progressCache.setProcess(new ProcessBean(0, (int)((double)(i + 1) * 1.0 / (double)total * 100.0)));
                }
            }
            catch (Exception e) {
                this.logger.error("addPerson with level error", (Throwable)e);
            }
        }
        this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>");
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"psg:personLevelByLevel:delPerson"})
    @LogRequest(module="psg_module", object="common_leftMenu_levelSetByLevel", opType="pers_common_delPerson", requestParams={"levelName", "personPins"}, opContent="pers_person_pin")
    public ZKResultMsg delPerson(String levelId, String personIds) {
        ZKResultMsg resultMsg = this.psgPersonLevelByLevelService.delPerson(levelId, personIds);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"psg:personLevelByLevel:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        PsgPersonListItem psgPersonListItem = new PsgPersonListItem();
        this.setConditionValue((BaseItem)psgPersonListItem);
        List psgPersonListItemList = this.psgPersonLevelByLevelService.getExportItemList(request.getSession().getId(), psgPersonListItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(psgPersonListItemList, PsgPersonListItem.class);
    }
}

