/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.web;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.ExcelUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletOutputStream;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;

public class ExportController
extends BaseController {
    public static final String IMPORT_RESULT = "import-result:";
    public static final String EXPORT_RESULT = "export-result:";
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Value(value="${security.session.timeout:1800}")
    private Long sessionTimeout;

    public <T> List<T> excelImport(InputStream inputStream, Class<T> cls) {
        List<T> list = this.excelImport(inputStream, cls, null);
        return list;
    }

    public <T> List<T> excelImport(InputStream inputStream, Class<T> cls, Map<String, Map<String, String>> map) {
        this.stringRedisTemplate.opsForValue().set((Object)(IMPORT_RESULT + this.request.getSession().getId()), (Object)"start");
        List<T> list = ExcelUtil.excelImport(inputStream, cls, map);
        this.stringRedisTemplate.opsForValue().set((Object)(IMPORT_RESULT + this.request.getSession().getId()), (Object)"end");
        this.stringRedisTemplate.expire((Object)(IMPORT_RESULT + this.request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
        return list;
    }

    protected <T> void excelExportForDynamic(List<T> list, Class<T> cls, Map<String, Map<String, String>> map) {
        if (list == null || 0 == list.size()) {
            this.stringRedisTemplate.opsForValue().set((Object)(EXPORT_RESULT + this.request.getSession().getId()), (Object)"end");
            this.stringRedisTemplate.expire((Object)(EXPORT_RESULT + this.request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
            throw new ZKBusinessException("common_report_dataSourceNull");
        }
        String reportType = this.request.getParameter("reportType");
        String jsonColumn = this.request.getParameter("jsonColumn");
        String fileName = this.request.getParameter("tableNameParam");
        String tableName = this.request.getParameter("tableNameSearch");
        if (map != null && map.get("jsonColumn") != null) {
            Map<String, String> jsonColumnMap = map.get("jsonColumn");
            jsonColumn = jsonColumnMap.get("jsonColumn");
        }
        if (!StringUtils.isBlank((CharSequence)tableName)) {
            fileName = tableName;
        }
        if (map != null && map.get("tableName") != null) {
            Map<String, String> tableNameMap = map.get("tableName");
            fileName = tableNameMap.get("tableName");
        }
        String gridName = fileName;
        if (StringUtils.isBlank((CharSequence)reportType)) {
            reportType = "xlsx";
        }
        reportType = reportType.toLowerCase();
        try {
            String agent = this.request.getHeader("User-Agent").toLowerCase();
            if (this.request.getHeader("User-Agent") != null && agent.indexOf("edge") != -1) {
                fileName = fileName.replaceAll(" ", "%20");
                fileName = URLEncoder.encode(fileName, "UTF-8");
                fileName = fileName.replace("%2520", " ");
            } else if (agent != null && (agent.indexOf("msie") != -1 || agent.indexOf("rv") != -1 && agent.indexOf("firefox") == -1)) {
                fileName = fileName.replaceAll(" ", "%20");
                fileName = URLEncoder.encode(fileName, "UTF-8");
                fileName = fileName.replace("%2520", " ");
            } else {
                fileName = agent != null && agent.indexOf("firefox") != -1 ? new String(fileName.getBytes("UTF-8"), "ISO-8859-1") : new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
            }
            this.response.setCharacterEncoding("utf-8");
            this.response.setHeader("Content-Disposition", "attachment;filename=\"" + fileName + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "." + reportType + "\"");
            this.response.setContentType("application/octet-stream");
            ServletOutputStream os = this.response.getOutputStream();
            ExcelUtil.excelExportForDynamic(list, cls, jsonColumn, gridName, (OutputStream)os, reportType, map);
            os.flush();
        }
        catch (Exception e) {
            this.log.error(fileName + " export error", (Throwable)e);
            this.response.setHeader("Content-Disposition", "");
            this.response.setContentType("application/json");
            throw new ZKBusinessException("common_report_exportFaild");
        }
        finally {
            this.stringRedisTemplate.opsForValue().set((Object)(EXPORT_RESULT + this.request.getSession().getId()), (Object)"end");
            this.stringRedisTemplate.expire((Object)(EXPORT_RESULT + this.request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
        }
    }

    protected <T> void excelExportForDynamic(List<T> list, Class<T> cls) {
        this.excelExportForDynamic(list, cls, null);
    }

    protected <T> void excelExport(List<T> list, Class<T> cls) {
        this.excelExport(list, cls, null);
    }

    protected <T> void excelExport(List<T> list, Class<T> cls, Map<String, Map<String, String>> map) {
        if (list == null || 0 == list.size()) {
            this.stringRedisTemplate.opsForValue().set((Object)(EXPORT_RESULT + this.request.getSession().getId()), (Object)"end");
            this.stringRedisTemplate.expire((Object)(EXPORT_RESULT + this.request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
            throw new ZKBusinessException("common_report_dataSourceNull");
        }
        String reportType = this.request.getParameter("reportType");
        String jsonColumn = this.request.getParameter("jsonColumn");
        String fileName = this.request.getParameter("tableNameParam");
        String tableName = this.request.getParameter("tableNameSearch");
        if (map != null && map.get("jsonColumn") != null) {
            Map<String, String> jsonColumnMap = map.get("jsonColumn");
            jsonColumn = jsonColumnMap.get("jsonColumn");
        }
        if (!StringUtils.isBlank((CharSequence)tableName)) {
            fileName = tableName;
        }
        if (map != null && map.get("tableName") != null) {
            Map<String, String> tableNameMap = map.get("tableName");
            fileName = tableNameMap.get("tableName");
        }
        String gridName = fileName;
        if (StringUtils.isBlank((CharSequence)reportType)) {
            reportType = "xlsx";
        }
        reportType = reportType.toLowerCase();
        try {
            String agent = this.request.getHeader("User-Agent").toLowerCase();
            if (this.request.getHeader("User-Agent") != null && agent.indexOf("edge") != -1) {
                fileName = fileName.replaceAll(" ", "%20");
                fileName = URLEncoder.encode(fileName, "UTF-8");
                fileName = fileName.replace("%2520", " ");
            } else if (agent != null && (agent.indexOf("msie") != -1 || agent.indexOf("rv") != -1 && agent.indexOf("firefox") == -1)) {
                fileName = fileName.replaceAll(" ", "%20");
                fileName = URLEncoder.encode(fileName, "UTF-8");
                fileName = fileName.replace("%2520", " ");
            } else {
                fileName = agent != null && agent.indexOf("firefox") != -1 ? new String(fileName.getBytes("UTF-8"), "ISO-8859-1") : new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
            }
            this.response.setCharacterEncoding("utf-8");
            this.response.setHeader("Content-Disposition", "attachment;filename=\"" + fileName + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "." + reportType + "\"");
            this.response.setContentType("application/octet-stream");
            ServletOutputStream os = this.response.getOutputStream();
            ExcelUtil.excelExport(list, cls, jsonColumn, gridName, (OutputStream)os, reportType, map);
            os.flush();
        }
        catch (Exception e) {
            this.log.error(fileName + " export error", (Throwable)e);
            this.response.setHeader("Content-Disposition", "");
            this.response.setContentType("application/json");
            throw new ZKBusinessException("common_report_exportFaild");
        }
        finally {
            this.stringRedisTemplate.opsForValue().set((Object)(EXPORT_RESULT + this.request.getSession().getId()), (Object)"end");
            this.stringRedisTemplate.expire((Object)(EXPORT_RESULT + this.request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
        }
    }

    protected void setConditionValue(BaseItem conditionItem) {
        String[] conditionAry;
        this.stringRedisTemplate.opsForValue().set((Object)(EXPORT_RESULT + this.request.getSession().getId()), (Object)"start");
        String queryCondition = this.request.getParameter("queryConditions");
        String sortOrder = this.request.getParameter("sortOrder");
        String sortName = this.request.getParameter("sortName");
        if (StringUtils.isNotBlank((CharSequence)sortOrder) && StringUtils.isNotBlank((CharSequence)sortName)) {
            conditionItem.setSortName(sortName);
            conditionItem.setSortOrder(sortOrder);
        }
        if (StringUtils.isBlank((CharSequence)queryCondition)) {
            return;
        }
        for (String condition : conditionAry = queryCondition.replaceAll("%20", " ").split("&")) {
            if (StringUtils.isBlank((CharSequence)condition)) continue;
            String[] strAry = condition.split("=", 2);
            String fieldName = strAry[0];
            String fieldValue = strAry[1];
            try {
                Field field = conditionItem.getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                fieldValue = URLDecoder.decode(fieldValue, "UTF-8");
                if (!StringUtils.isNotBlank((CharSequence)fieldValue)) continue;
                if (field.getType().getTypeName().equals("java.util.Date")) {
                    field.set(conditionItem, DateUtil.stringToDate((String)fieldValue));
                    continue;
                }
                if (field.getType().getTypeName().equals("java.sql.Timestamp")) {
                    field.set(conditionItem, new Timestamp(DateUtil.stringToDate((String)fieldValue).getTime()));
                    continue;
                }
                field.set(conditionItem, ConvertUtils.convert((String)fieldValue, field.getType()));
            }
            catch (Exception e) {
                this.log.error("setConditionValue", (Throwable)e);
            }
        }
    }

    protected int getBeginIndex() {
        String exportType = this.request.getParameter("exportType");
        String recordStart = this.request.getParameter("recordstart");
        String recordCount = this.request.getParameter("recordcount");
        int beginIndex = 0;
        if ("3".equals(exportType) && StringUtils.isNotBlank((CharSequence)recordStart) && StringUtils.isNotBlank((CharSequence)recordCount)) {
            beginIndex = Integer.valueOf(recordStart);
            beginIndex = beginIndex > 0 ? beginIndex - 1 : beginIndex;
        }
        return beginIndex;
    }

    protected int getEndIndex() {
        String exportType = this.request.getParameter("exportType");
        String recordStart = this.request.getParameter("recordstart");
        String recordCount = this.request.getParameter("recordcount");
        int endIndex = 29999;
        if ("3".equals(exportType) && StringUtils.isNotBlank((CharSequence)recordStart) && StringUtils.isNotBlank((CharSequence)recordCount)) {
            int beginIndex = Integer.valueOf(recordStart);
            beginIndex = beginIndex > 0 ? beginIndex - 1 : beginIndex;
            int maxCount = Integer.valueOf(recordCount) > 30000 ? 30000 : Integer.valueOf(recordCount);
            endIndex = beginIndex + maxCount - 1;
        }
        return endIndex;
    }
}

