/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.patrol.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.patrol.remote.PatrolPointRemote;
import com.zkteco.zkbiosecurity.patrol.service.PatrolPointService;
import com.zkteco.zkbiosecurity.patrol.service.PatrolRoutePointService;
import com.zkteco.zkbiosecurity.patrol.vo.PatrolPointItem;
import com.zkteco.zkbiosecurity.patrol.vo.PatrolPointSelectItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PatrolPointController
extends BaseController
implements PatrolPointRemote {
    @Autowired
    private PatrolPointService patrolPointService;
    @Autowired
    private PatrolRoutePointService patrolRoutePointService;

    @RequiresPermissions(value={"patrol:point"})
    public ModelAndView index() {
        return new ModelAndView("patrol/point/patrolPoint");
    }

    @RequiresPermissions(value={"patrol:point:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            PatrolPointItem item = this.patrolPointService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
            this.request.setAttribute("devId", (Object)item.getDevId());
        }
        return new ModelAndView("patrol/point/editPatrolPoint");
    }

    @RequiresPermissions(value={"patrol:point:edit"})
    @LogRequest(module="patrol_module", object="patrol_point", opType="common_op_edit", requestParams={"name"}, opContent="common_op_edit")
    public ZKResultMsg save(PatrolPointItem item) {
        ZKResultMsg res = new ZKResultMsg();
        if (this.patrolPointService.isPatrolPointUsed(item.getId())) {
            throw new ZKBusinessException(I18nUtil.i18nCode((String)"patrol_point_editPointFail", (Object[])new Object[0]));
        }
        this.patrolPointService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"patrol:point:refresh"})
    public DxGrid list(PatrolPointItem condition) {
        Pager pager = this.patrolPointService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"patrol:point:del"})
    @LogRequest(module="patrol_module", object="patrol_point", opType="common_op_del", requestParams={"name"}, opContent="common_op_del")
    public ZKResultMsg del(String ids) {
        this.patrolPointService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String valid(String name) {
        PatrolPointItem item = this.patrolPointService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    public ZKResultMsg getPatrolTagsByDevId(String devId, String pointId) {
        if (StringUtils.isNotBlank((CharSequence)devId)) {
            return new ZKResultMsg((Object)this.patrolPointService.getByDevIdAndPointId(devId, pointId));
        }
        return new ZKResultMsg();
    }

    public DxGrid routePointSelectList(final PatrolPointSelectItem condition) {
        if (StringUtils.isBlank((CharSequence)condition.getSelectId())) {
            condition.setSelectId("-1");
        }
        if (condition.getType().equals("noSelected")) {
            condition.setSelectPointIdsNotIn(condition.getSelectId());
        } else if (condition.getType().equals("selected")) {
            condition.setSelectPointIdsIn(condition.getSelectId());
        }
        Pager pager = this.patrolPointService.getRoutePointSelectItemsByPage(condition, this.getPageNo(), this.getPageSize());
        List list = pager.getData();
        if (!"-1".equals(condition.getSelectId())) {
            Collections.sort(list, new Comparator<PatrolPointSelectItem>(){

                @Override
                public int compare(PatrolPointSelectItem arg0, PatrolPointSelectItem arg1) {
                    return (condition.getSelectId() + ",").indexOf(arg0.getId() + ",") - (condition.getSelectId() + ",").indexOf(arg1.getId() + ",");
                }
            });
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg validPointCount() {
        this.patrolPointService.validPointCount();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

