/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.patrol.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.patrol.remote.PatrolPersonSelectRemote;
import com.zkteco.zkbiosecurity.patrol.service.PatrolGroupService;
import com.zkteco.zkbiosecurity.patrol.service.PatrolPersonSelectService;
import com.zkteco.zkbiosecurity.patrol.vo.PatrolPersonSelectItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PatrolPersonSelectController
extends BaseController
implements PatrolPersonSelectRemote {
    @Autowired
    private PatrolPersonSelectService patrolPersonSelectService;
    @Autowired
    private PatrolGroupService patrolGroupService;

    @RequiresPermissions(value={"patrol:person"})
    public ModelAndView index() {
        return new ModelAndView("patrol/person/patrolPerson");
    }

    public DxGrid groupPersonSelectList(PatrolPersonSelectItem condition) {
        String patrolGroupId = this.request.getParameter("patrolGroupId");
        condition.setModelType("PATROL_GROUP");
        condition.setLinkId(patrolGroupId);
        Pager pager = new Pager();
        if (condition.getType().equals("noSelected")) {
            pager = this.patrolPersonSelectService.getNoExistPerson(this.request.getSession().getId(), (BaseItem)condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid routePersonSelectList(PatrolPersonSelectItem condition) {
        Pager pager = new Pager();
        if (condition.getType().equals("noSelected")) {
            pager = this.patrolPersonSelectService.getNoExistPerson(this.request.getSession().getId(), (BaseItem)condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"patrol:person:del"})
    public ZKResultMsg del(String ids) {
        this.patrolPersonSelectService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

