/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.patrol.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.patrol.remote.PatrolAlarmCardRemote;
import com.zkteco.zkbiosecurity.patrol.service.PatrolAlarmCardService;
import com.zkteco.zkbiosecurity.patrol.vo.PatrolAlarmCardItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PatrolAlarmCardController
extends BaseController
implements PatrolAlarmCardRemote {
    @Autowired
    private PatrolAlarmCardService patrolAlarmCardService;

    @RequiresPermissions(value={"patrol:alarmCard:view"})
    public ModelAndView index() {
        return new ModelAndView("patrol/alarmCard/patrolAlarmCard");
    }

    @RequiresPermissions(value={"patrol:alarmCard:edit"})
    @LogRequest
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.patrolAlarmCardService.getItemById(id));
        }
        return new ModelAndView("patrol/alarmCard/editPatrolAlarmCard");
    }

    @RequiresPermissions(value={"patrol:alarmCard:edit"})
    public ZKResultMsg save(PatrolAlarmCardItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.patrolAlarmCardService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(PatrolAlarmCardItem condition) {
        Pager pager = this.patrolAlarmCardService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg delete(String ids) {
        this.patrolAlarmCardService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

