/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.client.service;

import com.zkteco.zkbiosecurity.att.service.AttPersonSchService;
import com.zkteco.zkbiosecurity.att.service.AttPersonService;
import com.zkteco.zkbiosecurity.att.service.AttShiftService;
import com.zkteco.zkbiosecurity.att.service.AttTimeSlotService;
import com.zkteco.zkbiosecurity.att.utils.AttDateUtils;
import com.zkteco.zkbiosecurity.att.vo.AttPersonItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseClientService;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AttPersonSchMessageUpload {
    @Autowired
    private AttTimeSlotService attTimeSlotService;
    @Autowired
    private AttPersonService attPersonService;
    @Autowired
    private AttPersonSchService attPersonSchService;
    @Autowired
    private AttShiftService attShiftService;
    @Autowired
    private BaseLicenseService baseLicenseService;
    @Autowired
    private BaseLicenseClientService baseLicenseClientService;

    public ZKResultMsg attPersonSchMessageUpload() {
        if (StringUtils.isNotBlank((CharSequence)this.baseLicenseService.getAppId())) {
            ZKMessage zkMessage = new ZKMessage();
            zkMessage.setAppId(this.baseLicenseService.getAppId());
            zkMessage.setModuleCode("att");
            zkMessage.setMessageId("attCloudShiftHandleMessage#handleAttPersonSchMessage");
            AttPersonItem attPersonItem = new AttPersonItem();
            attPersonItem.setIsAttendance(Boolean.valueOf(true));
            List attPersonItemList = this.attPersonService.getByCondition(attPersonItem);
            if (attPersonItemList != null && !attPersonItemList.isEmpty()) {
                Date endDate = new Date();
                int month = DateUtil.getMonth((Date)new Date()) + 1;
                int year = DateUtil.getYear((Date)new Date());
                Date startDate = AttDateUtils.getFirstDayOfMonth((int)year, (int)month);
                endDate = month == 12 ? AttDateUtils.getLastDayOfMonth((int)(year + 1), (int)1) : AttDateUtils.getLastDayOfMonth((int)year, (int)(month + 1));
                for (AttPersonItem attPerson : attPersonItemList) {
                    List attCloudPersonSchItems = this.attPersonSchService.getAttPersonSchToCloud(attPerson.getPersonId(), startDate, endDate);
                    if (attCloudPersonSchItems == null || attCloudPersonSchItems.isEmpty()) continue;
                    zkMessage.setListContent(attCloudPersonSchItems);
                    this.baseLicenseClientService.sendMessage(zkMessage);
                }
            }
        }
        return ZKResultMsg.successMsg();
    }
}

