/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.alibaba.fastjson.JSONArray;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.remote.ParkDeviceRemote;
import com.zkteco.zkbiosecurity.park.service.ParkDeviceService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.utils.ParkGetLocalIpAddrUtil;
import com.zkteco.zkbiosecurity.park.utils.ParkI18nUtil;
import com.zkteco.zkbiosecurity.park.vo.ParkDeviceItem;
import com.zkteco.zkbiosecurity.park.vo.ParkDeviceOpRecordItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkDeviceController
extends BaseController
implements ParkDeviceRemote {
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkParamsService parkParamsService;

    @RequiresPermissions(value={"park:device"})
    public ModelAndView index() {
        if ("lprCamera".equals(this.parkParamsService.getRunMode())) {
            this.parkDeviceService.isCreateFun();
            return new ModelAndView("park/device/parkDevice");
        }
        return new ModelAndView("park/accDoor/parkAccDoor");
    }

    @RequiresPermissions(value={"park:device:add"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.parkDeviceService.getItemById(id));
        }
        return new ModelAndView("park/device/editParkDevice");
    }

    @RequiresPermissions(value={"park:device:edit"})
    @LogRequest(module="park_module", object="park_device", opType="park_device_edit", requestParams={"name"}, opContent="park_device_name")
    public ZKResultMsg save(ParkDeviceItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String ret = this.parkDeviceService.saveItem(item);
        if (ret != "") {
            res.setRet("fail");
            if (ret.contains("over")) {
                String currDevCount = ret.substring(ret.indexOf("_") + 1, ret.length());
                res.setMsg(I18nUtil.i18nCode((String)"common_dev_maxCount", (Object[])new Object[]{currDevCount}));
            } else {
                res.setMsg(ret);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(ParkDeviceItem codition) {
        Pager pager = this.parkDeviceService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public DxGrid listByChannelId(ParkDeviceItem codition) {
        if (codition.getChannelId() == "" || codition.getChannelId() == null) {
            codition.setChannelId("-1");
        }
        Pager pager = this.parkDeviceService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"park:device:del"})
    @LogRequest(module="park_module", object="park_device", opType="park_device_del", requestParams={"names"}, opContent="park_device_del")
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkDeviceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isNotExist(@RequestParam(value="name", required=false) String name) {
        return this.parkDeviceService.isNotExist(name);
    }

    public boolean isNotExistIP(@RequestParam(value="ipAddress") String ipAddress) {
        return this.parkDeviceService.isNotExistIP(ipAddress);
    }

    public boolean isNotExistSn(String sn) {
        return this.parkDeviceService.isNotExistSn(sn);
    }

    @RequiresPermissions(value={"park:device:search"})
    public ModelAndView search() {
        return new ModelAndView("park/device/opParkSearchDev");
    }

    public ZKResultMsg startSearchDev() {
        this.parkDeviceService.startSearchDev();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg stopSearchDev() {
        this.parkDeviceService.stopSearchDev();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"park:device:disable"})
    @LogRequest(module="park_module", object="park_device", opType="common_disable", requestParams={"names"}, opContent="common_disable")
    public ZKResultMsg disable(@RequestParam(value="ids") String ids) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = this.parkDeviceService.disable(ids);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemList));
        return res;
    }

    @RequiresPermissions(value={"park:device:enable"})
    @LogRequest(module="park_module", object="park_device", opType="common_enable", requestParams={"names"}, opContent="common_enable")
    public ZKResultMsg enable(@RequestParam(value="ids") String ids) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = this.parkDeviceService.enable(ids);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemList));
        return res;
    }

    @RequiresPermissions(value={"park:device:getParameter"})
    @LogRequest(module="park_module", object="park_device", opType="common_dev_getDevOpt", requestParams={"names"}, opContent="common_dev_getDevOpt")
    public ZKResultMsg getParameter(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = this.parkDeviceService.getParameter(ids);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemList));
        return res;
    }

    @RequiresPermissions(value={"park:device:getVersion"})
    @LogRequest(module="park_module", object="park_device", opType="park_device_getVersion", requestParams={"names"}, opContent="park_device_getVersion")
    public ZKResultMsg readDevVerInfo(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = this.parkDeviceService.readDevVerInfo(ids);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemList));
        return res;
    }

    public ZKResultMsg getByEditIdAndOtherId(@RequestParam(value="editId") String editId, @RequestParam(value="otherId") String otherId) {
        List selectItems = this.parkDeviceService.getByEditIdAndOtherId(editId, otherId);
        return new ZKResultMsg((Object)selectItems);
    }

    public ZKResultMsg getByPavilioIpAddress() {
        List parkDeviceItemList = this.parkDeviceService.getByPavilioIpAddress(ParkGetLocalIpAddrUtil.getClientIpAddr(this.request));
        return new ZKResultMsg((Object)parkDeviceItemList);
    }

    public ZKResultMsg getOnlineByPavilioIpAddress() {
        List parkDeviceItemList = this.parkDeviceService.getOnlineByPavilioIpAddress(ParkGetLocalIpAddrUtil.getClientIpAddr(this.request));
        return new ZKResultMsg((Object)parkDeviceItemList);
    }

    public ZKResultMsg getAllDevice() {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceItemList = this.parkDeviceService.findAll();
        res.setData((Object)parkDeviceItemList);
        return res;
    }

    public ZKResultMsg syncParams(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = this.parkDeviceService.syncParams(ids);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemList));
        return res;
    }

    public ZKResultMsg syncBlack(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = this.parkDeviceService.syncBlack(ids);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemList));
        return res;
    }

    public ZKResultMsg syncWhite(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = this.parkDeviceService.syncWhite(ids);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemList));
        return res;
    }

    public ZKResultMsg syncAuth(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = this.parkDeviceService.syncAuth(ids);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemList));
        return res;
    }

    public ZKResultMsg syncCharging(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = this.parkDeviceService.syncCharging(ids);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemList));
        return res;
    }

    @RequiresPermissions(value={"park:device:synTime"})
    @LogRequest(module="park_module", object="park_device", opType="park_device_syncTime", requestParams={"names"}, opContent="park_device_syncTime")
    public ZKResultMsg syncTime(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = this.parkDeviceService.syncTime(ids);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemList));
        return res;
    }

    public ZKResultMsg readParams(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = this.parkDeviceService.readParams(ids);
        ParkI18nUtil.setOfflineParamI18n(parkDeviceOpRecordItemList);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemList));
        return res;
    }

    public ZKResultMsg readBlack(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = this.parkDeviceService.readPlateList(ids, 1);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemList));
        return res;
    }

    public ZKResultMsg readWhite(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = this.parkDeviceService.readPlateList(ids, 0);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemList));
        return res;
    }

    public ZKResultMsg readAuth(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = this.parkDeviceService.readPlateList(ids, 2);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemList));
        return res;
    }

    public ZKResultMsg readCharging(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = this.parkDeviceService.readCharging(ids);
        for (ParkDeviceOpRecordItem parkDeviceResult : parkDeviceOpRecordItemList) {
            if (parkDeviceResult.getData() == null || "".equals(parkDeviceResult.getData())) continue;
            JSONArray jsonArray = new JSONArray();
            String[] chargingArray = parkDeviceResult.getData().toString().split(";");
            for (int i = 0; i < chargingArray.length; ++i) {
                if (i == 0) {
                    jsonArray.add((Object)ParkI18nUtil.setChargeI18n(chargingArray[i]));
                    continue;
                }
                jsonArray.add((Object)ParkI18nUtil.setChargeExtendI18n(chargingArray[i]));
            }
            parkDeviceResult.setData((Object)jsonArray.toString());
        }
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemList));
        return res;
    }

    public ZKResultMsg readVersion(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = this.parkDeviceService.readVersion();
        res.setData(ParkI18nUtil.setVersionParamI18n(parkDeviceOpRecordItemList));
        return res;
    }

    public ZKResultMsg cleanBlack(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = this.parkDeviceService.cleanBlack(ids);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemList));
        return res;
    }

    public ZKResultMsg cleanWhite(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = this.parkDeviceService.cleanWhite(ids);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemList));
        return res;
    }

    public ZKResultMsg cleanAuth(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = this.parkDeviceService.cleanAuth(ids);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemList));
        return res;
    }

    public ZKResultMsg cleanCharging(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = this.parkDeviceService.cleanCharging(ids);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemList));
        return res;
    }

    public ZKResultMsg recovery(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = this.parkDeviceService.recovery(ids);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemList));
        return res;
    }

    public ZKResultMsg getByPavilioId(String pavilioId) {
        List parkDeviceItemList = this.parkDeviceService.getByPavilioId(pavilioId);
        return new ZKResultMsg((Object)parkDeviceItemList);
    }
}

