/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.remote.ParkAccDoorRemote;
import com.zkteco.zkbiosecurity.park.service.ParkAccDoorService;
import com.zkteco.zkbiosecurity.park.vo.ParkAccDoorItem;
import com.zkteco.zkbiosecurity.park.vo.ParkSelectAccDoorItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkAccDoorController
extends BaseController
implements ParkAccDoorRemote {
    @Autowired
    private ParkAccDoorService parkAccDoorService;

    @RequiresPermissions(value={"park:device"})
    public ModelAndView index() {
        return new ModelAndView("park/accDoor/parkAccDoor");
    }

    @RequiresPermissions(value={"park:device:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.parkAccDoorService.getItemById(id));
        }
        return new ModelAndView("park/accDoor/editParkAccDoor");
    }

    @RequiresPermissions(value={"park:device:edit"})
    @LogRequest(module="park_module", object="park_device", opType="park_device_edit", requestParams={"name"}, opContent="park_device_name")
    public ZKResultMsg save(ParkAccDoorItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.parkAccDoorService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(ParkAccDoorItem codition) {
        Pager pager = this.parkAccDoorService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="park_module", object="park_device", opType="park_device_del", requestParams={"names"}, opContent="park_device_del")
    @RequiresPermissions(value={"park:device:del"})
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkAccDoorService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isNotExist(String name) {
        return this.parkAccDoorService.isNotExist(name);
    }

    public DxGrid getSelectAccDoorList(ParkSelectAccDoorItem condition) {
        Pager pager = this.parkAccDoorService.getSelectAccDoorList(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg getSelectItem(String editId) {
        List selectItems = this.parkAccDoorService.getSelectItem(editId);
        return new ZKResultMsg((Object)selectItems);
    }
}

