/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.patrol.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.patrol.remote.PatrolRouteRemote;
import com.zkteco.zkbiosecurity.patrol.service.PatrolRouteService;
import com.zkteco.zkbiosecurity.patrol.vo.PatrolRouteItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PatrolRouteController
extends BaseController
implements PatrolRouteRemote {
    @Autowired
    private PatrolRouteService patrolRouteService;

    @RequiresPermissions(value={"patrol:route"})
    public ModelAndView index() {
        return new ModelAndView("patrol/route/patrolRoute");
    }

    @RequiresPermissions(value={"patrol:route:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.patrolRouteService.convertRoutePatrolPersons(this.patrolRouteService.getItemById(id)));
        }
        return new ModelAndView("patrol/route/editPatrolRoute");
    }

    @RequiresPermissions(value={"patrol:route:edit"})
    @LogRequest(module="patrol_module", object="patrol_leftMenu_patrolRoute", opType="common_op_edit", requestParams={"name"}, opContent="common_op_edit")
    public ZKResultMsg save(PatrolRouteItem item) {
        this.patrolRouteService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"patrol:route:refresh"})
    public DxGrid list(PatrolRouteItem condition) {
        Pager pager = this.patrolRouteService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"patrol:route:del"})
    @LogRequest(module="patrol_module", object="patrol_leftMenu_patrolRoute", opType="common_op_del", requestParams={"name"}, opContent="common_op_del")
    public ZKResultMsg del(String ids) {
        this.patrolRouteService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public TreeItem getPatrolRouteTree() {
        List patrolRouteItems = this.patrolRouteService.getByCondition(new PatrolRouteItem());
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        for (PatrolRouteItem patrolRouteItem : patrolRouteItems) {
            item = new TreeItem();
            item.setId(patrolRouteItem.getId());
            item.setText(patrolRouteItem.getName());
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public String valid(String name) {
        PatrolRouteItem item = this.patrolRouteService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    public String checkRoundMinute() {
        String planId = this.request.getParameter("planId");
        String time = this.request.getParameter("timeValue");
        long timeValue = StringUtils.isNotBlank((CharSequence)time) ? Long.parseLong(time) : 0L;
        boolean flag = this.patrolRouteService.checkRoundMinute(planId, timeValue);
        return flag + "";
    }

    public String checkTime() {
        String planId = this.request.getParameter("planId");
        long deviationTime = Long.parseLong(this.request.getParameter("deviationTime"));
        long timeout = 0L;
        boolean flag = this.patrolRouteService.checkTime(planId, deviationTime, timeout);
        return flag + "";
    }

    @RequiresPermissions(value={"patrol:route:enable"})
    @LogRequest(module="patrol_module", object="patrol_leftMenu_patrolRoute", opType="patrol_route_enable", requestParams={"ids"}, opContent="patrol_route_enable")
    public ZKResultMsg setRouteEnable(String ids) {
        this.patrolRouteService.setRouteEnable(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"patrol:route:disable"})
    @LogRequest(module="patrol_module", object="patrol_leftMenu_patrolRoute", opType="patrol_route_disable", requestParams={"ids"}, opContent="patrol_route_disable")
    public ZKResultMsg setRouteDisable(String ids) {
        this.patrolRouteService.setRouteDisable(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

