/*
 * Decompiled with CFR 0.152.
 */
package sun.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.peer.ComponentPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.RepaintManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import sun.awt.AWTAccessor;
import sun.awt.DisplayChangedListener;
import sun.awt.LightweightFrame;
import sun.awt.OverrideNativeWindowHandle;
import sun.security.action.GetPropertyAction;
import sun.swing.LightweightContent;
import sun.swing.SwingAccessor;
import sun.swing.SwingUtilities2;

public final class JLightweightFrame
extends LightweightFrame
implements RootPaneContainer {
    private final JRootPane rootPane = new JRootPane();
    private LightweightContent content;
    private Component component;
    private JPanel contentPane;
    private BufferedImage bbImage;
    private volatile int scaleFactor = 1;
    private static boolean copyBufferEnabled;
    private int[] copyBuffer;
    private PropertyChangeListener layoutSizeListener;
    private SwingUtilities2.RepaintListener repaintListener;

    public JLightweightFrame() {
        copyBufferEnabled = "true".equals(AccessController.doPrivileged(new GetPropertyAction("swing.jlf.copyBufferEnabled", "true")));
        this.add((Component)this.rootPane, "Center");
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        if (this.getGraphicsConfiguration().isTranslucencyCapable()) {
            this.setBackground(new Color(0, 0, 0, 0));
        }
        this.layoutSizeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Dimension d = (Dimension)e.getNewValue();
                if ("preferredSize".equals(e.getPropertyName())) {
                    JLightweightFrame.this.content.preferredSizeChanged(d.width, d.height);
                } else if ("maximumSize".equals(e.getPropertyName())) {
                    JLightweightFrame.this.content.maximumSizeChanged(d.width, d.height);
                } else if ("minimumSize".equals(e.getPropertyName())) {
                    JLightweightFrame.this.content.minimumSizeChanged(d.width, d.height);
                }
            }
        };
        this.repaintListener = (c, x, y, w, h) -> {
            Window jlf = SwingUtilities.getWindowAncestor(c);
            if (jlf != this) {
                return;
            }
            Point p = SwingUtilities.convertPoint(c, x, y, jlf);
            Rectangle r = new Rectangle(p.x, p.y, w, h).intersection(new Rectangle(0, 0, this.bbImage.getWidth() / this.scaleFactor, this.bbImage.getHeight() / this.scaleFactor));
            if (!r.isEmpty()) {
                this.notifyImageUpdated(r.x, r.y, r.width, r.height);
            }
        };
        SwingAccessor.getRepaintManagerAccessor().addRepaintListener(RepaintManager.currentManager(this), this.repaintListener);
    }

    @Override
    public void dispose() {
        SwingAccessor.getRepaintManagerAccessor().removeRepaintListener(RepaintManager.currentManager(this), this.repaintListener);
        super.dispose();
    }

    public void setContent(LightweightContent content) {
        if (content == null) {
            System.err.println("JLightweightFrame.setContent: content may not be null!");
            return;
        }
        this.content = content;
        this.component = content.getComponent();
        Dimension d = this.component.getPreferredSize();
        content.preferredSizeChanged(d.width, d.height);
        d = this.component.getMaximumSize();
        content.maximumSizeChanged(d.width, d.height);
        d = this.component.getMinimumSize();
        content.minimumSizeChanged(d.width, d.height);
        this.initInterior();
    }

    @Override
    public Graphics getGraphics() {
        if (this.bbImage == null) {
            return null;
        }
        Graphics2D g = this.bbImage.createGraphics();
        g.setBackground(this.getBackground());
        g.setColor(this.getForeground());
        g.setFont(this.getFont());
        g.scale(this.scaleFactor, this.scaleFactor);
        return g;
    }

    @Override
    public void grabFocus() {
        if (this.content != null) {
            this.content.focusGrabbed();
        }
    }

    @Override
    public void ungrabFocus() {
        if (this.content != null) {
            this.content.focusUngrabbed();
        }
    }

    @Override
    public int getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public void notifyDisplayChanged(int scaleFactor) {
        if (scaleFactor != this.scaleFactor) {
            if (!copyBufferEnabled) {
                this.content.paintLock();
            }
            try {
                if (this.bbImage != null) {
                    this.resizeBuffer(this.getWidth(), this.getHeight(), scaleFactor);
                }
            }
            finally {
                if (!copyBufferEnabled) {
                    this.content.paintUnlock();
                }
            }
            this.scaleFactor = scaleFactor;
        }
        if (this.getPeer() instanceof DisplayChangedListener) {
            ((DisplayChangedListener)((Object)this.getPeer())).displayChanged();
        }
        this.repaint();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.getPeer() instanceof DisplayChangedListener) {
            ((DisplayChangedListener)((Object)this.getPeer())).displayChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncCopyBuffer(boolean reset, int x, int y, int w, int h, int scale) {
        this.content.paintLock();
        try {
            int[] srcBuffer = ((DataBufferInt)this.bbImage.getRaster().getDataBuffer()).getData();
            if (reset) {
                this.copyBuffer = new int[srcBuffer.length];
            }
            int linestride = this.bbImage.getWidth();
            x *= scale;
            y *= scale;
            w *= scale;
            h *= scale;
            for (int i = 0; i < h; ++i) {
                int from = (y + i) * linestride + x;
                System.arraycopy(srcBuffer, from, this.copyBuffer, from, w);
            }
        }
        finally {
            this.content.paintUnlock();
        }
    }

    private void notifyImageUpdated(int x, int y, int width, int height) {
        if (copyBufferEnabled) {
            this.syncCopyBuffer(false, x, y, width, height, this.scaleFactor);
        }
        this.content.imageUpdated(x, y, width, height);
    }

    private void initInterior() {
        this.contentPane = new JPanel(){

            @Override
            public void paint(Graphics g) {
                if (!copyBufferEnabled) {
                    JLightweightFrame.this.content.paintLock();
                }
                try {
                    super.paint(g);
                    final Rectangle clip = g.getClipBounds() != null ? g.getClipBounds() : new Rectangle(0, 0, JLightweightFrame.this.contentPane.getWidth(), JLightweightFrame.this.contentPane.getHeight());
                    clip.x = Math.max(0, clip.x);
                    clip.y = Math.max(0, clip.y);
                    clip.width = Math.min(JLightweightFrame.this.contentPane.getWidth(), clip.width);
                    clip.height = Math.min(JLightweightFrame.this.contentPane.getHeight(), clip.height);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Rectangle c = JLightweightFrame.this.contentPane.getBounds().intersection(clip);
                            JLightweightFrame.this.notifyImageUpdated(c.x, c.y, c.width, c.height);
                        }
                    });
                }
                finally {
                    if (!copyBufferEnabled) {
                        JLightweightFrame.this.content.paintUnlock();
                    }
                }
            }

            @Override
            protected boolean isPaintingOrigin() {
                return true;
            }
        };
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add(this.component);
        if ("true".equals(AccessController.doPrivileged(new GetPropertyAction("swing.jlf.contentPaneTransparent", "false")))) {
            this.contentPane.setOpaque(false);
        }
        this.setContentPane(this.contentPane);
        this.contentPane.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Component c = JLightweightFrame.this.component;
                if (e.getChild() == c) {
                    c.addPropertyChangeListener("preferredSize", JLightweightFrame.this.layoutSizeListener);
                    c.addPropertyChangeListener("maximumSize", JLightweightFrame.this.layoutSizeListener);
                    c.addPropertyChangeListener("minimumSize", JLightweightFrame.this.layoutSizeListener);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Component c = JLightweightFrame.this.component;
                if (e.getChild() == c) {
                    c.removePropertyChangeListener(JLightweightFrame.this.layoutSizeListener);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        if (width == 0 || height == 0) {
            return;
        }
        if (!copyBufferEnabled) {
            this.content.paintLock();
        }
        try {
            boolean createBB = this.bbImage == null;
            int newW = width;
            int newH = height;
            if (this.bbImage != null) {
                int imgWidth = this.bbImage.getWidth() / this.scaleFactor;
                int imgHeight = this.bbImage.getHeight() / this.scaleFactor;
                if (width != imgWidth || height != imgHeight) {
                    createBB = true;
                    if (this.bbImage != null) {
                        int oldW = imgWidth;
                        int oldH = imgHeight;
                        if (oldW >= newW && oldH >= newH) {
                            createBB = false;
                        } else {
                            newW = oldW >= newW ? oldW : Math.max((int)((double)oldW * 1.2), width);
                            newH = oldH >= newH ? oldH : Math.max((int)((double)oldH * 1.2), height);
                        }
                    }
                }
            }
            if (createBB) {
                this.resizeBuffer(newW, newH, this.scaleFactor);
                return;
            }
            this.content.imageReshaped(0, 0, width, height);
        }
        finally {
            if (!copyBufferEnabled) {
                this.content.paintUnlock();
            }
        }
    }

    private void resizeBuffer(int width, int height, int newScaleFactor) {
        this.bbImage = new BufferedImage(width * newScaleFactor, height * newScaleFactor, 3);
        int[] pixels = ((DataBufferInt)this.bbImage.getRaster().getDataBuffer()).getData();
        if (copyBufferEnabled) {
            this.syncCopyBuffer(true, 0, 0, width, height, newScaleFactor);
            pixels = this.copyBuffer;
        }
        this.content.imageBufferReset(pixels, 0, 0, width, height, width * newScaleFactor, newScaleFactor);
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    @Override
    public void setContentPane(Container contentPane) {
        this.getRootPane().setContentPane(contentPane);
    }

    @Override
    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    @Override
    public void setLayeredPane(JLayeredPane layeredPane) {
        this.getRootPane().setLayeredPane(layeredPane);
    }

    @Override
    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    @Override
    public void setGlassPane(Component glassPane) {
        this.getRootPane().setGlassPane(glassPane);
    }

    @Override
    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    private void updateClientCursor() {
        Point p = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(p, this);
        Component target = SwingUtilities.getDeepestComponentAt(this, p.x, p.y);
        if (target != null) {
            this.content.setCursor(target.getCursor());
        }
    }

    public void overrideNativeWindowHandle(long handle, Runnable closeWindow) {
        ComponentPeer peer = AWTAccessor.getComponentAccessor().getPeer(this);
        if (peer instanceof OverrideNativeWindowHandle) {
            ((OverrideNativeWindowHandle)((Object)peer)).overrideWindowHandle(handle);
        }
        if (closeWindow != null) {
            closeWindow.run();
        }
    }

    @Override
    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> abstractRecognizerClass, DragSource ds, Component c, int srcActions, DragGestureListener dgl) {
        return this.content == null ? null : (T)this.content.createDragGestureRecognizer(abstractRecognizerClass, ds, c, srcActions, dgl);
    }

    @Override
    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dge) throws InvalidDnDOperationException {
        return this.content == null ? null : this.content.createDragSourceContextPeer(dge);
    }

    @Override
    public void addDropTarget(DropTarget dt) {
        if (this.content == null) {
            return;
        }
        this.content.addDropTarget(dt);
    }

    @Override
    public void removeDropTarget(DropTarget dt) {
        if (this.content == null) {
            return;
        }
        this.content.removeDropTarget(dt);
    }

    static {
        SwingAccessor.setJLightweightFrameAccessor(new SwingAccessor.JLightweightFrameAccessor(){

            @Override
            public void updateCursor(JLightweightFrame frame) {
                frame.updateClientCursor();
            }
        });
        copyBufferEnabled = "true".equals(AccessController.doPrivileged(new GetPropertyAction("swing.jlf.copyBufferEnabled", "true")));
    }
}

