/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.PrivilegedAction;
import sun.misc.Cleaner;

public final class Perf {
    private static Perf instance;
    private static final int PERF_MODE_RO = 0;
    private static final int PERF_MODE_RW = 1;

    private Perf() {
    }

    public static Perf getPerf() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            RuntimePermission perm = new RuntimePermission("sun.misc.Perf.getPerf");
            security.checkPermission(perm);
        }
        return instance;
    }

    public ByteBuffer attach(int lvmid, String mode) throws IllegalArgumentException, IOException {
        if (mode.compareTo("r") == 0) {
            return this.attachImpl(null, lvmid, 0);
        }
        if (mode.compareTo("rw") == 0) {
            return this.attachImpl(null, lvmid, 1);
        }
        throw new IllegalArgumentException("unknown mode");
    }

    public ByteBuffer attach(String user, int lvmid, String mode) throws IllegalArgumentException, IOException {
        if (mode.compareTo("r") == 0) {
            return this.attachImpl(user, lvmid, 0);
        }
        if (mode.compareTo("rw") == 0) {
            return this.attachImpl(user, lvmid, 1);
        }
        throw new IllegalArgumentException("unknown mode");
    }

    private ByteBuffer attachImpl(String user, int lvmid, int mode) throws IllegalArgumentException, IOException {
        final ByteBuffer b = this.attach(user, lvmid, mode);
        if (lvmid == 0) {
            return b;
        }
        ByteBuffer dup = b.duplicate();
        Cleaner.create(dup, new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        instance.detach(b);
                    }
                    catch (Throwable th) {
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError((Object)th.toString());
                    }
                }
            }
        });
        return dup;
    }

    private native ByteBuffer attach(String var1, int var2, int var3) throws IllegalArgumentException, IOException;

    private native void detach(ByteBuffer var1);

    public native ByteBuffer createLong(String var1, int var2, int var3, long var4);

    public ByteBuffer createString(String name, int variability, int units, String value, int maxLength) {
        byte[] v = Perf.getBytes(value);
        byte[] v1 = new byte[v.length + 1];
        System.arraycopy(v, 0, v1, 0, v.length);
        v1[v.length] = 0;
        return this.createByteArray(name, variability, units, v1, Math.max(v1.length, maxLength));
    }

    public ByteBuffer createString(String name, int variability, int units, String value) {
        byte[] v = Perf.getBytes(value);
        byte[] v1 = new byte[v.length + 1];
        System.arraycopy(v, 0, v1, 0, v.length);
        v1[v.length] = 0;
        return this.createByteArray(name, variability, units, v1, v1.length);
    }

    public native ByteBuffer createByteArray(String var1, int var2, int var3, byte[] var4, int var5);

    private static byte[] getBytes(String s) {
        byte[] bytes = null;
        try {
            bytes = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return bytes;
    }

    public native long highResCounter();

    public native long highResFrequency();

    private static native void registerNatives();

    static {
        Perf.registerNatives();
        instance = new Perf();
    }

    public static class GetPerfAction
    implements PrivilegedAction<Perf> {
        @Override
        public Perf run() {
            return Perf.getPerf();
        }
    }
}

