/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.DiagnosticCommandMBean;
import com.sun.management.HotSpotDiagnosticMXBean;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.PlatformLoggingMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import sun.management.ClassLoadingImpl;
import sun.management.CompilationImpl;
import sun.management.DiagnosticCommandImpl;
import sun.management.HotSpotDiagnostic;
import sun.management.HotspotClassLoading;
import sun.management.HotspotClassLoadingMBean;
import sun.management.HotspotCompilation;
import sun.management.HotspotCompilationMBean;
import sun.management.HotspotMemory;
import sun.management.HotspotMemoryMBean;
import sun.management.HotspotRuntime;
import sun.management.HotspotRuntimeMBean;
import sun.management.HotspotThread;
import sun.management.HotspotThreadMBean;
import sun.management.MemoryImpl;
import sun.management.OperatingSystemImpl;
import sun.management.RuntimeImpl;
import sun.management.ThreadImpl;
import sun.management.Util;
import sun.management.VMManagement;
import sun.management.VMManagementImpl;
import sun.misc.JavaNioAccess;
import sun.misc.SharedSecrets;
import sun.misc.VM;
import sun.nio.ch.FileChannelImpl;
import sun.util.logging.LoggingSupport;

public class ManagementFactoryHelper {
    private static VMManagement jvm;
    private static ClassLoadingImpl classMBean;
    private static MemoryImpl memoryMBean;
    private static ThreadImpl threadMBean;
    private static RuntimeImpl runtimeMBean;
    private static CompilationImpl compileMBean;
    private static OperatingSystemImpl osMBean;
    private static List<BufferPoolMXBean> bufferPools;
    private static final String BUFFER_POOL_MXBEAN_NAME = "java.nio:type=BufferPool";
    private static HotSpotDiagnostic hsDiagMBean;
    private static HotspotRuntime hsRuntimeMBean;
    private static HotspotClassLoading hsClassMBean;
    private static HotspotThread hsThreadMBean;
    private static HotspotCompilation hsCompileMBean;
    private static HotspotMemory hsMemoryMBean;
    private static DiagnosticCommandImpl hsDiagCommandMBean;
    private static final String HOTSPOT_CLASS_LOADING_MBEAN_NAME = "sun.management:type=HotspotClassLoading";
    private static final String HOTSPOT_COMPILATION_MBEAN_NAME = "sun.management:type=HotspotCompilation";
    private static final String HOTSPOT_MEMORY_MBEAN_NAME = "sun.management:type=HotspotMemory";
    private static final String HOTSPOT_RUNTIME_MBEAN_NAME = "sun.management:type=HotspotRuntime";
    private static final String HOTSPOT_THREAD_MBEAN_NAME = "sun.management:type=HotspotThreading";
    static final String HOTSPOT_DIAGNOSTIC_COMMAND_MBEAN_NAME = "com.sun.management:type=DiagnosticCommand";
    private static final int JMM_THREAD_STATE_FLAG_MASK = -1048576;
    private static final int JMM_THREAD_STATE_FLAG_SUSPENDED = 0x100000;
    private static final int JMM_THREAD_STATE_FLAG_NATIVE = 0x400000;

    private ManagementFactoryHelper() {
    }

    public static synchronized ClassLoadingMXBean getClassLoadingMXBean() {
        if (classMBean == null) {
            classMBean = new ClassLoadingImpl(jvm);
        }
        return classMBean;
    }

    public static synchronized MemoryMXBean getMemoryMXBean() {
        if (memoryMBean == null) {
            memoryMBean = new MemoryImpl(jvm);
        }
        return memoryMBean;
    }

    public static synchronized ThreadMXBean getThreadMXBean() {
        if (threadMBean == null) {
            threadMBean = new ThreadImpl(jvm);
        }
        return threadMBean;
    }

    public static synchronized RuntimeMXBean getRuntimeMXBean() {
        if (runtimeMBean == null) {
            runtimeMBean = new RuntimeImpl(jvm);
        }
        return runtimeMBean;
    }

    public static synchronized CompilationMXBean getCompilationMXBean() {
        if (compileMBean == null && jvm.getCompilerName() != null) {
            compileMBean = new CompilationImpl(jvm);
        }
        return compileMBean;
    }

    public static synchronized OperatingSystemMXBean getOperatingSystemMXBean() {
        if (osMBean == null) {
            osMBean = new OperatingSystemImpl(jvm);
        }
        return osMBean;
    }

    public static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        MemoryPoolMXBean[] pools = MemoryImpl.getMemoryPools();
        ArrayList<MemoryPoolMXBean> list = new ArrayList<MemoryPoolMXBean>(pools.length);
        for (MemoryPoolMXBean p : pools) {
            list.add(p);
        }
        return list;
    }

    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        MemoryManagerMXBean[] mgrs = MemoryImpl.getMemoryManagers();
        ArrayList<MemoryManagerMXBean> result = new ArrayList<MemoryManagerMXBean>(mgrs.length);
        for (MemoryManagerMXBean m : mgrs) {
            result.add(m);
        }
        return result;
    }

    public static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        MemoryManagerMXBean[] mgrs = MemoryImpl.getMemoryManagers();
        ArrayList<GarbageCollectorMXBean> result = new ArrayList<GarbageCollectorMXBean>(mgrs.length);
        for (MemoryManagerMXBean m : mgrs) {
            if (!GarbageCollectorMXBean.class.isInstance(m)) continue;
            result.add((GarbageCollectorMXBean)GarbageCollectorMXBean.class.cast(m));
        }
        return result;
    }

    public static PlatformLoggingMXBean getPlatformLoggingMXBean() {
        if (LoggingSupport.isAvailable()) {
            return PlatformLoggingImpl.instance;
        }
        return null;
    }

    public static synchronized List<BufferPoolMXBean> getBufferPoolMXBeans() {
        if (bufferPools == null) {
            bufferPools = new ArrayList<BufferPoolMXBean>(2);
            bufferPools.add(ManagementFactoryHelper.createBufferPoolMXBean(SharedSecrets.getJavaNioAccess().getDirectBufferPool()));
            bufferPools.add(ManagementFactoryHelper.createBufferPoolMXBean(FileChannelImpl.getMappedBufferPool()));
        }
        return bufferPools;
    }

    private static BufferPoolMXBean createBufferPoolMXBean(final JavaNioAccess.BufferPool pool) {
        return new BufferPoolMXBean(){
            private volatile ObjectName objname;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ObjectName getObjectName() {
                ObjectName result = this.objname;
                if (result == null) {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        result = this.objname;
                        if (result == null) {
                            this.objname = result = Util.newObjectName("java.nio:type=BufferPool,name=" + pool.getName());
                        }
                    }
                }
                return result;
            }

            @Override
            public String getName() {
                return pool.getName();
            }

            @Override
            public long getCount() {
                return pool.getCount();
            }

            @Override
            public long getTotalCapacity() {
                return pool.getTotalCapacity();
            }

            @Override
            public long getMemoryUsed() {
                return pool.getMemoryUsed();
            }
        };
    }

    public static synchronized HotSpotDiagnosticMXBean getDiagnosticMXBean() {
        if (hsDiagMBean == null) {
            hsDiagMBean = new HotSpotDiagnostic();
        }
        return hsDiagMBean;
    }

    public static synchronized HotspotRuntimeMBean getHotspotRuntimeMBean() {
        if (hsRuntimeMBean == null) {
            hsRuntimeMBean = new HotspotRuntime(jvm);
        }
        return hsRuntimeMBean;
    }

    public static synchronized HotspotClassLoadingMBean getHotspotClassLoadingMBean() {
        if (hsClassMBean == null) {
            hsClassMBean = new HotspotClassLoading(jvm);
        }
        return hsClassMBean;
    }

    public static synchronized HotspotThreadMBean getHotspotThreadMBean() {
        if (hsThreadMBean == null) {
            hsThreadMBean = new HotspotThread(jvm);
        }
        return hsThreadMBean;
    }

    public static synchronized HotspotMemoryMBean getHotspotMemoryMBean() {
        if (hsMemoryMBean == null) {
            hsMemoryMBean = new HotspotMemory(jvm);
        }
        return hsMemoryMBean;
    }

    public static synchronized DiagnosticCommandMBean getDiagnosticCommandMBean() {
        if (hsDiagCommandMBean == null && jvm.isRemoteDiagnosticCommandsSupported()) {
            hsDiagCommandMBean = new DiagnosticCommandImpl(jvm);
        }
        return hsDiagCommandMBean;
    }

    public static synchronized HotspotCompilationMBean getHotspotCompilationMBean() {
        if (hsCompileMBean == null) {
            hsCompileMBean = new HotspotCompilation(jvm);
        }
        return hsCompileMBean;
    }

    private static void addMBean(MBeanServer mbs, Object mbean, String mbeanName) {
        try {
            final ObjectName objName = Util.newObjectName(mbeanName);
            final MBeanServer mbs0 = mbs;
            final Object mbean0 = mbean;
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws MBeanRegistrationException, NotCompliantMBeanException {
                    try {
                        mbs0.registerMBean(mbean0, objName);
                        return null;
                    }
                    catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                        return null;
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw Util.newException(e.getException());
        }
    }

    public static HashMap<ObjectName, DynamicMBean> getPlatformDynamicMBeans() {
        HashMap<ObjectName, DynamicMBean> map = new HashMap<ObjectName, DynamicMBean>();
        DiagnosticCommandMBean diagMBean = ManagementFactoryHelper.getDiagnosticCommandMBean();
        if (diagMBean != null) {
            map.put(Util.newObjectName(HOTSPOT_DIAGNOSTIC_COMMAND_MBEAN_NAME), diagMBean);
        }
        return map;
    }

    static void registerInternalMBeans(MBeanServer mbs) {
        ManagementFactoryHelper.addMBean(mbs, ManagementFactoryHelper.getHotspotClassLoadingMBean(), HOTSPOT_CLASS_LOADING_MBEAN_NAME);
        ManagementFactoryHelper.addMBean(mbs, ManagementFactoryHelper.getHotspotMemoryMBean(), HOTSPOT_MEMORY_MBEAN_NAME);
        ManagementFactoryHelper.addMBean(mbs, ManagementFactoryHelper.getHotspotRuntimeMBean(), HOTSPOT_RUNTIME_MBEAN_NAME);
        ManagementFactoryHelper.addMBean(mbs, ManagementFactoryHelper.getHotspotThreadMBean(), HOTSPOT_THREAD_MBEAN_NAME);
        if (ManagementFactoryHelper.getCompilationMXBean() != null) {
            ManagementFactoryHelper.addMBean(mbs, ManagementFactoryHelper.getHotspotCompilationMBean(), HOTSPOT_COMPILATION_MBEAN_NAME);
        }
    }

    private static void unregisterMBean(MBeanServer mbs, String mbeanName) {
        try {
            final ObjectName objName = Util.newObjectName(mbeanName);
            final MBeanServer mbs0 = mbs;
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws MBeanRegistrationException, RuntimeOperationsException {
                    try {
                        mbs0.unregisterMBean(objName);
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw Util.newException(e.getException());
        }
    }

    static void unregisterInternalMBeans(MBeanServer mbs) {
        ManagementFactoryHelper.unregisterMBean(mbs, HOTSPOT_CLASS_LOADING_MBEAN_NAME);
        ManagementFactoryHelper.unregisterMBean(mbs, HOTSPOT_MEMORY_MBEAN_NAME);
        ManagementFactoryHelper.unregisterMBean(mbs, HOTSPOT_RUNTIME_MBEAN_NAME);
        ManagementFactoryHelper.unregisterMBean(mbs, HOTSPOT_THREAD_MBEAN_NAME);
        if (ManagementFactoryHelper.getCompilationMXBean() != null) {
            ManagementFactoryHelper.unregisterMBean(mbs, HOTSPOT_COMPILATION_MBEAN_NAME);
        }
    }

    public static boolean isThreadSuspended(int state) {
        return (state & 0x100000) != 0;
    }

    public static boolean isThreadRunningNative(int state) {
        return (state & 0x400000) != 0;
    }

    public static Thread.State toThreadState(int state) {
        int threadStatus = state & 0xFFFFF;
        return VM.toThreadState(threadStatus);
    }

    static {
        classMBean = null;
        memoryMBean = null;
        threadMBean = null;
        runtimeMBean = null;
        compileMBean = null;
        osMBean = null;
        bufferPools = null;
        hsDiagMBean = null;
        hsRuntimeMBean = null;
        hsClassMBean = null;
        hsThreadMBean = null;
        hsCompileMBean = null;
        hsMemoryMBean = null;
        hsDiagCommandMBean = null;
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("management");
                return null;
            }
        });
        jvm = new VMManagementImpl();
    }

    static class PlatformLoggingImpl
    implements LoggingMXBean {
        static final PlatformLoggingMXBean instance = new PlatformLoggingImpl();
        static final String LOGGING_MXBEAN_NAME = "java.util.logging:type=Logging";
        private volatile ObjectName objname;

        PlatformLoggingImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectName getObjectName() {
            ObjectName result = this.objname;
            if (result == null) {
                PlatformLoggingImpl platformLoggingImpl = this;
                synchronized (platformLoggingImpl) {
                    result = this.objname;
                    if (result == null) {
                        this.objname = result = Util.newObjectName(LOGGING_MXBEAN_NAME);
                    }
                }
            }
            return result;
        }

        @Override
        public List<String> getLoggerNames() {
            return LoggingSupport.getLoggerNames();
        }

        @Override
        public String getLoggerLevel(String loggerName) {
            return LoggingSupport.getLoggerLevel(loggerName);
        }

        @Override
        public void setLoggerLevel(String loggerName, String levelName) {
            LoggingSupport.setLoggerLevel(loggerName, levelName);
        }

        @Override
        public String getParentLoggerName(String loggerName) {
            return LoggingSupport.getParentLoggerName(loggerName);
        }
    }

    public static interface LoggingMXBean
    extends PlatformLoggingMXBean,
    java.util.logging.LoggingMXBean {
    }
}

