/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.cmm;

import java.awt.color.CMMException;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceLoader;
import sun.java2d.cmm.CMMServiceProvider;
import sun.java2d.cmm.ColorTransform;
import sun.java2d.cmm.PCMM;
import sun.java2d.cmm.Profile;
import sun.security.action.GetPropertyAction;

public class CMSManager {
    public static ColorSpace GRAYspace;
    public static ColorSpace LINEAR_RGBspace;
    private static PCMM cmmImpl;

    public static synchronized PCMM getModule() {
        if (cmmImpl != null) {
            return cmmImpl;
        }
        CMMServiceProvider spi = AccessController.doPrivileged(new PrivilegedAction<CMMServiceProvider>(){

            @Override
            public CMMServiceProvider run() {
                String cmmClass = System.getProperty("sun.java2d.cmm", "sun.java2d.cmm.lcms.LcmsServiceProvider");
                ServiceLoader<CMMServiceProvider> cmmLoader = ServiceLoader.loadInstalled(CMMServiceProvider.class);
                CMMServiceProvider spi = null;
                Iterator<CMMServiceProvider> iterator = cmmLoader.iterator();
                while (iterator.hasNext()) {
                    CMMServiceProvider cmm;
                    spi = cmm = iterator.next();
                    if (!cmm.getClass().getName().equals(cmmClass)) continue;
                    break;
                }
                return spi;
            }
        });
        cmmImpl = spi.getColorManagementModule();
        if (cmmImpl == null) {
            throw new CMMException("Cannot initialize Color Management System.No CM module found");
        }
        GetPropertyAction gpa = new GetPropertyAction("sun.java2d.cmm.trace");
        String cmmTrace = AccessController.doPrivileged(gpa);
        if (cmmTrace != null) {
            cmmImpl = new CMMTracer(cmmImpl);
        }
        return cmmImpl;
    }

    static synchronized boolean canCreateModule() {
        return cmmImpl == null;
    }

    static {
        cmmImpl = null;
    }

    public static class CMMTracer
    implements PCMM {
        PCMM tcmm;
        String cName;

        public CMMTracer(PCMM tcmm) {
            this.tcmm = tcmm;
            this.cName = tcmm.getClass().getName();
        }

        @Override
        public Profile loadProfile(byte[] data) {
            System.err.print(this.cName + ".loadProfile");
            Profile p = this.tcmm.loadProfile(data);
            System.err.printf("(ID=%s)\n", p.toString());
            return p;
        }

        @Override
        public void freeProfile(Profile p) {
            System.err.printf(this.cName + ".freeProfile(ID=%s)\n", p.toString());
            this.tcmm.freeProfile(p);
        }

        @Override
        public int getProfileSize(Profile p) {
            System.err.print(this.cName + ".getProfileSize(ID=" + p + ")");
            int size = this.tcmm.getProfileSize(p);
            System.err.println("=" + size);
            return size;
        }

        @Override
        public void getProfileData(Profile p, byte[] data) {
            System.err.print(this.cName + ".getProfileData(ID=" + p + ") ");
            System.err.println("requested " + data.length + " byte(s)");
            this.tcmm.getProfileData(p, data);
        }

        @Override
        public int getTagSize(Profile p, int tagSignature) {
            System.err.printf(this.cName + ".getTagSize(ID=%x, TagSig=%s)", p, CMMTracer.signatureToString(tagSignature));
            int size = this.tcmm.getTagSize(p, tagSignature);
            System.err.println("=" + size);
            return size;
        }

        @Override
        public void getTagData(Profile p, int tagSignature, byte[] data) {
            System.err.printf(this.cName + ".getTagData(ID=%x, TagSig=%s)", p, CMMTracer.signatureToString(tagSignature));
            System.err.println(" requested " + data.length + " byte(s)");
            this.tcmm.getTagData(p, tagSignature, data);
        }

        @Override
        public void setTagData(Profile p, int tagSignature, byte[] data) {
            System.err.print(this.cName + ".setTagData(ID=" + p + ", TagSig=" + tagSignature + ")");
            System.err.println(" sending " + data.length + " byte(s)");
            this.tcmm.setTagData(p, tagSignature, data);
        }

        @Override
        public ColorTransform createTransform(ICC_Profile profile, int renderType, int transformType) {
            System.err.println(this.cName + ".createTransform(ICC_Profile,int,int)");
            return this.tcmm.createTransform(profile, renderType, transformType);
        }

        @Override
        public ColorTransform createTransform(ColorTransform[] transforms) {
            System.err.println(this.cName + ".createTransform(ColorTransform[])");
            return this.tcmm.createTransform(transforms);
        }

        private static String signatureToString(int sig) {
            return String.format("%c%c%c%c", Character.valueOf((char)(0xFF & sig >> 24)), Character.valueOf((char)(0xFF & sig >> 16)), Character.valueOf((char)(0xFF & sig >> 8)), Character.valueOf((char)(0xFF & sig)));
        }
    }
}

