/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Dimension;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.peer.ScrollbarPeer;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WToolkit;

final class WScrollbarPeer
extends WComponentPeer
implements ScrollbarPeer {
    private boolean dragInProgress = false;

    static native int getScrollbarSize(int var0);

    @Override
    public Dimension getMinimumSize() {
        if (((Scrollbar)this.target).getOrientation() == 1) {
            return new Dimension(WScrollbarPeer.getScrollbarSize(1), 50);
        }
        return new Dimension(50, WScrollbarPeer.getScrollbarSize(0));
    }

    @Override
    public native void setValues(int var1, int var2, int var3, int var4);

    @Override
    public native void setLineIncrement(int var1);

    @Override
    public native void setPageIncrement(int var1);

    WScrollbarPeer(Scrollbar target) {
        super(target);
    }

    @Override
    native void create(WComponentPeer var1);

    @Override
    void initialize() {
        Scrollbar sb = (Scrollbar)this.target;
        this.setValues(sb.getValue(), sb.getVisibleAmount(), sb.getMinimum(), sb.getMaximum());
        super.initialize();
    }

    private void postAdjustmentEvent(final int type, final int value, final boolean isAdjusting) {
        final Scrollbar sb = (Scrollbar)this.target;
        WToolkit.executeOnEventHandlerThread(sb, new Runnable(){

            @Override
            public void run() {
                sb.setValueIsAdjusting(isAdjusting);
                sb.setValue(value);
                WScrollbarPeer.this.postEvent(new AdjustmentEvent(sb, 601, type, value, isAdjusting));
            }
        });
    }

    void lineUp(int value) {
        this.postAdjustmentEvent(2, value, false);
    }

    void lineDown(int value) {
        this.postAdjustmentEvent(1, value, false);
    }

    void pageUp(int value) {
        this.postAdjustmentEvent(3, value, false);
    }

    void pageDown(int value) {
        this.postAdjustmentEvent(4, value, false);
    }

    void warp(int value) {
        this.postAdjustmentEvent(5, value, false);
    }

    void drag(int value) {
        if (!this.dragInProgress) {
            this.dragInProgress = true;
        }
        this.postAdjustmentEvent(5, value, true);
    }

    void dragEnd(final int value) {
        final Scrollbar sb = (Scrollbar)this.target;
        if (!this.dragInProgress) {
            return;
        }
        this.dragInProgress = false;
        WToolkit.executeOnEventHandlerThread(sb, new Runnable(){

            @Override
            public void run() {
                sb.setValueIsAdjusting(false);
                WScrollbarPeer.this.postEvent(new AdjustmentEvent(sb, 601, 5, value, false));
            }
        });
    }

    @Override
    public boolean shouldClearRectBeforePaint() {
        return false;
    }
}

