/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.InputEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Map;
import sun.awt.dnd.SunDragSourceContextPeer;
import sun.awt.windows.WDropTargetContextPeer;
import sun.awt.windows.WToolkit;

final class WDragSourceContextPeer
extends SunDragSourceContextPeer {
    private static final WDragSourceContextPeer theInstance = new WDragSourceContextPeer(null);

    @Override
    public void startSecondaryEventLoop() {
        WToolkit.startSecondaryEventLoop();
    }

    @Override
    public void quitSecondaryEventLoop() {
        WToolkit.quitSecondaryEventLoop();
    }

    private WDragSourceContextPeer(DragGestureEvent dge) {
        super(dge);
    }

    static WDragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dge) throws InvalidDnDOperationException {
        theInstance.setTrigger(dge);
        return theInstance;
    }

    @Override
    protected void startDrag(Transferable trans, long[] formats, Map formatMap) {
        long nativeCtxtLocal = 0L;
        nativeCtxtLocal = this.createDragSource(this.getTrigger().getComponent(), trans, this.getTrigger().getTriggerEvent(), this.getTrigger().getSourceAsDragGestureRecognizer().getSourceActions(), formats, formatMap);
        if (nativeCtxtLocal == 0L) {
            throw new InvalidDnDOperationException("failed to create native peer");
        }
        int[] imageData = null;
        Point op = null;
        Image im = this.getDragImage();
        int imageWidth = -1;
        int imageHeight = -1;
        if (im != null) {
            try {
                imageWidth = im.getWidth(null);
                imageHeight = im.getHeight(null);
                if (imageWidth < 0 || imageHeight < 0) {
                    throw new InvalidDnDOperationException("drag image is not ready");
                }
                op = this.getDragImageOffset();
                BufferedImage bi = new BufferedImage(imageWidth, imageHeight, 2);
                bi.getGraphics().drawImage(im, 0, 0, null);
                imageData = ((DataBufferInt)bi.getData().getDataBuffer()).getData();
            }
            catch (Throwable ex) {
                throw new InvalidDnDOperationException("drag image creation problem: " + ex.getMessage());
            }
        }
        this.setNativeContext(nativeCtxtLocal);
        WDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(trans);
        if (imageData != null) {
            this.doDragDrop(this.getNativeContext(), this.getCursor(), imageData, imageWidth, imageHeight, op.x, op.y);
        } else {
            this.doDragDrop(this.getNativeContext(), this.getCursor(), null, -1, -1, 0, 0);
        }
    }

    native long createDragSource(Component var1, Transferable var2, InputEvent var3, int var4, long[] var5, Map var6);

    native void doDragDrop(long var1, Cursor var3, int[] var4, int var5, int var6, int var7, int var8);

    @Override
    protected native void setNativeCursor(long var1, Cursor var3, int var4);
}

