/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import sun.awt.AppContext;
import sun.swing.AccumulativeRunnable;

public abstract class SwingWorker<T, V>
implements RunnableFuture<T> {
    private static final int MAX_WORKER_THREADS = 10;
    private volatile int progress;
    private volatile StateValue state;
    private final FutureTask<T> future;
    private final PropertyChangeSupport propertyChangeSupport;
    private AccumulativeRunnable<V> doProcess;
    private AccumulativeRunnable<Integer> doNotifyProgressChange;
    private final AccumulativeRunnable<Runnable> doSubmit = SwingWorker.getDoSubmit();
    private static final Object DO_SUBMIT_KEY = new StringBuilder("doSubmit");

    public SwingWorker() {
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                SwingWorker.this.setState(StateValue.STARTED);
                return SwingWorker.this.doInBackground();
            }
        };
        this.future = new FutureTask<T>(callable){

            @Override
            protected void done() {
                SwingWorker.this.doneEDT();
                SwingWorker.this.setState(StateValue.DONE);
            }
        };
        this.state = StateValue.PENDING;
        this.propertyChangeSupport = new SwingWorkerPropertyChangeSupport(this);
        this.doProcess = null;
        this.doNotifyProgressChange = null;
    }

    protected abstract T doInBackground() throws Exception;

    @Override
    public final void run() {
        this.future.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    protected final void publish(V ... chunks) {
        SwingWorker swingWorker = this;
        synchronized (swingWorker) {
            if (this.doProcess == null) {
                this.doProcess = new AccumulativeRunnable<V>(){

                    @Override
                    public void run(List<V> args) {
                        SwingWorker.this.process(args);
                    }

                    @Override
                    protected void submit() {
                        SwingWorker.this.doSubmit.add(this);
                    }
                };
            }
        }
        this.doProcess.add(chunks);
    }

    protected void process(List<V> chunks) {
    }

    protected void done() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setProgress(int progress) {
        if (progress < 0 || progress > 100) {
            throw new IllegalArgumentException("the value should be from 0 to 100");
        }
        if (this.progress == progress) {
            return;
        }
        int oldProgress = this.progress;
        this.progress = progress;
        if (!this.getPropertyChangeSupport().hasListeners("progress")) {
            return;
        }
        SwingWorker swingWorker = this;
        synchronized (swingWorker) {
            if (this.doNotifyProgressChange == null) {
                this.doNotifyProgressChange = new AccumulativeRunnable<Integer>(){

                    @Override
                    public void run(List<Integer> args) {
                        SwingWorker.this.firePropertyChange("progress", args.get(0), args.get(args.size() - 1));
                    }

                    @Override
                    protected void submit() {
                        SwingWorker.this.doSubmit.add(this);
                    }
                };
            }
        }
        this.doNotifyProgressChange.add((Integer[])new Integer[]{oldProgress, progress});
    }

    public final int getProgress() {
        return this.progress;
    }

    public final void execute() {
        SwingWorker.getWorkersExecutorService().execute(this);
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public final boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public final boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public final T get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public final T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(timeout, unit);
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(listener);
    }

    public final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.getPropertyChangeSupport().firePropertyChange(propertyName, oldValue, newValue);
    }

    public final PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public final StateValue getState() {
        if (this.isDone()) {
            return StateValue.DONE;
        }
        return this.state;
    }

    private void setState(StateValue state) {
        StateValue old = this.state;
        this.state = state;
        this.firePropertyChange("state", (Object)old, (Object)state);
    }

    private void doneEDT() {
        Runnable doDone = new Runnable(){

            @Override
            public void run() {
                SwingWorker.this.done();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            doDone.run();
        } else {
            this.doSubmit.add((Runnable[])new Runnable[]{doDone});
        }
    }

    private static synchronized ExecutorService getWorkersExecutorService() {
        AppContext appContext = AppContext.getAppContext();
        ExecutorService executorService = (ExecutorService)appContext.get(SwingWorker.class);
        if (executorService == null) {
            ThreadFactory threadFactory = new ThreadFactory(){
                final ThreadFactory defaultFactory = Executors.defaultThreadFactory();

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = this.defaultFactory.newThread(r);
                    thread.setName("SwingWorker-" + thread.getName());
                    thread.setDaemon(true);
                    return thread;
                }
            };
            executorService = new ThreadPoolExecutor(10, 10, 10L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), threadFactory);
            appContext.put(SwingWorker.class, executorService);
            final ExecutorService es = executorService;
            appContext.addPropertyChangeListener("disposed", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent pce) {
                    WeakReference<ExecutorService> executorServiceRef;
                    ExecutorService executorService;
                    boolean disposed = (Boolean)pce.getNewValue();
                    if (disposed && (executorService = (ExecutorService)(executorServiceRef = new WeakReference<ExecutorService>(es)).get()) != null) {
                        AccessController.doPrivileged(new PrivilegedAction<Void>(){

                            @Override
                            public Void run() {
                                executorService.shutdown();
                                return null;
                            }
                        });
                    }
                }
            });
        }
        return executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AccumulativeRunnable<Runnable> getDoSubmit() {
        Object object = DO_SUBMIT_KEY;
        synchronized (object) {
            AppContext appContext = AppContext.getAppContext();
            Object doSubmit = appContext.get(DO_SUBMIT_KEY);
            if (doSubmit == null) {
                doSubmit = new DoSubmitAccumulativeRunnable();
                appContext.put(DO_SUBMIT_KEY, doSubmit);
            }
            return (AccumulativeRunnable)doSubmit;
        }
    }

    private class SwingWorkerPropertyChangeSupport
    extends PropertyChangeSupport {
        SwingWorkerPropertyChangeSupport(Object source) {
            super(source);
        }

        @Override
        public void firePropertyChange(final PropertyChangeEvent evt) {
            if (SwingUtilities.isEventDispatchThread()) {
                super.firePropertyChange(evt);
            } else {
                SwingWorker.this.doSubmit.add(new Runnable(){

                    @Override
                    public void run() {
                        SwingWorkerPropertyChangeSupport.this.firePropertyChange(evt);
                    }
                });
            }
        }
    }

    private static class DoSubmitAccumulativeRunnable
    extends AccumulativeRunnable<Runnable>
    implements ActionListener {
        private static final int DELAY = 33;

        private DoSubmitAccumulativeRunnable() {
        }

        @Override
        protected void run(List<Runnable> args) {
            for (Runnable runnable : args) {
                runnable.run();
            }
        }

        @Override
        protected void submit() {
            Timer timer = new Timer(33, this);
            timer.setRepeats(false);
            timer.start();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.run();
        }
    }

    public static enum StateValue {
        PENDING,
        STARTED,
        DONE;

    }
}

