/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import java.util.stream.BaseStream;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.StreamSpliterators;
import java.util.stream.StreamSupport;
import java.util.stream.Streams;

public interface Stream<T>
extends BaseStream<T, Stream<T>> {
    public Stream<T> filter(Predicate<? super T> var1);

    public <R> Stream<R> map(Function<? super T, ? extends R> var1);

    public IntStream mapToInt(ToIntFunction<? super T> var1);

    public LongStream mapToLong(ToLongFunction<? super T> var1);

    public DoubleStream mapToDouble(ToDoubleFunction<? super T> var1);

    public <R> Stream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> var1);

    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> var1);

    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> var1);

    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> var1);

    public Stream<T> distinct();

    public Stream<T> sorted();

    public Stream<T> sorted(Comparator<? super T> var1);

    public Stream<T> peek(Consumer<? super T> var1);

    public Stream<T> limit(long var1);

    public Stream<T> skip(long var1);

    public void forEach(Consumer<? super T> var1);

    public void forEachOrdered(Consumer<? super T> var1);

    public Object[] toArray();

    public <A> A[] toArray(IntFunction<A[]> var1);

    public T reduce(T var1, BinaryOperator<T> var2);

    public Optional<T> reduce(BinaryOperator<T> var1);

    public <U> U reduce(U var1, BiFunction<U, ? super T, U> var2, BinaryOperator<U> var3);

    public <R> R collect(Supplier<R> var1, BiConsumer<R, ? super T> var2, BiConsumer<R, R> var3);

    public <R, A> R collect(Collector<? super T, A, R> var1);

    public Optional<T> min(Comparator<? super T> var1);

    public Optional<T> max(Comparator<? super T> var1);

    public long count();

    public boolean anyMatch(Predicate<? super T> var1);

    public boolean allMatch(Predicate<? super T> var1);

    public boolean noneMatch(Predicate<? super T> var1);

    public Optional<T> findFirst();

    public Optional<T> findAny();

    public static <T> Builder<T> builder() {
        return new Streams.StreamBuilderImpl();
    }

    public static <T> Stream<T> empty() {
        return StreamSupport.stream(Spliterators.emptySpliterator(), false);
    }

    public static <T> Stream<T> of(T t) {
        return StreamSupport.stream(new Streams.StreamBuilderImpl<T>(t), false);
    }

    @SafeVarargs
    public static <T> Stream<T> of(T ... values) {
        return Arrays.stream(values);
    }

    public static <T> Stream<T> iterate(final T seed, final UnaryOperator<T> f) {
        Objects.requireNonNull(f);
        Iterator iterator = new Iterator<T>(){
            T t = Streams.NONE;

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T next() {
                this.t = this.t == Streams.NONE ? seed : f.apply(this.t);
                return this.t;
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1040), false);
    }

    public static <T> Stream<T> generate(Supplier<T> s) {
        Objects.requireNonNull(s);
        return StreamSupport.stream(new StreamSpliterators.InfiniteSupplyingSpliterator.OfRef<T>(Long.MAX_VALUE, s), false);
    }

    public static <T> Stream<T> concat(Stream<? extends T> a, Stream<? extends T> b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        Streams.ConcatSpliterator.OfRef split = new Streams.ConcatSpliterator.OfRef(a.spliterator(), b.spliterator());
        Stream stream = StreamSupport.stream(split, a.isParallel() || b.isParallel());
        return (Stream)stream.onClose(Streams.composedClose(a, b));
    }

    public static interface Builder<T>
    extends Consumer<T> {
        @Override
        public void accept(T var1);

        default public Builder<T> add(T t) {
            this.accept(t);
            return this;
        }

        public Stream<T> build();
    }
}

