/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.FinalReference;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;
import sun.misc.VM;

final class Finalizer
extends FinalReference<Object> {
    private static ReferenceQueue<Object> queue;
    private static Finalizer unfinalized;
    private static final Object lock;
    private Finalizer next = null;
    private Finalizer prev = null;

    private boolean hasBeenFinalized() {
        return this.next == this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add() {
        Object object = lock;
        synchronized (object) {
            if (unfinalized != null) {
                this.next = unfinalized;
                Finalizer.unfinalized.prev = this;
            }
            unfinalized = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove() {
        Object object = lock;
        synchronized (object) {
            if (unfinalized == this) {
                unfinalized = this.next != null ? this.next : this.prev;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            this.next = this;
            this.prev = this;
        }
    }

    private Finalizer(Object finalizee) {
        super(finalizee, queue);
        this.add();
    }

    static ReferenceQueue<Object> getQueue() {
        return queue;
    }

    static void register(Object finalizee) {
        new Finalizer(finalizee);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFinalizer(JavaLangAccess jla) {
        Finalizer finalizer = this;
        synchronized (finalizer) {
            if (this.hasBeenFinalized()) {
                return;
            }
            this.remove();
        }
        try {
            Object finalizee = this.get();
            if (finalizee != null && !(finalizee instanceof Enum)) {
                jla.invokeFinalize(finalizee);
                finalizer = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.clear();
    }

    private static void forkSecondaryFinalizer(final Runnable proc) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ThreadGroup tg;
                ThreadGroup tgn = tg = Thread.currentThread().getThreadGroup();
                while (tgn != null) {
                    tg = tgn;
                    tgn = tg.getParent();
                }
                Thread sft = new Thread(tg, proc, "Secondary finalizer");
                sft.start();
                try {
                    sft.join();
                }
                catch (InterruptedException x) {
                    Thread.currentThread().interrupt();
                }
                return null;
            }
        });
    }

    static void runFinalization() {
        if (!VM.isBooted()) {
            return;
        }
        Finalizer.forkSecondaryFinalizer(new Runnable(){
            private volatile boolean running;

            @Override
            public void run() {
                Finalizer f;
                if (this.running) {
                    return;
                }
                JavaLangAccess jla = SharedSecrets.getJavaLangAccess();
                this.running = true;
                while ((f = (Finalizer)queue.poll()) != null) {
                    f.runFinalizer(jla);
                }
            }
        });
    }

    static void runAllFinalizers() {
        if (!VM.isBooted()) {
            return;
        }
        Finalizer.forkSecondaryFinalizer(new Runnable(){
            private volatile boolean running;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (this.running) {
                    return;
                }
                JavaLangAccess jla = SharedSecrets.getJavaLangAccess();
                this.running = true;
                while (true) {
                    Finalizer f;
                    Object object = lock;
                    synchronized (object) {
                        f = unfinalized;
                        if (f == null) {
                            break;
                        }
                        unfinalized = f.next;
                    }
                    f.runFinalizer(jla);
                }
            }
        });
    }

    static {
        ThreadGroup tg;
        queue = new ReferenceQueue();
        unfinalized = null;
        lock = new Object();
        ThreadGroup tgn = tg = Thread.currentThread().getThreadGroup();
        while (tgn != null) {
            tg = tgn;
            tgn = tg.getParent();
        }
        FinalizerThread finalizer = new FinalizerThread(tg);
        finalizer.setPriority(8);
        finalizer.setDaemon(true);
        finalizer.start();
    }

    private static class FinalizerThread
    extends Thread {
        private volatile boolean running;

        FinalizerThread(ThreadGroup g) {
            super(g, "Finalizer");
        }

        @Override
        public void run() {
            if (this.running) {
                return;
            }
            while (!VM.isBooted()) {
                try {
                    VM.awaitBooted();
                }
                catch (InterruptedException interruptedException) {}
            }
            JavaLangAccess jla = SharedSecrets.getJavaLangAccess();
            this.running = true;
            while (true) {
                try {
                    while (true) {
                        Finalizer f = (Finalizer)queue.remove();
                        f.runFinalizer(jla);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

