/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.init;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.auth.service.AuthAreaService;
import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthAreaItem;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.base.utils.VersionUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.psg.constants.PsgConstants;
import com.zkteco.zkbiosecurity.psg.service.PsgDSTimeService;
import com.zkteco.zkbiosecurity.psg.service.PsgGatePassRuleService;
import com.zkteco.zkbiosecurity.psg.service.PsgLevelService;
import com.zkteco.zkbiosecurity.psg.vo.PsgDSTimeItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgGatePassRuleItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgLevelItem;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=120)
public class PsgInit
implements CommandLineRunner {
    @Autowired
    private AuthPermissionService authPermissionService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private AuthAreaService authAreaService;
    @Autowired
    private PsgLevelService psgLevelService;
    @Autowired
    private PsgGatePassRuleService psgGatePassRuleService;
    @Autowired
    private PsgDSTimeService psgDSTimeService;
    @Value(value="${system.language}")
    private String language;

    public void run(String ... arg0) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("PsgInit");
        if (!alreadyInit) {
            this.initAuthPermission();
            this.initPsgParams();
            this.initPsgDSTime();
            this.initPsgLevel();
            this.initPsgGatePassRule();
            this.initUpgradeVersion();
            this.baseSysParamService.setAlreadyInitModule("PsgInit");
        }
    }

    private void initAuthPermission() {
        AuthPermissionItem systemItem = new AuthPermissionItem("Psg", "psg_module", "psg", "system", "true", Integer.valueOf(12));
        systemItem = this.authPermissionService.saveItem(systemItem);
        AuthPermissionItem subMenuItem1 = new AuthPermissionItem("PsgDeviceManage", "psg_leftMenu_DeviceManage", "psg:device:manage", "menu", "true", Integer.valueOf(1));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("psgDevice.do");
        subMenuItem1.setImg("psg_device.png");
        subMenuItem1.setImgHover("psg_device_over.png");
        subMenuItem1 = this.authPermissionService.saveItem(subMenuItem1);
        AuthPermissionItem subMenuItem = new AuthPermissionItem("PassageChannel", "psg_passage", "psg:passage", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("psgPassage.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        AuthPermissionItem subButtonItem = new AuthPermissionItem("PsgPassageRefresh", "common_op_refresh", "psg:passage:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgPassageAdd", "common_op_new", "psg:passage:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgPassageDel", "common_op_del", "psg:passage:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgPassageEdit", "common_op_edit", "psg:passage:edit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PassageDevice", "psg_device", "psg:device", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("psgDevice.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceRefresh", "common_op_refresh", "psg:device:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceAdd", "common_op_new", "psg:device:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceEdit", "common_op_edit", "psg:device:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceDel", "common_op_del", "psg:device:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceExport", "common_op_export", "psg:device:export", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceSearch", "common_dev_searchDev", "psg:device:searchDev", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceEnable", "common_enable", "psg:device:enable", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceDisable", "common_disable", "psg:device:disable", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceSyncAllData", "common_dev_syncAllDataToDev", "psg:device:syncAllData", "button", "true", Integer.valueOf(9));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceUpgradeFirmware", "common_dev_upgradeFirmware", "psg:device:upgradeFirmware", "button", "true", Integer.valueOf(10));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceUpgradeLCDFirmware", "common_dev_upgradeFirmware", "psg:device:upgradeFirmware", "button", "true", Integer.valueOf(11));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceRebootDevice", "common_dev_reboot", "psg:device:rebootDevice", "button", "true", Integer.valueOf(12));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceGetOptFromDev", "common_dev_getDevOpt", "psg:device:getOptFromDev", "button", "true", Integer.valueOf(13));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceUploadPersonInfo", "common_dev_getPersonInfo", "psg:device:uploadPersonInfo", "button", "true", Integer.valueOf(14));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceUploadTransaction", "common_dev_getTrans", "psg:device:uploadTransaction", "button", "true", Integer.valueOf(15));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceSyncTime", "common_dev_syncTime", "psg:device:syncTime", "button", "true", Integer.valueOf(16));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceSetRegistrationDevice", "psg_dev_setRegistrationDevice", "psg:device:setRegistrationDevice", "button", "true", Integer.valueOf(17));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceUpdateIpAddr", "common_dev_modifyIPAddress", "psg:device:updateIpAddr", "button", "true", Integer.valueOf(18));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceUpdateCommPwd", "common_dev_modifyCommPwd", "psg:device:updateCommPwd", "button", "true", Integer.valueOf(19));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceUpdateMThreshold", "common_dev_modifyFPThreshold", "psg:device:updateMThreshold", "button", "true", Integer.valueOf(20));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceQueryDevUsage", "psg_dev_queryDevVolume", "psg:device:queryDevUsage", "button", "true", Integer.valueOf(21));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        if (!"zh_CN".equals(this.language)) {
            subButtonItem = new AuthPermissionItem("PsgDeviceSetTimeZone", "psg_dev_setTimeZone", "psg:device:setTimeZone", "button", "true", Integer.valueOf(22));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("PsgDeviceSetDSTime", "psg_dev_setDstime", "psg:device:setDSTime", "button", "true", Integer.valueOf(23));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authPermissionService.initData(subButtonItem);
        }
        subButtonItem = new AuthPermissionItem("PsgDeviceSetLcdDisplay", "psg_dev_setLcdDisplayIn", "psg:device:setLcdDisplayIn", "button", "true", Integer.valueOf(24));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceSetLcdDisplay", "psg_dev_setLcdDisplayOut", "psg:device:setLcdDisplayOut", "button", "true", Integer.valueOf(25));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceClearLCDCountArea", "psg_dev_clearLCDCountArea", "psg:device:clearLCDCountArea", "button", "true", Integer.valueOf(26));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PassageGate", "psg_leftMenu_gate", "psg:gate", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("psgGate.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PsgGaterRefresh", "common_op_refresh", "psg:gate:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgGaterEdit", "common_op_edit", "psg:gate:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgGateOpenInGate", "psg_gate_remoteOpenIn", "psg:gate:openInGate", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgGateOpenOutGate", "psg_gate_remoteOpenOut", "psg:gate:openOutGate", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgGateCancelAlarm", "psg_eventNo_7", "psg:gate:cancelAlarm", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        if (!"zh_CN".equals(this.language)) {
            subButtonItem = new AuthPermissionItem("PsgGateLockGate", "psg_newEventNo_233", "psg:gate:lockGate", "button", "true", Integer.valueOf(9));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("PsgGateUnlockGate", "psg_newEventNo_234", "psg:gate:unLockGate", "button", "true", Integer.valueOf(10));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authPermissionService.initData(subButtonItem);
        }
        subButtonItem = new AuthPermissionItem("PsgGateNormalOpenGate", "psg_rtMonitor_remoteNormalOpen", "psg:gate:normalOpenGate", "button", "true", Integer.valueOf(11));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgGateEnableNormalOpenGate", "common_rtMonitor_enableIntradayTZ", "psg:gate:enableNormalOpenGate", "button", "true", Integer.valueOf(12));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgGateDisableNormalOpenGate", "common_rtMonitor_disableIntradayTZ", "psg:gate:disableNormalOpenGate", "button", "true", Integer.valueOf(13));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PsgReader", "common_leftMenu_reader", "psg:reader", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("psgReader.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PsgReaderRefresh", "common_op_refresh", "psg:reader:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgReaderEdit", "common_op_edit", "psg:reader:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgReaderBindChannel", "psg_common_bindOrUnbindChannel", "psg:reader:bindChannel", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PsgAuxIn", "common_leftMenu_auxIn", "psg:auxIn", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("psgAuxIn.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PsgAuxInRefresh", "common_op_refresh", "psg:auxIn:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgAuxInEdit", "common_op_edit", "psg:auxIn:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgAuxInBindChannel", "psg_common_bindOrUnbindChannel", "psg:auxIn:bindChannel", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PsgDeviceEvent", "common_leftMenu_event", "psg:deviceEvent", "menu", "true", Integer.valueOf(6));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("psgDeviceEvent.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceEventRefresh", "common_op_refresh", "psg:deviceEvent:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceEventEdit", "common_op_edit", "psg:deviceEvent:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceEventSetSound", "psg_deviceEvent_batchSet", "psg:deviceEvent:setSound", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        if (!"zh_CN".equals(this.language)) {
            subMenuItem = new AuthPermissionItem("PsgDSTime", "psg_leftMenu_dSTime", "psg:dSTime", "menu", "true", Integer.valueOf(7));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("psgDSTime.do");
            subMenuItem = this.authPermissionService.initData(subMenuItem);
            subButtonItem = new AuthPermissionItem("PsgDSTimeRefresh", "common_op_refresh", "psg:dSTime:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("PsgDSTimeAdd", "common_op_new", "psg:dSTime:add", "button", "true", Integer.valueOf(2));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("PsgDSTimeEdit", "common_op_edit", "psg:dSTime:edit", "button", "true", Integer.valueOf(3));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("PsgDSTimeDel", "common_op_del", "psg:dSTime:del", "button", "true", Integer.valueOf(4));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("PsgDSTimeSetDSTime", "common_dsTime_setting", "psg:dSTime:setDSTime", "button", "true", Integer.valueOf(5));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authPermissionService.initData(subButtonItem);
        }
        subMenuItem = new AuthPermissionItem("PsgDeviceMonitor", "common_leftMenu_devMonitioring", "psg:deviceMonitor", "menu", "true", Integer.valueOf(8));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("psgDeviceMonitor.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceMonitorBrowse", "common_op_browse", "psg:deviceMonitor:browse", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceMonitorExport", "common_op_export", "psg:deviceMonitor:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgDeviceMonitorClearCmd", "common_devMonitor_clearCmdCache", "psg:deviceMonitor:clearCmdCache", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PsgRTMonitor", "common_leftMenu_rtMonitor", "psg:rtMonitor", "menu", "true", Integer.valueOf(9));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("psgRTMonitor.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PsgRTMonitorOpenInGate", "psg_gate_remoteOpenIn", "psg:rtMonitor:openInGate", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgRTMonitorOpenOutGate", "psg_gate_remoteOpenOut", "psg:rtMonitor:openOutGate", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgRTMonitorCancelAlarm", "psg_eventNo_7", "psg:rtMonitor:cancelAlarm", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgRTMonitorTransactionTodayHappen", "psg_gateEventLatestHappen", "psg:rtMonitor:transactionTodayHappen", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        this.authPermissionService.initData(subButtonItem);
        if (!"zh_CN".equals(this.language)) {
            subButtonItem = new AuthPermissionItem("PsgRTMonitorLockGate", "psg_newEventNo_233", "psg:rtMonitor:lockGate", "button", "true", Integer.valueOf(8));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("PsgRTMonitorUnlockGate", "psg_newEventNo_234", "psg:rtMonitor:unLockGate", "button", "true", Integer.valueOf(9));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authPermissionService.initData(subButtonItem);
        }
        subButtonItem = new AuthPermissionItem("PsgRTMonitorNormalOpenGate", "psg_rtMonitor_remoteNormalOpen", "psg:rtMonitor:normalOpenGate", "button", "true", Integer.valueOf(10));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgRTMonitorEnableNormalOpenGate", "common_rtMonitor_enableIntradayTZ", "psg:rtMonitor:enableNormalOpenGate", "button", "true", Integer.valueOf(11));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgRTMonitorDisableNormalOpenGate", "common_rtMonitor_disableIntradayTZ", "psg:rtMonitor:disableNormalOpenGate", "button", "true", Integer.valueOf(12));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem1 = new AuthPermissionItem("PsgPassageAccess", "psg_leftMenu_PassageAccess", "psg:access", "menu", "true", Integer.valueOf(2));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setImg("psg_control.png");
        subMenuItem1.setImgHover("psg_control_over.png");
        subMenuItem1 = this.authPermissionService.saveItem(subMenuItem1);
        subMenuItem = new AuthPermissionItem("PsgLevel", "psg_leftMenu_level", "psg:level", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("psgLevel.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PsgLevelRefresh", "common_op_refresh", "psg:level:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgLevelAdd", "common_op_new", "psg:level:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgLevelEdit", "common_op_edit", "psg:level:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgLevelDel", "common_op_del", "psg:level:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgLevelAddGate", "psg_level_addGate", "psg:level:addGate", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgLevelDelGate", "psg_level_gateDelete", "psg:level:delGate", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgLevelExportGate", "common_op_export", "psg:level:export", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgLevelPersPsgSet", "psg_level_persPsgSet", "psg:level:persPsgSet", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PsgPersonLevelByLevel", "common_leftMenu_levelSetByLevel", "psg:personLevelByLevel", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("psgPersonLevelByLevel.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PsgPersonLevelByLevelRefresh", "common_op_refresh", "psg:personLevelByLevel:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgPersonLevelByLevelAddPerson", "pers_common_addPerson", "psg:personLevelByLevel:addPerson", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgPersonLevelByLevelDelPerson", "pers_common_delPerson", "psg:personLevelByLevel:delPerson", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgPersonLevelByLevelExport", "common_op_export", "psg:personLevelByLevel:export", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PsgAntiPassback", "psg_leftMenu_antiPassback", "psg:antiPassback", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("psgAntiPassback.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PsgAntiPassbackRefresh", "common_op_refresh", "psg:antiPassback:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgAntiPassbackAdd", "common_op_new", "psg:antiPassback:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgAntiPassbackEdit", "common_op_edit", "psg:antiPassback:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgAntiPassbackDel", "common_op_del", "psg:antiPassback:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PsgLinkage", "common_leftMenu_linkage", "psg:linkage", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("psgLinkage.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PsgLinkageRefresh", "common_op_refresh", "psg:linkage:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgLinkageAdd", "common_op_new", "psg:linkage:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgLinkageEdit", "common_op_edit", "psg:linkage:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgLinkageDel", "common_op_del", "psg:linkage:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PsgParam", "common_leftMenu_paramSet", "psg:param", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("psgParam.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PsgParamRefresh", "common_op_refresh", "psg:param:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgParamEdit", "common_op_edit", "psg:param:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem1 = new AuthPermissionItem("PsgSetting", "psg_leftMenu_PassageSet", "psg:setting", "menu", "true", Integer.valueOf(3));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("");
        subMenuItem1.setImg("psg_setting.png");
        subMenuItem1.setImgHover("psg_setting_over.png");
        subMenuItem1 = this.authPermissionService.saveItem(subMenuItem1);
        subMenuItem = new AuthPermissionItem("PsgGatePassRule", "psg_leftMenu_gatePassRules", "psg:gatePassRule", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("psgGatePassRule.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PsgGatePassRuleAdd", "common_op_new", "psg:gatePassRule:add", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgGatePassRuleEdit", "common_op_edit", "psg:gatePassRule:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgGatePassRuleRefresh", "common_op_refresh", "psg:gatePassRule:refresh", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgGatePassRuleDel", "common_op_del", "psg:gatePassRule:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PsgWingGate", "psg_device_wingGate", "psg:wingGate", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("psgWingGate.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PsgWingGateRefresh", "common_op_refresh", "psg:wingGate:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgWingGateEdit", "common_op_edit", "psg:wingGate:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PsgSwingGate", "psg_device_swingGate", "psg:swingGate", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("psgSwingGate.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PsgSwingGateRefresh", "common_op_refresh", "psg:swingGate:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgSwingGateEdit", "common_op_edit", "psg:swingGate:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem1 = new AuthPermissionItem("PsgTransaction", "common_leftMenu_reports", "psg:transaction", "menu", "true", Integer.valueOf(4));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setImg("psg_reports.png");
        subMenuItem1.setImgHover("psg_reports_over.png");
        subMenuItem1 = this.authPermissionService.saveItem(subMenuItem1);
        subMenuItem = new AuthPermissionItem("PsgTransactionAll", "common_leftMenu_transaction", "psg:transaction", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("psgTransaction.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PsgTransactionRefresh", "common_op_refresh", "psg:transaction:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgTransactionDel", "common_op_clearData", "psg:transaction:del", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgTransactionExport", "common_op_export", "psg:transaction:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PsgTransactionToday", "psg_transaction_today", "psg:transactionToday", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("psgTransactionToday.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PsgTransactionTodayRefresh", "common_op_refresh", "psg:transactionToday:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgTransactionTodayDel", "common_op_clearData", "psg:transactionToday:del", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgTransactionTodayExport", "common_op_export", "psg:transactionToday:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PsgPersonLastAddr", "psg_transaction_lastAddr", "psg:personLastAddr", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("psgPersonLastAddr.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PsgPersonLastAddrRefresh", "common_op_refresh", "psg:personLastAddr:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgPersonLastAddrDel", "common_op_del", "psg:personLastAddr:del", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgPersonLastAddrExport", "common_op_export", "psg:personLastAddr:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PsgAlarmTransaction", "common_leftMenu_exceptTransaction", "psg:alarmTransaction", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("psgAlarmTransaction.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PsgAlarmTransactionRefresh", "common_op_refresh", "psg:alarmTransaction:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgAlarmTransactionDel", "common_op_del", "psg:alarmTransaction:del", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PsgAlarmTransactionExport", "common_op_export", "psg:alarmTransaction:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = this.authPermissionService.getItemByCode("PersPerson");
        if (null != subMenuItem) {
            subButtonItem = new AuthPermissionItem("PersPersonPsgEdit", "pers_person_psgSet", "pers:person:psgEdit", "button", "true", Integer.valueOf(105));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
    }

    private void initPsgParams() {
        JSONObject values = new JSONObject();
        values.put("keptMonth", (Object)"15");
        values.put("runtime", (Object)"01:00:00");
        BaseSysParamItem item = new BaseSysParamItem("psgReportDataClean", values.toString(), "base_dataClean_psgTrans");
        this.baseSysParamService.initData(item);
        this.baseSysParamService.initData(new BaseSysParamItem("psg.downNewlog", "0", I18nUtil.i18nCode((String)"psg_params_downNewlog", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("psg.personPhotoMaxHeight", "140", I18nUtil.i18nCode((String)"common_param_rtMonitorPhotoSize", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("psg.downNewLogExpression", "0 10 0 * * ?", I18nUtil.i18nCode((String)"psg_params_downNewLogExpression", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("psg.receiver", "", I18nUtil.i18nCode((String)"common_param_receiveMail", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("psg.addDeviceOperKeyword", "xxx", I18nUtil.i18nCode((String)"psg_params_addDeviceOperKeyword", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("psg.queryDoorEventLastLimit", "5", I18nUtil.i18nCode((String)"psg_gateEventLatestHappen", (Object[])new Object[0])));
    }

    private void initPsgDSTime() {
        PsgDSTimeItem psgDSTimeItem = new PsgDSTimeItem(I18nUtil.i18nCode((String)"psg_dev_usadst", (Object[])new Object[0]), Short.valueOf((short)1), "03020002", "11010002", Boolean.valueOf(true));
        this.psgDSTimeService.initData(psgDSTimeItem);
    }

    private void initPsgLevel() {
        AuthAreaItem authAreaItem = this.authAreaService.getItemByCode("1");
        PsgLevelItem psgLevelItem = new PsgLevelItem(I18nUtil.i18nCode((String)"psg_level_master", (Object[])new Object[0]), Boolean.valueOf(true), authAreaItem.getId());
        this.psgLevelService.initData(psgLevelItem);
    }

    private void initPsgGatePassRule() {
        PsgGatePassRuleItem psgGatePassRuleItem = new PsgGatePassRuleItem(I18nUtil.i18nCode((String)"common_timeSeg_24HoursAccess", (Object[])new Object[0]), I18nUtil.i18nCode((String)"common_timeSeg_24HoursAccess", (Object[])new Object[0]), Boolean.valueOf(true), "00:00:00", "23:59:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "23:59:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "23:59:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "23:59:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "23:59:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "23:59:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "23:59:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT, "00:00:00", "00:00:00", PsgConstants.OPENGATE_MODE_INANDOUT);
        this.psgGatePassRuleService.initData(psgGatePassRuleItem);
    }

    private void initUpgradeVersion() {
        String curVersion = VersionUtil.getReleaseGitTags((String)"psg");
        if (StringUtils.isNotBlank((CharSequence)curVersion)) {
            BaseSysParamItem baseSysParamItem = this.baseSysParamService.findByParamName("PsgUpgradeVersion");
            if (StringUtils.isBlank((CharSequence)baseSysParamItem.getId())) {
                baseSysParamItem = new BaseSysParamItem("PsgUpgradeVersion", curVersion, "Psg Upgrade Version", Boolean.valueOf(true));
            }
            this.baseSysParamService.saveItem(baseSysParamItem);
        }
    }
}

