/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.redis.configuration;

import com.zkteco.zkbiosecurity.redis.configuration.KeyExpireMessageListener;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class RedisMessageListenerContainerConfig {
    @Autowired
    private RedisTemplate<Object, Object> redisTemplate;
    @Autowired
    private KeyExpireMessageListener messageListener;
    @Value(value="spring.redis.topic")
    private String topic;
    @Value(value="${adms.push.port:9999}")
    private int port;
    @Value(value="${spring.redis.database:0}")
    private int redisDb;

    @Bean
    public RedisMessageListenerContainer configRedisMessageListenerContainer() {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(this.redisTemplate.getConnectionFactory());
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(10);
        executor.setMaxPoolSize(100);
        executor.setQueueCapacity(200);
        executor.setKeepAliveSeconds(60);
        executor.setThreadNamePrefix("RedisKeyLive");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        container.setTaskExecutor((Executor)executor);
        ChannelTopic channelKeyExpire = new ChannelTopic("__keyevent@" + this.redisDb + "__:expired");
        container.addMessageListener((MessageListener)this.messageListener, (Topic)channelKeyExpire);
        return container;
    }
}

