/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.posid.remote.PosIDHandConsumeRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDHandConsumeService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDHandConsumeItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDHandConsumeController
extends BaseController
implements PosIDHandConsumeRemote {
    @Autowired
    private PosIDHandConsumeService posIDHandConsumeService;

    @RequiresPermissions(value={"posid:handConsume"})
    public ModelAndView index() {
        return new ModelAndView("posid/handConsume/posIDHandConsume");
    }

    @RequiresPermissions(value={"posid:handConsume:edit"})
    public ModelAndView edit() {
        return new ModelAndView("posid/handConsume/editPosIDHandConsume");
    }

    @RequiresPermissions(value={"posid:handConsume:edit"})
    @LogRequest(module="posid_module", object="posid_leftMenu_handConsume", opType="common_op_new", requestParams={"personPin"}, opContent="posid_card_personNum")
    public ZKResultMsg save(PosIDHandConsumeItem item) {
        ZKResultMsg res = this.posIDHandConsumeService.handConsumeItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"posid:handConsume:refresh"})
    public DxGrid list(PosIDHandConsumeItem codition) {
        Pager pager = this.posIDHandConsumeService.loadPagerByAuthFilter(codition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"posid:handConsume:del"})
    @LogRequest(module="posid_module", object="posid_leftMenu_handConsume", opType="common_op_del", requestParams={"ids"}, opContent="posid_common_id")
    public ZKResultMsg delete(String ids) {
        this.posIDHandConsumeService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @LogRequest(module="posid_module", object="posid_leftMenu_handConsume", opType="common_op_new", requestParams={"personPin"}, opContent="posid_card_personNum")
    public ZKResultMsg editHandConsume() {
        String deviceId = this.request.getParameter("posDeviceId");
        Integer needMoney = Integer.parseInt(this.request.getParameter("money"));
        String date = this.request.getParameter("dateTime");
        String cardSerial = this.request.getParameter("CardMark");
        String sysCardNo = this.request.getParameter("SysID");
        Integer finalBlance = Integer.parseInt(this.request.getParameter("Banlance"));
        String subBalance = this.request.getParameter("PosMoney_Sub");
        String mealId = this.request.getParameter("mealId");
        Integer cashMoney = Integer.parseInt(StringUtils.isNotBlank((CharSequence)this.request.getParameter("cashMoney")) ? this.request.getParameter("cashMoney") : "0.0");
        Integer allowMoney = Integer.parseInt(StringUtils.isNotBlank((CharSequence)this.request.getParameter("allowMoney")) ? this.request.getParameter("allowMoney") : "0.0");
        return this.posIDHandConsumeService.editHandConsume(mealId, date, deviceId, sysCardNo, cardSerial, needMoney, finalBlance, subBalance, cashMoney, allowMoney);
    }
}

