/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.posid.remote.PosIDAccountRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDAccountService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDAccountExportItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDAccountItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDAccountSelectItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDPersonSelectItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDAccountController
extends ExportController
implements PosIDAccountRemote {
    @Autowired
    private PosIDAccountService posIDAccountService;

    @RequiresPermissions(value={"posid:account"})
    public ModelAndView index() {
        return new ModelAndView("posid/account/posIDAccount");
    }

    @RequiresPermissions(value={"posid:account:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.posIDAccountService.getItemById(id));
        }
        return new ModelAndView("posid/account/editPosIDAccount");
    }

    @RequiresPermissions(value={"posid:account:edit"})
    @LogRequest(module="posid_module", object="posid_leftMenu_cardManage", opType="common_op_new", requestParams={"deptName"}, opContent="posid_card_personNum")
    public ZKResultMsg save(PosIDAccountItem item) {
        ZKResultMsg res = new ZKResultMsg();
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public String isExist(@RequestParam(value="sysCardNo") String sysCardNo) {
        return String.valueOf(this.posIDAccountService.isExist(sysCardNo));
    }

    public String isPersPersonExist(@RequestParam(value="personId") String personId) {
        return String.valueOf(this.posIDAccountService.isPersPersonExist(personId));
    }

    @RequiresPermissions(value={"posid:account:refresh"})
    public DxGrid list(PosIDAccountItem codition) {
        Pager pager = this.posIDAccountService.loadPagerByAuthFilter(codition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"posid:account:del"})
    @LogRequest(module="posid_module", object="posid_leftMenu_cardManage", opType="common_op_del", requestParams={"ids"}, opContent="posid_common_id")
    public ZKResultMsg delete(String ids) {
        this.posIDAccountService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"posid:account:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) throws IllegalAccessException, InvocationTargetException {
        PosIDAccountItem posIDAccountItem = new PosIDAccountItem();
        this.setConditionValue((BaseItem)posIDAccountItem);
        List posIDAccountExportItemList = this.posIDAccountService.loadListByAuthFilter(posIDAccountItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(posIDAccountExportItemList, PosIDAccountExportItem.class);
    }

    @RequiresPermissions(value={"posid:account:enable"})
    public ZKResultMsg enable(String ids) {
        ZKResultMsg zKResultMsg = this.posIDAccountService.enable(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"posid:account:disable"})
    public ZKResultMsg disable(String ids) {
        ZKResultMsg zKResultMsg = this.posIDAccountService.disable(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"posid:account:edit"})
    public ModelAndView editAccountType(String ids) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("ids", ids);
        return new ModelAndView("posid/modifiedData/editPosIDAccountType", param);
    }

    public ZKResultMsg setOperator(String ids) {
        ZKResultMsg zKResultMsg = this.posIDAccountService.setStatus(1, ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    public ZKResultMsg setCommonUser(String ids) {
        ZKResultMsg zKResultMsg = this.posIDAccountService.setStatus(0, ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    public DxGrid selectList(PosIDPersonSelectItem condition) {
        Pager pager = new Pager();
        if ("noSelected".equals(condition.getType())) {
            pager = this.posIDAccountService.getNoExistPerson(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if ("selected".equals(condition.getType())) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid selectLossCardList(PosIDAccountSelectItem condition) {
        Pager pager = new Pager();
        if ("noSelected".equals(condition.getType())) {
            pager = this.posIDAccountService.getNoExistCard(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if ("selected".equals(condition.getType())) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid selectAccountList(PosIDAccountSelectItem condition) {
        Pager pager = new Pager();
        if ("noSelected".equals(condition.getType())) {
            pager = this.posIDAccountService.selectAccountList(condition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        } else if ("selected".equals(condition.getType())) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg checkTopUp() {
        String sysCardNo = this.request.getParameter("SysID");
        String mode = this.request.getParameter("mode");
        String target = this.request.getParameter("sysCardNo");
        Double money = Double.parseDouble(this.request.getParameter("money"));
        Double balance = Double.parseDouble(this.request.getParameter("Banlance"));
        Double subBalance = Double.parseDouble(this.request.getParameter("SubBanlance") != null ? this.request.getParameter("SubBanlance") : "0.0");
        return this.posIDAccountService.checkTopUp(target, sysCardNo, mode, money, balance, subBalance);
    }

    @LogRequest(module="posid_module", object="posid_op_topUp", opType="posid_op_topUp", requestParams={"SysID"}, opContent="posid_card_accountNum")
    public ZKResultMsg topUp() {
        Integer money = Integer.parseInt(this.request.getParameter("money"));
        String sysCardNo = this.request.getParameter("SysID");
        return this.posIDAccountService.topUp(money, sysCardNo);
    }

    @LogRequest(module="posid_module", object="posid_op_refund", opType="posid_op_refund", requestParams={"SysID"}, opContent="posid_card_accountNum")
    public ZKResultMsg refund() {
        Integer money = Integer.parseInt(this.request.getParameter("money"));
        String sysCardNo = this.request.getParameter("SysID");
        return this.posIDAccountService.refund(money, sysCardNo);
    }

    public ZKResultMsg modify() {
        String sysCardNo = this.request.getParameter("sysCardNo");
        String password = this.request.getParameter("password");
        String date = this.request.getParameter("issueDate");
        String issueDate = date + " " + new SimpleDateFormat("HH:mm:ss").format(new Date());
        String posCardKind = this.request.getParameter("cardType");
        return this.posIDAccountService.modify(sysCardNo, password, issueDate, posCardKind);
    }

    public String moneyLimit(Integer money, String accountNo, String type) {
        if (!(type.equals("add") || type.equals("0") || type.equals("1"))) {
            money = money * -1;
        }
        return String.valueOf(this.posIDAccountService.moneyLimit(money, accountNo, type));
    }
}

