/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class AuthExportTemplateUtil {
    private static final Logger logger = LoggerFactory.getLogger(AuthExportTemplateUtil.class);
    public static final String EXPORT_RESULT = "export-result:";
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate stringRedisTemplate;
    @Value(value="${security.session.timeout:1800}")
    private Long sessionTimeout;

    public <T> void templateExport(HttpServletRequest request, HttpServletResponse response, Map<String, String> commentMap) {
        String reportType = request.getParameter("reportType");
        if (StringUtils.isBlank((CharSequence)reportType)) {
            reportType = "xlsx";
        }
        String fileNamePrefix = request.getParameter("tableNameParam");
        JSONObject jsonObject = JSONObject.parseObject((String)request.getParameter("jsonColumn"), (Feature[])new Feature[]{Feature.OrderedField});
        if (jsonObject == null) {
            jsonObject = JSONObject.parseObject((String)commentMap.get("jsonColumn"), (Feature[])new Feature[]{Feature.OrderedField});
        }
        reportType = reportType.toLowerCase();
        try {
            boolean isMSIE;
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.createSheet(fileNamePrefix);
            sheet.setDefaultColumnWidth(jsonObject.size());
            HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
            HSSFCellStyle style = workbook.createCellStyle();
            style.setAlignment((short)2);
            HSSFFont font = workbook.createFont();
            style.setVerticalAlignment((short)1);
            style.setAlignment((short)2);
            font.setFontHeightInPoints((short)14);
            style.setFont(font);
            HSSFRow row = sheet.createRow(0);
            HSSFCell cell = row.createCell(0);
            cell.setCellValue(fileNamePrefix);
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, jsonObject.size() - 1));
            cell.setCellStyle(style);
            row.setHeightInPoints(20.0f);
            row.setHeight((short)540);
            row = sheet.createRow(1);
            row.setHeightInPoints(20.0f);
            row.setHeight((short)540);
            int i = 0;
            for (String str : jsonObject.keySet()) {
                sheet.setColumnWidth(i, 5400);
                cell = row.createCell(i);
                cell.setCellValue(jsonObject.getString(str));
                cell.setCellStyle(style);
                if (commentMap.containsKey(str)) {
                    String commentStr = commentMap.get(str);
                    HSSFComment comment = patriarch.createCellComment((ClientAnchor)new HSSFClientAnchor(0, 0, 0, 0, 1, 2, 4, 8));
                    comment.setString((RichTextString)new HSSFRichTextString(commentStr));
                    cell.setCellComment((Comment)comment);
                }
                ++i;
            }
            response.setCharacterEncoding("UTF-8");
            String agent = request.getHeader("User-Agent");
            boolean bl = isMSIE = agent != null && (agent.indexOf("MSIE") != -1 || agent.indexOf("Trident") != -1);
            if (isMSIE) {
                fileNamePrefix = URLEncoder.encode(fileNamePrefix, "UTF-8");
                fileNamePrefix = fileNamePrefix.replaceAll("\\+", " ");
            } else {
                fileNamePrefix = new String(fileNamePrefix.getBytes("UTF-8"), "ISO-8859-1");
            }
            if (request.getHeader("User-Agent") != null && request.getHeader("User-Agent").indexOf("Edge") != -1) {
                fileNamePrefix = fileNamePrefix.replaceAll(" ", "%20");
                fileNamePrefix = URLEncoder.encode(fileNamePrefix, "ISO-8859-1");
                fileNamePrefix = fileNamePrefix.replace("%2520", " ");
            }
            response.setHeader("Content-Disposition", "attachment;filename=\"" + fileNamePrefix + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "." + reportType.toLowerCase() + "\"");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outStream = response.getOutputStream();
            workbook.write((OutputStream)outStream);
        }
        catch (Exception e) {
            logger.error(fileNamePrefix + " export error", (Throwable)e);
            response.setHeader("Content-Disposition", "");
            response.setContentType("application/json");
            throw new ZKBusinessException("common_report_exportFaild");
        }
        finally {
            this.stringRedisTemplate.opsForValue().set((Object)(EXPORT_RESULT + request.getSession().getId()), (Object)"end");
            this.stringRedisTemplate.expire((Object)(EXPORT_RESULT + request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
        }
    }
}

