/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.DateType;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="ATT_ADJUST t LEFT JOIN ATT_PERSON p ON t.PERS_PERSON_ID=p.PERS_PERSON_ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600, operates={@GridOperate(type="del", permission="att:adjust:del", url="attAdjust.do?del&pins=(personPin)", label="common_op_del")})
public class AttAdjustItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.PERS_PERSON_PIN")
    @GridColumn(label="att_person_pin", width="100")
    private String personPin;
    @Column(name="p.PERS_PERSON_NAME")
    @GridColumn(label="att_person_name", width="100", sort="na")
    private String personName;
    @Column(name="p.PERS_PERSON_LASTNAME")
    @GridColumn(label="att_person_lastName", showExpression="#language!='zh_CN'", width="100")
    private String personLastName;
    @GridColumn(label="att_common_deptNo", width="150", sort="na")
    private String deptCode;
    @GridColumn(label="att_common_deptName", width="150", sort="na")
    private String deptName;
    @Column(name="t.ADJUST_TYPE")
    @GridColumn(label="att_adjust_type", width="130", format="0=att_rule_off,1=att_rule_class")
    private Short adjustType;
    @Column(name="t.ADJUST_DATE")
    @DateType(type="date")
    @GridColumn(label="att_adjust_adjustDate", width="130")
    private Date adjustDate;
    @Column(name="t.SHIFT_ID")
    private String shiftId;
    private String shiftNo;
    @GridColumn(label="att_shift_name", width="100")
    private String shiftName;
    @Column(name="t.REMARK")
    @GridColumn(label="common_remark", width="100")
    private String remark;
    @Column(name="t.CREATE_TIME")
    @GridColumn(label="att_common_operateTime", width="130")
    private Date operateDatetime;
    @Column(name="t.AUTH_DEPT_ID")
    private String deptId;
    @Column(name="t.PERS_PERSON_ID")
    private String personId;
    private String applyNo;
    private String applyType;
    @Column(name="t.FLOW_STATUS")
    private String flowStatus;
    private String flowNo;
    @Column(name="t.BUSINESS_KEY")
    private String businessKey;
    @Condition(value="t.CREATE_TIME", equalTag=">=")
    private Date startTime;
    @Condition(value="t.CREATE_TIME", equalTag="<=")
    private Date endTime;
    @Condition(value="t.AUTH_DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.PERS_PERSON_ID", equalTag="in")
    private String inPersonId;
    @Condition(value="t.PERS_PERSON_PIN", equalTag="in")
    private String inPersonPin;
    @Condition(value="(lower(p.PERS_PERSON_NAME) LIKE ''%{0}%'' OR lower(p.PERS_PERSON_LASTNAME) LIKE ''%{0}%'')")
    private String likeName;

    public AttAdjustItem() {
    }

    public AttAdjustItem(Boolean equals) {
        super(equals);
    }

    public AttAdjustItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public AttAdjustItem setId(String id) {
        this.id = id;
        return this;
    }

    public AttAdjustItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public AttAdjustItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public AttAdjustItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public AttAdjustItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public AttAdjustItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public AttAdjustItem setAdjustType(Short adjustType) {
        this.adjustType = adjustType;
        return this;
    }

    public AttAdjustItem setAdjustDate(Date adjustDate) {
        this.adjustDate = adjustDate;
        return this;
    }

    public AttAdjustItem setShiftId(String shiftId) {
        this.shiftId = shiftId;
        return this;
    }

    public AttAdjustItem setShiftNo(String shiftNo) {
        this.shiftNo = shiftNo;
        return this;
    }

    public AttAdjustItem setShiftName(String shiftName) {
        this.shiftName = shiftName;
        return this;
    }

    public AttAdjustItem setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public AttAdjustItem setOperateDatetime(Date operateDatetime) {
        this.operateDatetime = operateDatetime;
        return this;
    }

    public AttAdjustItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public AttAdjustItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public AttAdjustItem setApplyNo(String applyNo) {
        this.applyNo = applyNo;
        return this;
    }

    public AttAdjustItem setApplyType(String applyType) {
        this.applyType = applyType;
        return this;
    }

    public AttAdjustItem setFlowStatus(String flowStatus) {
        this.flowStatus = flowStatus;
        return this;
    }

    public AttAdjustItem setFlowNo(String flowNo) {
        this.flowNo = flowNo;
        return this;
    }

    public AttAdjustItem setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    public AttAdjustItem setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public AttAdjustItem setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public AttAdjustItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public AttAdjustItem setInPersonId(String inPersonId) {
        this.inPersonId = inPersonId;
        return this;
    }

    public AttAdjustItem setInPersonPin(String inPersonPin) {
        this.inPersonPin = inPersonPin;
        return this;
    }

    public AttAdjustItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public Short getAdjustType() {
        return this.adjustType;
    }

    public Date getAdjustDate() {
        return this.adjustDate;
    }

    public String getShiftId() {
        return this.shiftId;
    }

    public String getShiftNo() {
        return this.shiftNo;
    }

    public String getShiftName() {
        return this.shiftName;
    }

    public String getRemark() {
        return this.remark;
    }

    public Date getOperateDatetime() {
        return this.operateDatetime;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getApplyNo() {
        return this.applyNo;
    }

    public String getApplyType() {
        return this.applyType;
    }

    public String getFlowStatus() {
        return this.flowStatus;
    }

    public String getFlowNo() {
        return this.flowNo;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getInPersonId() {
        return this.inPersonId;
    }

    public String getInPersonPin() {
        return this.inPersonPin;
    }

    public String getLikeName() {
        return this.likeName;
    }
}

