/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.controller;

import com.zkteco.zkbiosecurity.auth.remote.AuthPermissionButtonRemote;
import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionButtonItem;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AuthPermissionButtonController
extends BaseController
implements AuthPermissionButtonRemote {
    @Autowired
    private AuthPermissionService authPermissionService;

    public ModelAndView index() {
        String resourceType = this.request.getParameter("resourceType");
        return new ModelAndView("auth/permission/authPermission" + StrUtil.firstUpperCase((String)resourceType));
    }

    public DxGrid list(AuthPermissionButtonItem codition) {
        Pager pager = this.authPermissionService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        List datas = pager.getData();
        if (CollectionUtils.isNotEmpty((Collection)datas)) {
            for (AuthPermissionButtonItem data : datas) {
                data.setName(I18nUtil.i18nCode((String)data.getName(), (Object[])new Object[0]));
            }
        }
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            AuthPermissionItem item = this.authPermissionService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("auth/permission/editAuthPermissionButton");
    }

    public ZKResultMsg save(AuthPermissionItem authPermissionItem) {
        if (StringUtils.isBlank((CharSequence)authPermissionItem.getActionLink())) {
            authPermissionItem.setActionLink(null);
        }
        this.authPermissionService.saveItem(authPermissionItem);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

