/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.websocketService.receiveFromCS;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.CollectionUtil;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.bean.ParkWebsocketMsg;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.park.service.ParkAuthorizeService;
import com.zkteco.zkbiosecurity.park.service.ParkCacheService;
import com.zkteco.zkbiosecurity.park.service.ParkDeviceService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingMeterService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinSideService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordoutService;
import com.zkteco.zkbiosecurity.park.utils.ParkWebCommonUtil;
import com.zkteco.zkbiosecurity.park.vo.ParkAuthorizeItem;
import com.zkteco.zkbiosecurity.park.vo.ParkParkingMeterItem;
import com.zkteco.zkbiosecurity.park.vo.ParkRecordinItem;
import com.zkteco.zkbiosecurity.park.vo.ParkRecordinSideItem;
import com.zkteco.zkbiosecurity.park.vo.ParkRecordoutItem;
import com.zkteco.zkbiosecurity.park.websocketService.ChannelService;
import com.zkteco.zkbiosecurity.park.websocketService.DataCallFuntion;
import com.zkteco.zkbiosecurity.park.websocketService.IDataHandle;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryValueService;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParkCSDataList
implements IDataHandle {
    private Logger logger = LoggerFactory.getLogger(ParkCSDataList.class);
    @Autowired
    private ParkRecordinService parkRecordinService;
    @Autowired
    private ParkRecordoutService parkRecordoutService;
    @Autowired
    private ChannelService channelService;
    @Autowired
    private ParkAuthorizeService parkAuthorizeService;
    @Autowired
    private ParkParkingMeterService parkParkingMeterService;
    @Autowired
    private ParkCacheService parkCacheService;
    @Autowired
    private BaseDictionaryValueService baseDictionaryValueService;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkRecordinSideService parkRecordinSideService;

    @DataCallFuntion(value="getOnSiteVehicle")
    public void getOnSiteVehicle(JSONObject msg) {
        String msgId = msg.getString("msgId");
        String pavilioIp = msg.getString("channelId");
        JSONObject data = msg.getJSONObject("data");
        String carNumber = data.getString("carNumber");
        String carTypeId = data.getString("carTypeId");
        String sTime = data.getString("sTime");
        String eTime = data.getString("eTime");
        int page = 0;
        if (data.containsKey((Object)"page")) {
            page = data.getIntValue("page");
        }
        int size = 30000;
        if (data.containsKey((Object)"size")) {
            size = data.getIntValue("size");
        }
        ParkRecordinItem condition = new ParkRecordinItem();
        condition.setCarNumber(carNumber);
        condition.setCarTypeId(carTypeId);
        condition.setTimeBegin(DateUtil.stringToDate((String)sTime));
        condition.setTimeEnd(DateUtil.stringToDate((String)eTime));
        condition.setStatus(ParkConstants.CAR_STATUS_IN);
        Pager pager = this.parkRecordinService.getItemsByPage((BaseItem)condition, page, size);
        List parkRecordinItemList = pager.getData();
        ParkWebsocketMsg retMsg = new ParkWebsocketMsg("onSiteVehicle");
        retMsg.setMsgId(msgId);
        if (ParkWebCommonUtil.isNotNull(parkRecordinItemList)) {
            JSONArray dataAry = new JSONArray();
            for (ParkRecordinItem item : parkRecordinItemList) {
                JSONObject recordinObj = new JSONObject();
                recordinObj.put("carNumber", (Object)("Empty".equalsIgnoreCase(item.getCarNumber()) ? "" : item.getCarNumber()));
                recordinObj.put("carTypeName", (Object)item.getCarTypeName());
                recordinObj.put("checkinTime", (Object)item.getCheckInTime());
                recordinObj.put("channelName", (Object)item.getChannelName());
                recordinObj.put("photoPath", (Object)item.getPhotoPathIn());
                recordinObj.put("recordinId", (Object)item.getId());
                dataAry.add((Object)recordinObj);
            }
            retMsg.setData(dataAry.toJSONString());
        }
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)retMsg));
    }

    @DataCallFuntion(value="getPagerOnSiteVehicle")
    public void getPagerOnSiteVehicle(JSONObject msg) {
        String msgId = msg.getString("msgId");
        String pavilioIp = msg.getString("channelId");
        JSONObject data = msg.getJSONObject("data");
        String carNumber = data.getString("carNumber");
        String carTypeId = data.getString("carTypeId");
        String sTime = data.getString("sTime");
        String eTime = data.getString("eTime");
        int page = 0;
        if (data.containsKey((Object)"page")) {
            page = data.getIntValue("page");
        }
        int size = 30000;
        if (data.containsKey((Object)"size")) {
            size = data.getIntValue("size");
        }
        ParkRecordinItem condition = new ParkRecordinItem();
        condition.setCarNumber(carNumber);
        condition.setCarTypeId(carTypeId);
        condition.setTimeBegin(DateUtil.stringToDate((String)sTime));
        condition.setTimeEnd(DateUtil.stringToDate((String)eTime));
        condition.setStatus(ParkConstants.CAR_STATUS_IN);
        Pager pager = this.parkRecordinService.getItemsByPage((BaseItem)condition, page, size);
        JSONObject retData = new JSONObject();
        retData.put("page", (Object)page);
        retData.put("size", (Object)size);
        retData.put("total", (Object)pager.getTotal());
        List parkRecordinItemList = pager.getData();
        ParkWebsocketMsg retMsg = new ParkWebsocketMsg("pagerOnSiteVehicle");
        retMsg.setMsgId(msgId);
        if (ParkWebCommonUtil.isNotNull(parkRecordinItemList)) {
            JSONArray dataAry = new JSONArray();
            for (ParkRecordinItem item : parkRecordinItemList) {
                JSONObject recordinObj = new JSONObject();
                recordinObj.put("carNumber", (Object)("Empty".equalsIgnoreCase(item.getCarNumber()) ? "" : item.getCarNumber()));
                recordinObj.put("carTypeName", (Object)item.getCarTypeName());
                recordinObj.put("checkinTime", (Object)item.getCheckInTime());
                recordinObj.put("channelName", (Object)item.getChannelName());
                recordinObj.put("photoPath", (Object)item.getPhotoPathIn());
                recordinObj.put("recordinId", (Object)item.getId());
                dataAry.add((Object)recordinObj);
            }
            retData.put("data", (Object)dataAry);
            retMsg.setData(JSONObject.toJSONString((Object)retData));
        }
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)retMsg));
    }

    @DataCallFuntion(value="getCheckoutData")
    public void getCheckoutData(JSONObject msg) {
        String msgId = msg.getString("msgId");
        String pavilioIp = msg.getString("channelId");
        JSONObject data = msg.getJSONObject("data");
        String dutyId = data.getString("dutyId");
        String carNumber = data.getString("carNumber");
        String carTypeId = data.getString("carTypeId");
        String sTime = data.getString("sTime");
        String eTime = data.getString("eTime");
        int page = 0;
        if (data.containsKey((Object)"page")) {
            page = data.getIntValue("page");
        }
        int size = 30000;
        if (data.containsKey((Object)"size")) {
            size = data.getIntValue("size");
        }
        ParkRecordoutItem condition = new ParkRecordoutItem();
        condition.setCarNumber(carNumber);
        condition.setCarTypeId(carTypeId);
        condition.setTimeBegin(DateUtil.stringToDate((String)sTime));
        condition.setTimeEnd(DateUtil.stringToDate((String)eTime));
        condition.setDutyId(dutyId);
        Pager pager = this.parkRecordoutService.getItemsByPage((BaseItem)condition, page, size);
        List parkRecordoutItemList = pager.getData();
        ParkWebsocketMsg retMsg = new ParkWebsocketMsg("checkoutData");
        retMsg.setMsgId(msgId);
        if (ParkWebCommonUtil.isNotNull(parkRecordoutItemList)) {
            JSONArray dataAry = new JSONArray();
            List parkRecordoutItems = CollectionUtil.split((Collection)parkRecordoutItemList, (int)800);
            for (List items : parkRecordoutItems) {
                String recordoutIds = CollectionUtil.getPropertys((Collection)items, ParkRecordoutItem::getId);
                ParkParkingMeterItem parkParkingMeter = new ParkParkingMeterItem();
                parkParkingMeter.setRecordoutIdIn(recordoutIds);
                List parkParkingMeterItemList = this.parkParkingMeterService.getByCondition(parkParkingMeter);
                Map parkParkingMeterMap = CollectionUtil.listToKeyMap((Collection)parkParkingMeterItemList, ParkParkingMeterItem::getRecordoutId);
                for (ParkRecordoutItem item : items) {
                    JSONObject dataObj = new JSONObject();
                    String parkCarNumber = item.getCarNumber();
                    dataObj.put("carNumber", (Object)("Empty".equalsIgnoreCase(parkCarNumber) ? "" : parkCarNumber));
                    dataObj.put("carTypeName", (Object)item.getCarTypeName());
                    Timestamp checkinTime = item.getCheckInTime();
                    if (checkinTime == null || "0".equals(checkinTime.toString())) {
                        dataObj.put("checkinTime", (Object)"0");
                    } else {
                        dataObj.put("checkinTime", (Object)checkinTime);
                    }
                    dataObj.put("checkoutTime", (Object)item.getCheckOutTime());
                    Short eventType = item.getEventType();
                    dataObj.put("eventType", (Object)eventType);
                    String eventTypeName = "";
                    if (ParkWebCommonUtil.isNotNull(eventType)) {
                        eventTypeName = (String)this.baseDictionaryValueService.getDictionaryValuesMap("parkEventType").get(eventType.toString());
                    }
                    dataObj.put("event", (Object)eventTypeName);
                    dataObj.put("photoPath", (Object)item.getPhotoPathOut());
                    ParkParkingMeterItem parkParkingMeterItem = (ParkParkingMeterItem)parkParkingMeterMap.remove(item.getId());
                    dataObj.put("charge", (Object)parkParkingMeterItem.getReceiveAmount());
                    dataObj.put("amountReceivable", (Object)parkParkingMeterItem.getAmountReceivable());
                    dataObj.put("discountAmount", (Object)parkParkingMeterItem.getDiscountAmount());
                    dataObj.put("reliefAmount", (Object)parkParkingMeterItem.getReliefAmount());
                    Short paymentMethod = parkParkingMeterItem.getPaymentMethod();
                    dataObj.put("paymentMethod", (Object)paymentMethod);
                    String paymentName = "";
                    if (ParkWebCommonUtil.isNotNull(paymentMethod)) {
                        paymentName = ParkWebCommonUtil.getPayMentByCode(paymentMethod);
                    }
                    dataObj.put("paymentName", (Object)paymentName);
                    dataObj.put("metterId", (Object)parkParkingMeterItem.getId());
                    dataAry.add((Object)dataObj);
                }
            }
            retMsg.setData(dataAry.toJSONString());
        }
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)retMsg));
    }

    @DataCallFuntion(value="getPagerCheckoutData")
    public void getPagerCheckoutData(JSONObject msg) {
        String msgId = msg.getString("msgId");
        String pavilioIp = msg.getString("channelId");
        JSONObject data = msg.getJSONObject("data");
        String dutyId = data.getString("dutyId");
        String carNumber = data.getString("carNumber");
        String carTypeId = data.getString("carTypeId");
        String sTime = data.getString("sTime");
        String eTime = data.getString("eTime");
        int page = 0;
        if (data.containsKey((Object)"page")) {
            page = data.getIntValue("page");
        }
        int size = 30000;
        if (data.containsKey((Object)"size")) {
            size = data.getIntValue("size");
        }
        ParkRecordoutItem condition = new ParkRecordoutItem();
        condition.setCarNumber(carNumber);
        condition.setCarTypeId(carTypeId);
        condition.setTimeBegin(DateUtil.stringToDate((String)sTime));
        condition.setTimeEnd(DateUtil.stringToDate((String)eTime));
        condition.setDutyId(dutyId);
        Pager pager = this.parkRecordoutService.getItemsByPage((BaseItem)condition, page, size);
        JSONObject retData = new JSONObject();
        retData.put("page", (Object)page);
        retData.put("size", (Object)size);
        retData.put("total", (Object)pager.getTotal());
        List parkRecordoutItemList = pager.getData();
        ParkWebsocketMsg retMsg = new ParkWebsocketMsg("pagerCheckoutData");
        retMsg.setMsgId(msgId);
        if (ParkWebCommonUtil.isNotNull(parkRecordoutItemList)) {
            JSONArray dataAry = new JSONArray();
            List parkRecordoutItems = CollectionUtil.split((Collection)parkRecordoutItemList, (int)800);
            for (List items : parkRecordoutItems) {
                String recordoutIds = CollectionUtil.getPropertys((Collection)items, ParkRecordoutItem::getId);
                ParkParkingMeterItem parkParkingMeter = new ParkParkingMeterItem();
                parkParkingMeter.setRecordoutIdIn(recordoutIds);
                List parkParkingMeterItemList = this.parkParkingMeterService.getByCondition(parkParkingMeter);
                Map parkParkingMeterMap = CollectionUtil.listToKeyMap((Collection)parkParkingMeterItemList, ParkParkingMeterItem::getRecordoutId);
                for (ParkRecordoutItem item : items) {
                    JSONObject dataObj = new JSONObject();
                    String parkCarNumber = item.getCarNumber();
                    dataObj.put("carNumber", (Object)("Empty".equalsIgnoreCase(parkCarNumber) ? "" : parkCarNumber));
                    dataObj.put("carTypeName", (Object)item.getCarTypeName());
                    Timestamp checkinTime = item.getCheckInTime();
                    if (checkinTime == null || "0".equals(checkinTime.toString())) {
                        dataObj.put("checkinTime", (Object)"0");
                    } else {
                        dataObj.put("checkinTime", (Object)checkinTime);
                    }
                    dataObj.put("checkoutTime", (Object)item.getCheckOutTime());
                    Short eventType = item.getEventType();
                    dataObj.put("eventType", (Object)eventType);
                    String eventTypeName = "";
                    if (ParkWebCommonUtil.isNotNull(eventType)) {
                        eventTypeName = (String)this.baseDictionaryValueService.getDictionaryValuesMap("parkEventType").get(eventType.toString());
                    }
                    dataObj.put("event", (Object)eventTypeName);
                    dataObj.put("photoPath", (Object)item.getPhotoPathOut());
                    ParkParkingMeterItem parkParkingMeterItem = (ParkParkingMeterItem)parkParkingMeterMap.remove(item.getId());
                    dataObj.put("charge", (Object)parkParkingMeterItem.getReceiveAmount());
                    dataObj.put("amountReceivable", (Object)parkParkingMeterItem.getAmountReceivable());
                    dataObj.put("discountAmount", (Object)parkParkingMeterItem.getDiscountAmount());
                    dataObj.put("reliefAmount", (Object)parkParkingMeterItem.getReliefAmount());
                    Short paymentMethod = parkParkingMeterItem.getPaymentMethod();
                    dataObj.put("paymentMethod", (Object)paymentMethod);
                    String paymentName = "";
                    if (ParkWebCommonUtil.isNotNull(paymentMethod)) {
                        paymentName = ParkWebCommonUtil.getPayMentByCode(paymentMethod);
                    }
                    dataObj.put("paymentName", (Object)paymentName);
                    dataObj.put("metterId", (Object)parkParkingMeterItem.getId());
                    dataAry.add((Object)dataObj);
                }
            }
            retData.put("data", (Object)dataAry);
            retMsg.setData(JSONObject.toJSONString((Object)retData));
        }
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)retMsg));
    }

    @DataCallFuntion(value="getPhotoData")
    public void getPhotoData(JSONObject msg) {
        String msgId = msg.getString("msgId");
        String pavilioIp = msg.getString("channelId");
        String photpPath = msg.getString("data");
        ParkWebsocketMsg retMsg = new ParkWebsocketMsg("photoData");
        retMsg.setMsgId(msgId);
        String fullPath = ParkWebCommonUtil.getSystemFilePath() + photpPath;
        String photpData = ParkWebCommonUtil.getImgBase64ByteByPath(fullPath);
        JSONObject dataObj = new JSONObject();
        dataObj.put("photoData", (Object)photpData);
        dataObj.put("photoDataMsg", (Object)this.getPhotoDataMsg(photpPath));
        retMsg.setData(dataObj.toJSONString());
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)retMsg));
    }

    @DataCallFuntion(value="getEntryAndExitDetails")
    public void getEntryAndExitDetails(JSONObject msg) {
        String msgId = msg.getString("msgId");
        String pavilioIp = msg.getString("channelId");
        JSONObject data = msg.getJSONObject("data");
        String state = data.getString("state");
        String recordId = data.getString("recordId");
        ParkWebsocketMsg retMsg = new ParkWebsocketMsg("entryAndExitDetails");
        retMsg.setMsgId(msgId);
        JSONObject dataObj = new JSONObject();
        if ("in".equals(state)) {
            ParkRecordinItem item = this.parkRecordinService.getItemById(recordId);
            this.setRecordinData(item, dataObj);
        } else {
            ParkParkingMeterItem parkParkingMeterItem = this.parkParkingMeterService.getItemById(recordId);
            if (ParkWebCommonUtil.isNotNull(parkParkingMeterItem)) {
                this.setRecordoutDataEx(parkParkingMeterItem, dataObj);
            }
        }
        retMsg.setData(dataObj.toJSONString());
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)retMsg));
    }

    private void setRecordinData(ParkRecordinItem item, JSONObject dataObj) {
        String carNumber = item.getCarNumber();
        if (item.getCarTypeCode().contains("month")) {
            ParkAuthorizeItem authItem = this.parkAuthorizeService.getByCarNumberIdEx(carNumber);
            dataObj.put("isAuth", (Object)true);
            dataObj.put("authName", (Object)item.getUserName());
            dataObj.put("validityPeriod", (Object)authItem.getEndTime());
            dataObj.put("spaceName", (Object)authItem.getParkingSpaceName());
        } else {
            dataObj.put("isAuth", (Object)false);
            if (ParkWebCommonUtil.isNull(carNumber) || "Empty".equals(carNumber)) {
                carNumber = "";
            }
        }
        dataObj.put("checkinTime", (Object)item.getCheckInTime());
        dataObj.put("carNumber", (Object)carNumber);
        dataObj.put("pavilioIn", (Object)item.getPavilioName());
        String fullPath = ParkWebCommonUtil.getSystemFilePath() + item.getPhotoPathIn();
        String photpData = ParkWebCommonUtil.getImgBase64ByteByPath(fullPath);
        dataObj.put("photoDataIn", (Object)photpData);
        dataObj.put("photoDataInMsg", (Object)this.getPhotoDataMsg(item.getPhotoPathIn()));
    }

    private void setRecordoutDataEx(ParkParkingMeterItem parkParkingMeterItem, JSONObject dataObj) {
        ParkRecordoutItem parkRecordoutItem;
        ParkRecordinSideItem parkRecordinSideItem;
        dataObj.put("charge", (Object)parkParkingMeterItem.getReceiveAmount());
        String pavilioIn = null;
        String photoDataIn = null;
        Timestamp recordinTime = null;
        if (StringUtils.isNotBlank((CharSequence)parkParkingMeterItem.getRecordinId()) && (parkRecordinSideItem = this.parkRecordinSideService.getByParkRecordinId(parkParkingMeterItem.getRecordinId())) != null) {
            pavilioIn = parkRecordinSideItem.getParkPavilioName();
            photoDataIn = parkRecordinSideItem.getPhotoPathIn();
            recordinTime = parkRecordinSideItem.getCheckInTime();
        }
        dataObj.put("pavilioIn", pavilioIn);
        String fullPath = ParkWebCommonUtil.getSystemFilePath() + photoDataIn;
        String photpData = ParkWebCommonUtil.getImgBase64ByteByPath(fullPath);
        dataObj.put("photoDataIn", (Object)photpData);
        dataObj.put("photoDataInMsg", (Object)this.getPhotoDataMsg(photoDataIn));
        if (ParkWebCommonUtil.isNotNull(recordinTime) && !"0".equals(recordinTime.toString())) {
            dataObj.put("checkinTime", (Object)recordinTime);
        } else {
            dataObj.put("checkinTime", (Object)"0");
        }
        String pavilioOut = null;
        String photoDataOut = null;
        Timestamp recordoutTime = null;
        String code = "tempA";
        if (StringUtils.isNotBlank((CharSequence)parkParkingMeterItem.getRecordoutId()) && (parkRecordoutItem = this.parkRecordoutService.getItemById(parkParkingMeterItem.getRecordoutId())) != null) {
            pavilioOut = parkRecordoutItem.getParkPavilioName();
            photoDataOut = parkRecordoutItem.getPhotoPathOut();
            recordoutTime = parkRecordoutItem.getCheckOutTime();
            code = parkRecordoutItem.getCarTypeCode();
        }
        dataObj.put("pavilioOut", pavilioOut);
        fullPath = ParkWebCommonUtil.getSystemFilePath() + photoDataOut;
        photpData = ParkWebCommonUtil.getImgBase64ByteByPath(fullPath);
        dataObj.put("photoDataOut", (Object)photpData);
        dataObj.put("photoDataOutMsg", (Object)this.getPhotoDataMsg(photoDataOut));
        dataObj.put("checkouTime", (Object)recordoutTime);
        String carNumber = parkParkingMeterItem.getCarNumber();
        if (code.contains("month")) {
            ParkAuthorizeItem authItem = this.parkAuthorizeService.getByCarNumberIdEx(carNumber);
            if (authItem != null) {
                dataObj.put("isAuth", (Object)true);
                dataObj.put("authName", (Object)authItem.getPersonName());
                dataObj.put("validityPeriod", (Object)authItem.getEndTime());
                dataObj.put("spaceName", (Object)authItem.getParkingSpaceName());
            }
        } else {
            dataObj.put("isAuth", (Object)false);
        }
        if (ParkWebCommonUtil.isNull(carNumber) || "Empty".equals(carNumber)) {
            carNumber = "";
        }
        dataObj.put("carNumber", (Object)carNumber);
    }

    private String getPhotoDataMsg(String photoData) {
        if (StringUtils.isBlank((CharSequence)photoData)) {
            return I18nUtil.i18nCode((String)"park_recordin_notMatchPhoto", (Object[])new Object[0]);
        }
        String msg = "";
        switch (photoData) {
            case "offine": {
                msg = I18nUtil.i18nCode((String)"park_offlineSet_notSupportCapture", (Object[])new Object[0]);
                break;
            }
            case "unMatch": {
                msg = I18nUtil.i18nCode((String)"park_recordin_notMatchPhoto", (Object[])new Object[0]);
                break;
            }
            case "fail": {
                msg = I18nUtil.i18nCode((String)"park_recordin_captureFailed", (Object[])new Object[0]);
                break;
            }
            case "noVidChannel": {
                msg = I18nUtil.i18nCode((String)"park_recordin_noVidChannel", (Object[])new Object[0]);
            }
        }
        return msg;
    }

    @DataCallFuntion(value="offlineDeviceData")
    public void offlineDeviceData(JSONObject msg) {
        String msgId = msg.getString("msgId");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Ret", (Object)msg.getIntValue("ret"));
        String params = msg.getJSONObject("data").getString("params");
        String type = msg.getJSONObject("data").getString("type");
        JSONObject data = new JSONObject();
        data.put("DataBuf", (Object)params);
        data.put("Type", (Object)type);
        jsonObject.put("Data", (Object)data);
        this.parkCacheService.setJson("park:ws_msgid_" + msgId, jsonObject, 0L);
    }

    @DataCallFuntion(value="offlineParam")
    public void offlineParam(JSONObject msg) {
        String msgId = msg.getString("msgId");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Ret", (Object)msg.getIntValue("ret"));
        jsonObject.put("Data", (Object)msg.getJSONObject("data").getJSONObject("params"));
        this.parkCacheService.setJson("park:ws_msgid_" + msgId, jsonObject, 0L);
    }

    @DataCallFuntion(value="offlinePlateList")
    public void offlinePlateList(JSONObject msg) {
        String msgId = msg.getString("msgId");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Ret", (Object)msg.getIntValue("ret"));
        JSONObject data = new JSONObject();
        JSONArray plateList = msg.getJSONObject("data").getJSONArray("plateList");
        data.put("Count", (Object)plateList.size());
        if (plateList.size() > 0) {
            int type = msg.getJSONObject("data").getIntValue("type");
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < plateList.size(); ++i) {
                JSONObject json = plateList.getJSONObject(i);
                sb.append(json.getString("szPlate"));
                if (type == 1) continue;
                JSONObject fromDate = json.getJSONObject("fromDate");
                String fromString = fromDate.get((Object)"nYear") + "-" + fromDate.get((Object)"nMonth") + "-" + fromDate.get((Object)"nDay");
                JSONObject toDate = json.getJSONObject("toDate");
                String toString = toDate.get((Object)"nYear") + "-" + toDate.get((Object)"nMonth") + "-" + toDate.get((Object)"nDay");
                sb.append(" " + fromString + " " + toString + ";");
            }
            data.put("PlateList", (Object)sb.toString());
        } else {
            data.put("PlateList", null);
        }
        jsonObject.put("Data", (Object)data);
        this.parkCacheService.setJson("park:ws_msgid_" + msgId, jsonObject, 0L);
    }

    @DataCallFuntion(value="deviceData")
    public void deviceData(JSONObject msg) {
        String msgId = msg.getString("msgId");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Ret", (Object)msg.getIntValue("ret"));
        jsonObject.put("OpType", (Object)msg.getString("funcId"));
        JSONArray dataArray = msg.getJSONArray("data");
        jsonObject.put("Data", (Object)(dataArray.getJSONObject(0).getString("dataBuf") + dataArray.getJSONObject(1).getString("dataBuf")));
        this.parkCacheService.setJson("park:ws_msgid_" + msgId, jsonObject, 0L);
    }

    @DataCallFuntion(value="onRecordCallback")
    public void onRecordCallback(JSONObject msg) {
        JSONObject json = msg.getJSONObject("data");
        String dataStr = json.getString("data");
        String tableType = json.getString("type");
        this.parkDeviceService.startSaveOfflineRecordCallBackThread(dataStr, tableType);
    }

    @DataCallFuntion(value="importPlateList")
    public void importPlateList(JSONObject msg) {
        String msgId = msg.getString("msgId");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Ret", (Object)msg.getIntValue("ret"));
        jsonObject.put("OpType", (Object)msg.getString("funcId"));
        this.parkCacheService.setJson("park:ws_msgid_" + msgId, jsonObject, 0L);
    }

    @DataCallFuntion(value="setOfflineParam")
    public void setOfflineParam(JSONObject msg) {
        String msgId = msg.getString("msgId");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Ret", (Object)msg.getIntValue("ret"));
        jsonObject.put("OpType", (Object)msg.getString("funcId"));
        this.parkCacheService.setJson("park:ws_msgid_" + msgId, jsonObject, 0L);
    }

    @DataCallFuntion(value="addPlateList")
    public void addPlateList(JSONObject msg) {
        String msgId = msg.getString("msgId");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Ret", (Object)msg.getIntValue("ret"));
        jsonObject.put("OpType", (Object)msg.getString("funcId"));
        this.parkCacheService.setJson("park:ws_msgid_" + msgId, jsonObject, 0L);
    }

    @DataCallFuntion(value="delPlateList")
    public void delPlateList(JSONObject msg) {
        String msgId = msg.getString("msgId");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Ret", (Object)msg.getIntValue("ret"));
        jsonObject.put("OpType", (Object)msg.getString("funcId"));
        this.parkCacheService.setJson("park:ws_msgid_" + msgId, jsonObject, 0L);
    }

    @DataCallFuntion(value="setDateTime")
    public void setDateTime(JSONObject msg) {
        String msgId = msg.getString("msgId");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Ret", (Object)msg.getIntValue("ret"));
        jsonObject.put("OpType", (Object)msg.getString("funcId"));
        this.parkCacheService.setJson("park:ws_msgid_" + msgId, jsonObject, 0L);
    }

    @DataCallFuntion(value="devVerInfo")
    public void devVerInfo(JSONObject msg) {
        String msgId = msg.getString("msgId");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Ret", (Object)msg.getIntValue("ret"));
        jsonObject.put("OpType", (Object)msg.getString("funcId"));
        jsonObject.put("Data", (Object)msg.getJSONObject("data").getJSONObject("devVerinfo"));
        this.parkCacheService.setJson("park:ws_msgid_" + msgId, jsonObject, 0L);
    }

    @DataCallFuntion(value="clearOfflineDeviceData")
    public void clearOfflineDeviceData(JSONObject msg) {
        String msgId = msg.getString("msgId");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Ret", (Object)msg.getIntValue("ret"));
        jsonObject.put("OpType", (Object)msg.getString("funcId"));
        this.parkCacheService.setJson("park:ws_msgid_" + msgId, jsonObject, 0L);
    }

    @DataCallFuntion(value="resetFactoryWithOffline")
    public void resetFactoryWithOffline(JSONObject msg) {
        String msgId = msg.getString("msgId");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Ret", (Object)msg.getIntValue("ret"));
        jsonObject.put("OpType", (Object)msg.getString("funcId"));
        this.parkCacheService.setJson("park:ws_msgid_" + msgId, jsonObject, 0L);
    }
}

