/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.utils;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectUtil {
    private static final Logger log = LoggerFactory.getLogger(ConnectUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkConnected(String url) {
        boolean isReachable = false;
        URI uri = URI.create(url);
        String host = uri.getHost();
        if (StringUtils.isBlank((CharSequence)host)) {
            return isReachable;
        }
        int port = uri.getPort();
        if (port == -1) {
            port = 80;
        }
        Socket connect = new Socket();
        try {
            InetSocketAddress endpointSocketAddr = new InetSocketAddress(host, port);
            connect.connect(endpointSocketAddr, 3000);
            isReachable = connect.isConnected();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Object)(" ip = " + host + ", port = " + port));
        }
        finally {
            if (connect != null) {
                try {
                    connect.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Object)(" ip = " + host + ", port = " + port));
                }
            }
        }
        return isReachable;
    }
}

