/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisVisitedDepartmentRemote;
import com.zkteco.zkbiosecurity.vis.service.VisVisitedDepartmentService;
import com.zkteco.zkbiosecurity.vis.vo.VisVisitedDepartmentItem;
import com.zkteco.zkbiosecurity.vis.vo.VisVisitedDepartmentSelectItem;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisVisitedDepartmentController
extends BaseController
implements VisVisitedDepartmentRemote {
    @Autowired
    private VisVisitedDepartmentService visVisitedDepartmentService;

    @RequiresPermissions(value={"vis:visitedDepartment"})
    public ModelAndView index() {
        return new ModelAndView("vis/visitedDepartment/visVisitedDepartment");
    }

    @RequiresPermissions(value={"vis:visitedDepartment:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.visVisitedDepartmentService.getItemById(id));
        }
        return new ModelAndView("vis/department/editVisDepartment");
    }

    @RequiresPermissions(value={"vis:visitedDepartment:edit"})
    public ZKResultMsg save(VisVisitedDepartmentItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.visVisitedDepartmentService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"vis:visitedDepartment:refresh"})
    public DxGrid list(VisVisitedDepartmentItem condition) {
        Pager pager = this.visVisitedDepartmentService.getVisVisitedDeptItemsByPage(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:visitedDepartment:del"})
    @LogRequest(module="vis_module", object="vis_leftMenu_department", opType="common_op_del", requestParams={"codes"}, opContent="vis_department_no")
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        this.visVisitedDepartmentService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @LogRequest(module="vis_module", object="vis_leftMenu_department", opType="common_op_new", requestParams={"codes"}, opContent="vis_department_no")
    public ZKResultMsg saveDept() {
        String deptIds = this.request.getParameter("deptIds");
        String checkVal = this.request.getParameter("checkVal");
        if (StringUtils.isNotBlank((CharSequence)checkVal) && "3".equals(checkVal)) {
            deptIds = this.visVisitedDepartmentService.getAllDeptIds();
        }
        if (StringUtils.isNotBlank((CharSequence)deptIds)) {
            List deptIdList = StrUtil.strToList((String)deptIds);
            VisVisitedDepartmentItem item = null;
            for (String deptId : deptIdList) {
                item = new VisVisitedDepartmentItem();
                item.setDepartmentId(deptId);
                this.visVisitedDepartmentService.saveItem(item);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"vis:visitedDepartment:edit"})
    public DxGrid selectVisitedDeptList(VisVisitedDepartmentSelectItem condition) {
        Pager pager = new Pager(this.getPageNo(), this.getPageSize());
        if (condition.getType().equals("noSelected")) {
            pager = this.visVisitedDepartmentService.getNoExistDept(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }
}

