/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisBioTemplateRemote;
import com.zkteco.zkbiosecurity.vis.service.VisBioTemplateService;
import com.zkteco.zkbiosecurity.vis.vo.VisBioTemplateItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisBioTemplateController
extends BaseController
implements VisBioTemplateRemote {
    @Autowired
    private VisBioTemplateService visBioTemplateService;

    @RequiresPermissions(value={"vis:bioTemplate:view"})
    public ModelAndView index() {
        return new ModelAndView("vis/bioTemplate/visBioTemplate");
    }

    @RequiresPermissions(value={"vis:bioTemplate:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.visBioTemplateService.getItemById(id));
        }
        return new ModelAndView("vis/bioTemplate/editVisBioTemplate");
    }

    @RequiresPermissions(value={"vis:bioTemplate:edit"})
    public ZKResultMsg save(VisBioTemplateItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.visBioTemplateService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(VisBioTemplateItem condition) {
        Pager pager = this.visBioTemplateService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.visBioTemplateService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

