/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;

@From(after="VIS_VISITOR t LEFT JOIN vis_watchlist w on t.cert_number=w.cert_number AND t.cert_type=w.cert_type AND w.enabled=1 LEFT JOIN vis_watchlist_category g on w.category=g.id")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=510, winWidth=770, operates={@GridOperate(type="del", permission="vis:visitor:del", url="visVisitor.do?del&names=(name)", label="common_op_del")})
public class VisVisitorItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.PIN")
    @GridColumn(label="vis_emp_pin", width="100", columnType="edit", editPermission="vis:visitor:refresh", editUrl="visVisitor.do?edit")
    private String pin;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", width="100")
    private String name;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="100", showExpression="#language!='zh_CN'")
    private String lastName;
    @Column(name="t.CERT_TYPE", equalTag="=")
    private String certType;
    @Column(name="t.CERT_TYPE")
    @GridColumn(columnType="dic", key="certificateType", label="vis_cert_type", width="120")
    private String certName;
    @Column(name="t.CERT_NUMBER")
    @GridColumn(label="vis_cert_number", width="140")
    private String certNumber;
    @Column(name="t.COMPANY")
    @GridColumn(label="vis_common_company", width="100")
    private String company;
    @Column(name="t.CAR_PLATE")
    @GridColumn(label="vis_emp_carPlate", width="100")
    private String carPlate;
    @Column(name="t.PHONE")
    @GridColumn(label="pers_person_mobilePhone", width="100")
    private String phone;
    @Column(name="t.EMAIL")
    private String email;
    @Column(name="g.CATEGORY")
    @GridColumn(label="vis_watchList_category", width="100", showExpression="#language!='zh_CN'", defaultValue="vis_watchList_normal", i18n=true)
    private String status;
    @Column(name="t.ENABLED")
    @GridColumn(label="vis_export_enable", width="100", columnType="custom", convert="convertEnableToIcon", format="true=common_yes,false=common_no")
    private Boolean enabled;
    @Column(name="t.CREATE_TIME")
    @GridColumn(label="vis_emp_createdTime", width="123")
    private Date createTime;
    @Column(name="t.CERT_PHOTO")
    @GridColumn(show=false)
    private String certPhoto;
    @Column(name="t.NATIONALITY")
    @GridColumn(show=false)
    private Integer nationality;
    @Column(name="t.NAME_SPELL")
    @GridColumn(show=false)
    private String nameSpell;
    @Column(name="t.GENDER")
    @GridColumn(show=false)
    private String gender;
    @Column(name="t.HEAD_PORTRAIT")
    @GridColumn(show=false)
    private String headPortrait;
    @Column(name="t.CHANGE_OPERATOR")
    @GridColumn(show=false)
    private String changeOperator;
    @Column(name="t.CHANGE_TIME")
    @GridColumn(show=false)
    private Date changeTime;
    @Column(name="t.PARK_BLACKWHITE_ID")
    private String parkBlackWhiteId;
    @Condition(value="(LOWER (t.NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @GridColumn(dynamicColumn="visVisitorDyna")
    private Map attrValueMap;
    @Condition(value="t.ID", equalTag="in")
    private String idIn;
    @Column(name="t.ID", equalTag="not in")
    private String notInId;

    public VisVisitorItem() {
    }

    public VisVisitorItem(Boolean equals) {
        super(equals);
    }

    public VisVisitorItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public VisVisitorItem setId(String id) {
        this.id = id;
        return this;
    }

    public VisVisitorItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public VisVisitorItem setName(String name) {
        this.name = name;
        return this;
    }

    public VisVisitorItem setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public VisVisitorItem setCertType(String certType) {
        this.certType = certType;
        return this;
    }

    public VisVisitorItem setCertName(String certName) {
        this.certName = certName;
        return this;
    }

    public VisVisitorItem setCertNumber(String certNumber) {
        this.certNumber = certNumber;
        return this;
    }

    public VisVisitorItem setCompany(String company) {
        this.company = company;
        return this;
    }

    public VisVisitorItem setCarPlate(String carPlate) {
        this.carPlate = carPlate;
        return this;
    }

    public VisVisitorItem setPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public VisVisitorItem setEmail(String email) {
        this.email = email;
        return this;
    }

    public VisVisitorItem setStatus(String status) {
        this.status = status;
        return this;
    }

    public VisVisitorItem setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public VisVisitorItem setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public VisVisitorItem setCertPhoto(String certPhoto) {
        this.certPhoto = certPhoto;
        return this;
    }

    public VisVisitorItem setNationality(Integer nationality) {
        this.nationality = nationality;
        return this;
    }

    public VisVisitorItem setNameSpell(String nameSpell) {
        this.nameSpell = nameSpell;
        return this;
    }

    public VisVisitorItem setGender(String gender) {
        this.gender = gender;
        return this;
    }

    public VisVisitorItem setHeadPortrait(String headPortrait) {
        this.headPortrait = headPortrait;
        return this;
    }

    public VisVisitorItem setChangeOperator(String changeOperator) {
        this.changeOperator = changeOperator;
        return this;
    }

    public VisVisitorItem setChangeTime(Date changeTime) {
        this.changeTime = changeTime;
        return this;
    }

    public VisVisitorItem setParkBlackWhiteId(String parkBlackWhiteId) {
        this.parkBlackWhiteId = parkBlackWhiteId;
        return this;
    }

    public VisVisitorItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public VisVisitorItem setAttrValueMap(Map attrValueMap) {
        this.attrValueMap = attrValueMap;
        return this;
    }

    public VisVisitorItem setIdIn(String idIn) {
        this.idIn = idIn;
        return this;
    }

    public VisVisitorItem setNotInId(String notInId) {
        this.notInId = notInId;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getPin() {
        return this.pin;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getCertType() {
        return this.certType;
    }

    public String getCertName() {
        return this.certName;
    }

    public String getCertNumber() {
        return this.certNumber;
    }

    public String getCompany() {
        return this.company;
    }

    public String getCarPlate() {
        return this.carPlate;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getEmail() {
        return this.email;
    }

    public String getStatus() {
        return this.status;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getCertPhoto() {
        return this.certPhoto;
    }

    public Integer getNationality() {
        return this.nationality;
    }

    public String getNameSpell() {
        return this.nameSpell;
    }

    public String getGender() {
        return this.gender;
    }

    public String getHeadPortrait() {
        return this.headPortrait;
    }

    public String getChangeOperator() {
        return this.changeOperator;
    }

    public Date getChangeTime() {
        return this.changeTime;
    }

    public String getParkBlackWhiteId() {
        return this.parkBlackWhiteId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public Map getAttrValueMap() {
        return this.attrValueMap;
    }

    public String getIdIn() {
        return this.idIn;
    }

    public String getNotInId() {
        return this.notInId;
    }
}

