/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.patrol.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.patrol.remote.PatrolShiftRemote;
import com.zkteco.zkbiosecurity.patrol.service.PatrolShiftService;
import com.zkteco.zkbiosecurity.patrol.vo.PatrolShiftItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PatrolShiftController
extends BaseController
implements PatrolShiftRemote {
    @Autowired
    private PatrolShiftService patrolShiftService;

    @RequiresPermissions(value={"patrol:shift:view"})
    public ModelAndView index() {
        return new ModelAndView("patrol/shift/patrolShift");
    }

    @RequiresPermissions(value={"patrol:shift:edit"})
    public ZKResultMsg save(PatrolShiftItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.patrolShiftService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(PatrolShiftItem condition) {
        Pager pager = this.patrolShiftService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg delete(String ids) {
        this.patrolShiftService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

