/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.patrol.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import com.zkteco.zkbiosecurity.patrol.remote.PatrolDeviceRemote;
import com.zkteco.zkbiosecurity.patrol.service.PatrolDeviceService;
import com.zkteco.zkbiosecurity.patrol.vo.PatrolDeviceItem;
import com.zkteco.zkbiosecurity.patrol.vo.PatrolDeviceSelectItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PatrolDeviceController
extends BaseController
implements PatrolDeviceRemote {
    @Autowired
    private PatrolDeviceService patrolDeviceService;

    @RequiresPermissions(value={"patrol:device"})
    public ModelAndView index() {
        return new ModelAndView("patrol/device/patrolDevice");
    }

    @RequiresPermissions(value={"patrol:device:add"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.patrolDeviceService.getItemById(id));
        }
        return new ModelAndView("patrol/device/selectPatrolDeviceContent");
    }

    @RequiresPermissions(value={"patrol:device:add"})
    @LogRequest(module="patrol_module", object="patrol_device", opType="common_op_new", requestParams={"ids"}, opContent="common_op_new")
    public ZKResultMsg save(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            for (String devId : StrUtil.strToList((String)ids)) {
                this.patrolDeviceService.saveItem(devId);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"patrol:device:refresh"})
    public DxGrid list(PatrolDeviceItem condition) {
        Pager pager = this.patrolDeviceService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"patrol:device:del"})
    @LogRequest(module="patrol_module", object="common_leftMenu_device", opType="common_op_del", requestParams={"deviceAlias"}, opContent="common_op_del")
    public ZKResultMsg del(String ids) {
        this.patrolDeviceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getDevsByModuleAndArea(String devModule, String areaId) {
        if (StringUtils.isNotBlank((CharSequence)devModule) && StringUtils.isNotBlank((CharSequence)areaId)) {
            ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
            List patrolDeviceItems = this.patrolDeviceService.getByCondition(new PatrolDeviceItem(devModule, areaId));
            for (PatrolDeviceItem patrolDeviceItem : patrolDeviceItems) {
                SelectItem selectItem = new SelectItem();
                selectItem.setValue(patrolDeviceItem.getId());
                selectItem.setText((Object)patrolDeviceItem.getDeviceAlias());
                selectItems.add(selectItem);
            }
            return new ZKResultMsg(selectItems);
        }
        return new ZKResultMsg();
    }

    public DxGrid deviceSelectList(PatrolDeviceSelectItem condition) {
        Pager pager = new Pager();
        ArrayList<String> selectDevIds = new ArrayList<String>(Arrays.asList(condition.getSelectId().split(",")));
        if (condition.getType().equals("noSelected")) {
            pager = this.patrolDeviceService.getDeviceSelectItemsByPage(this.request.getSession().getId(), condition, selectDevIds, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public TreeItem getDeviceVerifyModeTree() {
        List treeItems = this.patrolDeviceService.getDeviceVerifyModeTree();
        return new TreeItem("0", treeItems);
    }
}

