/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.websocketService.receiveFromCS;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.utils.Base64Util;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.park.bean.ParkCheckOutInfo;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.park.service.ParkCacheService;
import com.zkteco.zkbiosecurity.park.service.ParkDeviceService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordoutService;
import com.zkteco.zkbiosecurity.park.utils.ParkWebCommonUtil;
import com.zkteco.zkbiosecurity.park.vo.ParkDeviceItem;
import com.zkteco.zkbiosecurity.park.websocketService.ChannelService;
import com.zkteco.zkbiosecurity.park.websocketService.DataCallFuntion;
import com.zkteco.zkbiosecurity.park.websocketService.IDataHandle;
import com.zkteco.zkbiosecurity.park.websocketService.sendToCS.ParkCSPavilioMsg;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Component;

@Component
public class ParkCSRealTimeInfo
implements IDataHandle {
    private Logger logger = LoggerFactory.getLogger(ParkCSRealTimeInfo.class);
    private static final int VZ_LPRC_ONLINE = 3;
    private static final int VZ_LPRC_OFFLINE = 4;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkRecordinService parkRecordinService;
    @Autowired
    private ParkRecordoutService parkRecordoutService;
    @Autowired
    private ParkCacheService parkCacheService;
    @Autowired
    private ParkCSPavilioMsg parkCSPavilioMsg;
    @Autowired
    private ChannelService channelService;
    @Autowired
    private SimpMessagingTemplate messagingTemplate;

    @DataCallFuntion(value="commonNotify")
    public void commonNotify(JSONObject msg) {
        JSONObject data = msg.getJSONObject("data");
        String eNotify = data.getString("eNotify");
        if (Integer.valueOf(eNotify) == 3) {
            this.onGateRunStatusFun(data);
        } else if (Integer.valueOf(eNotify) == 4) {
            this.onCommonNotifyFun(data);
        }
    }

    private void onCommonNotifyFun(JSONObject msgObj) {
        JSONObject devObj;
        String devIp = msgObj.getString("deviceIp");
        Long handle = Long.valueOf(msgObj.getString("handle"));
        if (ParkWebCommonUtil.isNotNull(devIp) && (devObj = this.parkCacheService.getJson("park:dev_info_" + devIp)).getString("enabled").equals("enable")) {
            this.logger.info("=====Park=====onCommonNotifyFun=====Device offline Callback=====" + devObj.getString("ipAddr") + "=====" + msgObj.toString());
            String keyStr = "park:view_defa_content_" + handle;
            if (this.parkCacheService.exists(keyStr)) {
                this.parkCacheService.del(keyStr);
            }
            if (this.parkCacheService.exists(keyStr = "park:dev_handle_" + handle)) {
                this.parkCacheService.del(keyStr);
            }
            devObj.put("handle", (Object)0);
            devObj.put("serialHand", (Object)0);
            devObj.put("state", (Object)"offLine");
            devObj.put("pavilioMode", (Object)"cs");
            this.parkCacheService.setJson("park:dev_info_" + devIp, devObj, 0L);
        }
    }

    private void onGateRunStatusFun(JSONObject msgObj) {
        String devIp = msgObj.getString("deviceIp");
        String handle = msgObj.getString("handle");
        JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
        if (ParkWebCommonUtil.isNotNull(devObj) && Long.valueOf(handle) != 0L) {
            devObj.put("handle", (Object)handle);
            devObj.put("state", (Object)"onLine");
            this.parkCacheService.setJson("park:dev_info_" + devObj.getString("ipAddr"), devObj, 0L);
            this.parkCacheService.set("park:dev_handle_" + handle, (Object)devObj.getString("ipAddr"), 0L);
            this.parkCacheService.set("park:view_defa_content_" + handle, (Object)"0", 0L);
        }
    }

    @DataCallFuntion(value="searchDevice")
    public void searchDev(JSONObject msg) {
        JSONArray dataAry = msg.getJSONArray("data");
        if (ParkWebCommonUtil.isNotNull(dataAry)) {
            for (int i = 0; i < dataAry.size(); ++i) {
                JSONObject data = dataAry.getJSONObject(i);
                String ipAddr = data.getString("ip");
                ParkDeviceItem item = this.parkDeviceService.getByIpAddress(ipAddr);
                if (!ParkWebCommonUtil.isNull(item)) continue;
                String code = "zs-LPR";
                ParkCheckOutInfo cheOutInfo = new ParkCheckOutInfo();
                cheOutInfo.setMsgType("search");
                cheOutInfo.setDevName(data.getString("deviceName"));
                cheOutInfo.setVendorsType(code);
                if (data.containsKey((Object)"lprDevType") && StringUtils.isNotBlank((CharSequence)data.getString("lprDevType"))) {
                    cheOutInfo.setLprDeviceType(Short.valueOf(data.getString("lprDevType")));
                } else {
                    cheOutInfo.setLprDeviceType(Short.valueOf("0"));
                }
                cheOutInfo.setMsgInfo(code);
                cheOutInfo.setIpAddress(ipAddr);
                cheOutInfo.setPort(Long.valueOf(data.getString("portListen")).longValue());
                cheOutInfo.setSn("");
                String comm = this.parkCSPavilioMsg.sendMsgToPavilio("search", cheOutInfo);
                this.channelService.groupPush(comm);
                this.messagingTemplate.convertAndSend((Object)"/topic/parkDevice/message", (Object)comm);
            }
        }
    }

    @DataCallFuntion(value="checkinOut")
    public void checkin(JSONObject msg) {
        JSONObject data = msg.getJSONObject("data");
        String msgId = msg.getString("msgId");
        String pavilioIp = msg.getString("channelId");
        String channelId = data.getString("channelId");
        String status = data.getString("channelStatus");
        String devIp = data.getString("deviceIp");
        String carNumber = data.getString("carNumber");
        String picBase64 = data.getString("picBase64");
        String isManual = data.getString("isManual");
        String manualId = data.getString("manualId");
        String dataPath = ParkWebCommonUtil.getDatePhotoPath();
        String basePath = ParkWebCommonUtil.getSystemFilePath() + dataPath;
        ParkWebCommonUtil.createDir(basePath);
        String pohotName = this.getPhotoPathForCS(devIp, carNumber);
        basePath = basePath + pohotName;
        boolean opRet = Base64Util.generateImage((String)picBase64, (String)basePath);
        if (!opRet) {
            this.logger.info("ParkCSRealTimeInfo checkin Save Photo Fail! " + new Date());
            return;
        }
        if ("true".equals(isManual)) {
            ParkCheckOutInfo parkCheckOutInfo = new ParkCheckOutInfo();
            parkCheckOutInfo.setLicense(carNumber);
            parkCheckOutInfo.setParkChannelId(channelId);
            parkCheckOutInfo.setPhotoPath(dataPath + pohotName);
            parkCheckOutInfo.setPavilioIP(pavilioIp);
            parkCheckOutInfo.setManual(true);
            parkCheckOutInfo.setReleaseReasonId(manualId);
            parkCheckOutInfo.setUuid(msgId);
            Short state = Short.valueOf(status);
            if (ParkConstants.CHANNEL_STATE_CAR_IN.equals(state) || ParkConstants.CHANNEL_STATE_CART_IN.equals(state)) {
                this.parkRecordinService.manualReleaseIn(parkCheckOutInfo, ParkConstants.PAVILIO_CS);
            } else {
                this.parkRecordoutService.manualReleaseOut(parkCheckOutInfo, ParkConstants.PAVILIO_CS);
            }
        } else {
            this.parkDeviceService.routeBusiness(carNumber, devIp, dataPath + pohotName, msgId);
        }
    }

    private String getPhotoPathForCS(String ipAddress, String carNumber) {
        StringBuffer photoName = new StringBuffer(ipAddress).append("_");
        photoName.append(DateUtil.dateToString((Date)new Date(), (String)"HH:mm:ss.SSS").replaceAll(":", ""));
        if (ParkWebCommonUtil.isNotNull(carNumber)) {
            photoName.append("_").append(carNumber);
        }
        photoName.append(".jpg");
        return photoName.toString();
    }

    @DataCallFuntion(value="deviceFunList")
    public void getDevFunList(JSONObject msg) {
        JSONObject data = msg.getJSONObject("data");
        String deviceIp = data.getString("deviceIp");
        String fun = data.getString("fun");
        if (StringUtils.isNotBlank((CharSequence)fun)) {
            String msgId = msg.getString("msgId");
            if (StringUtils.isBlank((CharSequence)msgId)) {
                this.parkDeviceService.saveDevFunWithCS(deviceIp, fun);
                this.parkDeviceService.startSaveOfflineRecordThread(deviceIp);
            } else {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("Ret", (Object)msg.getIntValue("ret"));
                jsonObject.put("OpType", (Object)msg.getString("funcId"));
                jsonObject.put("Data", (Object)fun);
                this.parkCacheService.setJson("park:ws_msgid_" + msgId, jsonObject, 0L);
            }
        }
    }
}

