/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.websocketService;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RequestParser {
    private HttpRequest fullReq;

    public RequestParser(HttpRequest req) {
        this.fullReq = req;
    }

    public Map<String, String> parse() throws Exception {
        HttpMethod method = this.fullReq.method();
        HashMap<String, String> parmMap = new HashMap<String, String>();
        if (HttpMethod.GET == method) {
            QueryStringDecoder decoder = new QueryStringDecoder(this.fullReq.uri());
            decoder.parameters().entrySet().forEach(entry -> parmMap.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0)));
        } else if (HttpMethod.POST == method) {
            HttpPostRequestDecoder decoder = new HttpPostRequestDecoder(this.fullReq);
            decoder.offer((HttpContent)((FullHttpRequest)this.fullReq));
            List parmList = decoder.getBodyHttpDatas();
            for (InterfaceHttpData parm : parmList) {
                Attribute data = (Attribute)parm;
                parmMap.put(data.getName(), data.getValue());
            }
        } else {
            throw new Exception("no support");
        }
        return parmMap;
    }
}

