/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.guard.chausie;

import com.zkteco.zkbiosecurity.guard.chausie.exceptions.ExpiredException;
import com.zkteco.zkbiosecurity.guard.chausie.exceptions.InvalidException;
import com.zkteco.zkbiosecurity.guard.chausie.exceptions.NoTimeStampException;
import com.zkteco.zkbiosecurity.guard.chausie.exceptions.NotSignedException;
import com.zkteco.zkbiosecurity.guard.chausie.exceptions.NotTrustedException;
import com.zkteco.zkbiosecurity.guard.chausie.exceptions.UnsignedEntriesException;
import com.zkteco.zkbiosecurity.guard.chausie.exceptions.ValidatorException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.CodeSigner;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.Timestamp;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JarSignatureValidator {
    private final List<String> crlFileNames = new ArrayList<String>();
    private final Set<String> displayedWarings = new HashSet<String>();
    private final Logger log = Logger.getLogger(JarSignatureValidator.class.getName());
    private String ocspResponderURL;
    private PKIXParameters params;
    private boolean quiet = false;
    private boolean skipCertUsage = false;
    private boolean skipTrustCheck = false;
    private String trustedKeystore;
    private boolean useOCSP;
    private CertPathValidator validator;
    private Date verificationDate;

    public List<String> getCrlFileNames() {
        return this.crlFileNames;
    }

    public String getOcspResponderURL() {
        return this.ocspResponderURL;
    }

    public String getTrustedKeystore() {
        return this.trustedKeystore;
    }

    public Date getVerificationDate() {
        return this.verificationDate;
    }

    private void initPathValdiator() throws NoSuchAlgorithmException, KeyStoreException, CertificateException, FileNotFoundException, IOException, InvalidAlgorithmParameterException, CRLException, ValidatorException {
        if (this.skipTrustCheck) {
            this.log.fine("Certificate path validation skiped.");
            this.validator = null;
            return;
        }
        Security.setProperty("ocsp.enable", this.useOCSP ? "true" : "false");
        if (this.ocspResponderURL != null) {
            Security.setProperty("ocsp.responderURL", this.ocspResponderURL);
        }
        CertPathValidator validator = CertPathValidator.getInstance("PKIX");
        KeyStore keystore = this.loadKeystore();
        try {
            this.params = new PKIXParameters(keystore);
        }
        catch (InvalidAlgorithmParameterException e) {
            System.err.println("No trust anchors defined");
            System.err.println("Signer certificate not trusted");
            throw new NotTrustedException();
        }
        if (this.verificationDate != null) {
            this.log.fine("Using verification date: " + this.verificationDate);
            this.params.setDate(this.verificationDate);
        }
        ArrayList<? extends CRL> l = new ArrayList<CRL>();
        this.params.setRevocationEnabled(this.useOCSP || this.crlFileNames != null && !this.crlFileNames.isEmpty());
        if (this.crlFileNames != null) {
            for (String crlFile : this.crlFileNames) {
                l.addAll(CertificateFactory.getInstance("X.509").generateCRLs(new FileInputStream(crlFile)));
            }
        }
        CollectionCertStoreParameters csParams = new CollectionCertStoreParameters(l);
        CertStore certStore = CertStore.getInstance("Collection", csParams);
        this.params.addCertStore(certStore);
        this.validator = validator;
    }

    private boolean isCertForCodeSigning(X509Certificate cert) throws CertificateParsingException {
        List<String> extUsage = cert.getExtendedKeyUsage();
        return extUsage != null && (extUsage.contains("2.5.29.37.0") || extUsage.contains("1.3.6.1.5.5.7.3.3"));
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    private boolean isSignatureRelatedFilename(String filename) {
        String tmp = filename.toUpperCase();
        if (tmp.equals("META-INF/MANIFEST.MF") || tmp.equals("META-INF/") || tmp.startsWith("META-INF/SIG-") && tmp.indexOf("/") == tmp.lastIndexOf("/")) {
            return true;
        }
        if (tmp.startsWith("META-INF/") && (tmp.endsWith(".SF") || tmp.endsWith(".DSA") || tmp.endsWith(".RSA"))) {
            return tmp.indexOf("/") == tmp.lastIndexOf("/");
        }
        return false;
    }

    public boolean isSkipCertUsage() {
        return this.skipCertUsage;
    }

    public boolean isSkipTrustCheck() {
        return this.skipTrustCheck;
    }

    public boolean isUseOCSP() {
        return this.useOCSP;
    }

    private KeyStore loadKeystore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException {
        File truststore = new File(System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar));
        File userStore = new File("~/.keystore");
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        if (this.trustedKeystore != null) {
            File f = new File(this.trustedKeystore);
            if (!f.exists()) {
                this.showErr("Keystore '" + f + "' does not exists!");
                System.exit(4);
            }
            this.log.fine("Using keystore: " + f);
            keystore.load(new FileInputStream(f), null);
        } else if (userStore.exists()) {
            this.log.fine("Using keystore: " + userStore);
            keystore.load(new FileInputStream(userStore), null);
        } else if (truststore.exists()) {
            this.log.fine("Using keystore: " + truststore);
            keystore.load(new FileInputStream(truststore), null);
        } else {
            KeyStore.LoadStoreParameter p = null;
            keystore.load(p);
        }
        return keystore;
    }

    public void setOcspResponderURL(String ocspResponderURL) {
        this.ocspResponderURL = ocspResponderURL;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void setSkipCertUsage(boolean skipCertUsage) {
        this.skipCertUsage = skipCertUsage;
    }

    public void setSkipTrustCheck(boolean b) {
        this.skipTrustCheck = b;
    }

    public void setTrustedKeystore(String trustedKeystore) {
        this.trustedKeystore = trustedKeystore;
    }

    public void setUseOCSP(boolean useOCSP) {
        this.useOCSP = useOCSP;
    }

    public void setVerificationDate(Date verificationDate) {
        this.verificationDate = verificationDate;
    }

    private void showErr(String t) {
        if (!this.displayedWarings.contains(t)) {
            this.displayedWarings.add(t);
            System.err.println(t);
        }
    }

    private void validatePath(CertPath path) throws Exception {
        if (this.validator == null) {
            this.log.finest("  path validation skiped (it needs trusted keystore)");
            return;
        }
        PKIXCertPathValidatorResult result = (PKIXCertPathValidatorResult)this.validator.validate(path, this.params);
        if (result == null) {
            throw new RuntimeException("No result???");
        }
        try {
            if (this.params.getDate() == null) {
                result.getTrustAnchor().getTrustedCert().checkValidity();
            } else {
                result.getTrustAnchor().getTrustedCert().checkValidity(this.params.getDate());
            }
        }
        catch (Exception e) {
            if (e instanceof CertificateExpiredException || e.getCause() instanceof CertificateExpiredException) {
                this.showErr("Trust anchor expired");
            }
            throw new ExpiredException();
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("  path valid");
        }
    }

    public void verifyJar(JarFile jarFile) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, CertPathValidatorException, CRLException, ValidatorException {
        this.displayedWarings.clear();
        byte[] buffer = new byte[8192];
        boolean anySigned = false;
        boolean hasUnsignedEntry = false;
        this.initPathValdiator();
        Manifest manifest = jarFile.getManifest();
        Enumeration<JarEntry> entriesEnum = jarFile.entries();
        while (entriesEnum.hasMoreElements()) {
            JarEntry entry = entriesEnum.nextElement();
            InputStream is = null;
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Checking file " + entry);
            }
            try {
                is = jarFile.getInputStream(entry);
                while (is.read(buffer, 0, buffer.length) != -1) {
                }
            }
            catch (SecurityException e) {
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.log(Level.FINEST, "  Invalid signature!!!", e);
                }
                throw new InvalidException();
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
            String name = entry.getName();
            CodeSigner[] codeSigners = entry.getCodeSigners();
            boolean isSigned = codeSigners != null;
            boolean inManifest = manifest.getAttributes(name) != null || manifest.getAttributes("./" + name) != null || manifest.getAttributes("/" + name) != null;
            anySigned |= isSigned;
            hasUnsignedEntry |= !entry.isDirectory() && !isSigned && !this.isSignatureRelatedFilename(name);
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("  " + (isSigned ? "signed" : "      ") + "  " + (inManifest ? "manifest" : "        ") + "  ");
            }
            if (!isSigned) continue;
            for (int i = 0; i < codeSigners.length; ++i) {
                Certificate cert = codeSigners[i].getSignerCertPath().getCertificates().get(0);
                Timestamp timestamp = codeSigners[i].getTimestamp();
                if (timestamp != null) {
                    this.log.finer("  Found timestamp.");
                    CertPath cp = timestamp.getSignerCertPath();
                    try {
                        this.log.finer("  Validating timestamp certificate path");
                        this.validatePath(cp);
                        this.params.setDate(timestamp.getTimestamp());
                    }
                    catch (Exception e) {
                        if (e instanceof CertificateExpiredException || e.getCause() instanceof CertificateExpiredException) {
                            this.showErr("Time stamping authority certificate expired");
                        } else if ("Path does not chain with any of the trust anchors".equals(e.getMessage())) {
                            this.showErr("Time stamping authority certificate not trusted");
                        } else {
                            this.showErr("Timestamp: " + e.getMessage());
                        }
                        this.log.log(Level.FINE, "Timestamp certificate is not valid", e);
                    }
                } else {
                    throw new NoTimeStampException();
                }
                ArrayList<Certificate> x = new ArrayList<Certificate>();
                for (Certificate certificate : codeSigners[i].getSignerCertPath().getCertificates()) {
                    x.add(certificate);
                }
                CertPath path = CertificateFactory.getInstance("X.509").generateCertPath(x);
                if (cert instanceof X509Certificate) {
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("  Used certificate  SerialNumber: " + ((X509Certificate)cert).getSerialNumber() + "; Subject: " + ((X509Certificate)cert).getSubjectDN());
                    }
                    BigInteger bigInteger = ((X509Certificate)cert).getSerialNumber();
                    String dn = ((X509Certificate)cert).getSubjectDN().getName();
                    if (!dn.contains("CN=\"Xiamen ZKTeco Information Technology Co.,ltd\"") && !dn.contains("CN=\"ZKTECO CO.,LTD.\"")) {
                        throw new InvalidException();
                    }
                }
                try {
                    this.log.finest("Validating signer certificate path");
                    this.validatePath(path);
                    continue;
                }
                catch (ValidatorException validatorException) {
                    throw validatorException;
                }
                catch (Exception exception) {
                    if ("Path does not chain with any of the trust anchors".equals(exception.getMessage())) {
                        this.showErr("Signer certificate not trusted");
                    }
                    if (exception instanceof CertificateExpiredException) {
                        throw new ExpiredException();
                    }
                    if (exception.getCause() instanceof CertificateExpiredException) {
                        throw new ExpiredException();
                    }
                    this.log.log(Level.FINE, "Certificate path can't be verified!", exception);
                    throw new NotTrustedException();
                }
            }
        }
        if (!anySigned) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("File is not signed");
            }
            throw new NotSignedException();
        }
        if (hasUnsignedEntry) {
            this.showErr("Contains unsigned entries");
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("File contains unsigned entries!");
            }
            throw new UnsignedEntriesException();
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("File verified");
        }
    }
}

