/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.psg.service.PsgDeviceEventService;
import com.zkteco.zkbiosecurity.psg.service.PsgRTMonitorService;
import com.zkteco.zkbiosecurity.psg.utils.PsgEnumUtil;
import com.zkteco.zkbiosecurity.psg.vo.PsgDeviceEventItem;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.stereotype.Controller;

@Controller
public class PsgRTMonitorWSController {
    @Autowired
    private PsgRTMonitorService psgRTMonitorService;
    @Autowired
    private PsgDeviceEventService psgDeviceEventService;

    @MessageMapping(value={"/psgRTMonitor/getEventData"})
    @SendTo(value={"/topic/psgRTMonitor/getEventData"})
    public Object getEventData(String _params) {
        return null;
    }

    @MessageMapping(value={"/psgRTMonitor/getDevState"})
    @SendTo(value={"/topic/psgRTMonitor/getDevState"})
    public Object getDevState(String params) {
        int i;
        JSONObject paramJson = JSONObject.parseObject((String)params);
        String areaIds = paramJson.containsKey((Object)"areaIds") ? paramJson.getString("areaIds") : "";
        JSONObject data = new JSONObject();
        JSONArray stateArray = null;
        JSONArray gateStates = new JSONArray();
        JSONArray auxInStates = new JSONArray();
        JSONObject dev = null;
        JSONObject devState = (JSONObject)this.psgRTMonitorService.getDevStateData(areaIds).getData();
        stateArray = devState.getJSONArray("gateState");
        if (Objects.nonNull(stateArray) && stateArray.size() > 0) {
            for (i = 0; i < stateArray.size(); ++i) {
                JSONObject gate = stateArray.getJSONObject(i);
                dev = this.putGateDataToMonitor(gate);
                gateStates.add((Object)dev);
            }
            data.put("gateStates", (Object)gateStates);
        }
        if (Objects.nonNull(stateArray = devState.getJSONArray("auxInState")) && stateArray.size() > 0) {
            for (i = 0; i < stateArray.size(); ++i) {
                JSONObject auxIn = stateArray.getJSONObject(i);
                int connect = auxIn.getIntValue("connect");
                auxIn.put("image", (Object)PsgEnumUtil.AuxInImage.getValue(connect));
                auxInStates.add((Object)auxIn);
            }
            data.put("auxInStates", (Object)auxInStates);
        }
        return data;
    }

    private JSONObject putGateDataToMonitor(JSONObject gate) {
        JSONObject data = new JSONObject();
        int relay = gate.getIntValue("relay");
        int alarm = gate.getIntValue("alarm");
        int connect = gate.getIntValue("connect");
        int gateState = gate.getIntValue("gateState");
        String alarmValue = PsgEnumUtil.Alarm.getValue(gateState, alarm);
        data.put("id", (Object)gate.getString("id"));
        data.put("areaId", (Object)gate.getString("areaId"));
        data.put("devAlias", (Object)gate.getString("devAlias"));
        data.put("devSn", (Object)gate.getString("devSn"));
        data.put("no", (Object)gate.getString("no"));
        data.put("name", (Object)gate.getString("name"));
        data.put("connect", (Object)connect);
        data.put("alarm", (Object)(StringUtils.isNotBlank((CharSequence)alarmValue) ? alarmValue : "none"));
        data.put("image", (Object)PsgEnumUtil.GateImage.getValue(gateState, connect, alarm, relay));
        data.put("opDisplay", (Object)(gateState == 1 || gateState == 3 ? "inline" : "none"));
        if (alarm > 0 && !gate.getBoolean("isDisableAudio").booleanValue()) {
            data.put("audio", (Object)"/public/media/sound/alarm.wav");
        }
        return data;
    }

    private String getAlarmAudioPath(String alarmName, String gateId) {
        String alarmAudioPath = "";
        if (!I18nUtil.i18nCode((String)"common_none", (Object[])new Object[0]).equals(alarmName)) {
            if (I18nUtil.i18nCode((String)"psg_rtMonitor_duressOpen", (Object[])new Object[0]).equals(alarmName) || I18nUtil.i18nCode((String)"psg_rtMonitor_duressFingerOpen", (Object[])new Object[0]).equals(alarmName) || I18nUtil.i18nCode((String)"psg_rtMonitor_duressPwdOpen", (Object[])new Object[0]).equals(alarmName)) {
                alarmName = I18nUtil.i18nCode((String)"psg_newEventNo_101", (Object[])new Object[0]);
            } else if (I18nUtil.i18nCode((String)"psg_rtMonitor_tamper", (Object[])new Object[0]).equals(alarmName)) {
                alarmName = I18nUtil.i18nCode((String)"psg_eventNo_100", (Object[])new Object[0]);
            } else if (I18nUtil.i18nCode((String)"psg_rtMonitor_alarm", (Object[])new Object[0]).equals(alarmName)) {
                return "/public/media/sound/alarm.wav";
            }
            List psgDeviceEvents = this.psgDeviceEventService.getItemsByNameAndGateId(alarmName, gateId);
            if (Objects.nonNull(psgDeviceEvents) && Objects.nonNull(psgDeviceEvents.get(0)) && StringUtils.isNotBlank((CharSequence)((PsgDeviceEventItem)psgDeviceEvents.get(0)).getBaseMediaFilePath())) {
                alarmAudioPath = ((PsgDeviceEventItem)psgDeviceEvents.get(0)).getBaseMediaFilePath();
            }
        }
        return alarmAudioPath;
    }
}

