/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.psg.remote.PsgLevelRemote;
import com.zkteco.zkbiosecurity.psg.service.PsgGateService;
import com.zkteco.zkbiosecurity.psg.service.PsgLevelService;
import com.zkteco.zkbiosecurity.psg.service.PsgPersonService;
import com.zkteco.zkbiosecurity.psg.vo.PsgLevelGateItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgLevelItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgLevelSelectGateItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PsgLevelController
extends ExportController
implements PsgLevelRemote {
    @Autowired
    private PsgLevelService psgLevelService;
    @Autowired
    private PsgGateService psgGateService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private PsgPersonService psgPersonService;

    @RequiresPermissions(value={"psg:level"})
    public ModelAndView index() {
        return new ModelAndView("psg/level/psgLevel");
    }

    @RequiresPermissions(value={"psg:level:add", "psg:level:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("personCount", (Object)this.psgLevelService.getLevelPersonCount(id));
            this.request.setAttribute("gateCount", (Object)this.psgLevelService.getLevelGateCount(id));
            this.request.setAttribute("item", (Object)this.psgLevelService.getItemById(id));
        }
        return new ModelAndView("psg/level/editPsgLevel");
    }

    @RequiresPermissions(value={"psg:level:add", "psg:level:edit"})
    @LogRequest(module="psg_module", object="psg_leftMenu_level", opType="common_op_edit", requestParams={"name"}, opContent="common_level_name")
    public ZKResultMsg save(PsgLevelItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_progress_searchDev", (Object[])new Object[0]) + "<br/>");
        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_progress_searchDevFinish", (Object[])new Object[0]) + "<br/>", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]), I18nUtil.i18nCode((String)"common_op_totalProgress", (Object[])new Object[0]));
        item = this.psgLevelService.saveItem(item);
        this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]), I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]), I18nUtil.i18nCode((String)"common_op_totalProgress", (Object[])new Object[0]));
        res.setData((Object)item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"psg:level:refresh"})
    public DxGrid list(PsgLevelItem codition) {
        Pager pager = this.psgLevelService.loadPagerByAuthFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"psg:level:del"})
    @LogRequest(module="psg_module", object="psg_leftMenu_level", opType="common_op_del", requestParams={"names"}, opContent="common_level_name")
    public ZKResultMsg delete(String ids) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            ArrayList<String> levelIdList = new ArrayList<String>(Arrays.asList(ids.split(",")));
            PsgLevelItem psgLevelItem = new PsgLevelItem();
            psgLevelItem.setInitFlag(Boolean.valueOf(true));
            if (levelIdList.contains(((PsgLevelItem)this.psgLevelService.getByCondition(psgLevelItem).get(0)).getId())) {
                resultMsg.setRet("500");
                resultMsg.setMsg("common_prompt_initDataCanNotDel");
            } else {
                this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
                ArrayList tempPersonIdList = new ArrayList();
                int levelSize = levelIdList.size();
                for (int i = 0; i < levelSize; ++i) {
                    int total = (int)((double)i * 100.0 / (double)levelSize);
                    total = total == 100 ? 99 : total;
                    List personIdList = this.psgLevelService.getPersonIdsByLevelId((String)levelIdList.get(i));
                    if (personIdList != null && personIdList.size() > 0) {
                        int personSize = personIdList.size();
                        for (int j = 0; j < personSize; ++j) {
                            tempPersonIdList.add(personIdList.get(j));
                            if (tempPersonIdList.size() % 500 != 0) continue;
                            this.psgLevelService.immeDelLevel((String)levelIdList.get(i), personIdList);
                            this.progressCache.setProcess(new ProcessBean((int)((double)j * 100.0 / (double)personSize), total, "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0])));
                            tempPersonIdList = new ArrayList();
                        }
                        if (tempPersonIdList.size() <= 0) continue;
                        this.psgLevelService.immeDelLevel((String)levelIdList.get(i), personIdList);
                        tempPersonIdList = new ArrayList();
                        this.progressCache.setProcess(new ProcessBean(100, total, "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0])));
                        continue;
                    }
                    this.psgLevelService.delPsgLevelGateByLevelId((String)levelIdList.get(i));
                }
                this.psgLevelService.deleteByIds(ids);
                this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg getLevelList() {
        return new ZKResultMsg((Object)this.psgLevelService.getLevelList(this.request.getSession().getId()));
    }

    @RequiresPermissions(value={"psg:gate:refresh"})
    public DxGrid selectGatelist(PsgLevelSelectGateItem codition) {
        String levelId = codition.getLevelId();
        if (StringUtils.isBlank((CharSequence)codition.getSelectId())) {
            codition.setSelectId("-1");
        }
        if (codition.getType().equals("noSelected")) {
            codition.setSelectGateIdsNotIn(codition.getSelectId());
        } else if (codition.getType().equals("selected")) {
            codition.setSelectGateIdsIn(codition.getSelectId());
        }
        codition.setFilterId(levelId);
        codition.setEnabled(Boolean.valueOf(true));
        Pager pager = this.psgGateService.getPagerFilterAuth(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"psg:level:addGate"})
    @LogRequest(module="psg_module", object="psg_leftMenu_level", opType="psg_gate_addGate", requestParams={"levelName", "gateNames"}, opContent="common_level_name")
    public ZKResultMsg addGate(String levelId, String gateIds) {
        if (StringUtils.isNotBlank((CharSequence)levelId) && StringUtils.isNotBlank((CharSequence)gateIds)) {
            ArrayList<String> gateIdList = new ArrayList<String>(Arrays.asList(gateIds.split(",")));
            String clientId = this.request.getParameter("clientId");
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
            this.psgLevelService.addLevelByParamIds(StringUtils.join(gateIdList, (String)","), levelId, "gate");
            List personIdList = this.psgLevelService.getPersonIdsByLevelId(levelId);
            if (personIdList != null && personIdList.size() > 0) {
                List personArrayIds = this.psgPersonService.splitPersonIds(StringUtils.join((Iterable)personIdList, (String)","), 500);
                int[] currentCount = new int[]{0};
                int[] totalCount = new int[]{personArrayIds.size()};
                personArrayIds.parallelStream().forEach(personArrayId -> {
                    this.psgLevelService.setPersonLevelToDev(levelId, personArrayId);
                    currentCount[0] = currentCount[0] + 1;
                    this.progressCache.setProcess(new ProcessBean(0, (int)((double)currentCount[0] * 100.0 / (double)totalCount[0])), clientId);
                });
            }
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"psg:level:delGate"})
    @LogRequest(module="psg_module", object="psg_leftMenu_level", opType="psg_level_gateDelete", requestParams={"levelName", "gateNames"}, opContent="common_level_name")
    public ZKResultMsg deleteGate(String levelId, String gateIds) {
        if (StringUtils.isNotBlank((CharSequence)levelId) && StringUtils.isNotBlank((CharSequence)gateIds)) {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
            ArrayList<String> gateIdList = new ArrayList<String>(Arrays.asList(gateIds.split(",")));
            List deviceIdList = this.psgGateService.getDevIdsByGateIds(gateIdList);
            Long personCount = this.psgLevelService.getLevelPersonCount(levelId);
            if (personCount > 0L) {
                List personIdList = this.psgLevelService.getPersonIdsByLevelId(levelId);
                if (personIdList.size() > 0) {
                    ArrayList tempPersonIdList = new ArrayList();
                    int devSize = deviceIdList.size();
                    for (int i = 0; i < devSize; ++i) {
                        int total = (int)((double)i * 100.0 / (double)devSize);
                        total = total == 100 ? 99 : total;
                        int personSize = personIdList.size();
                        for (int j = 0; j < personSize; ++j) {
                            tempPersonIdList.add(personIdList.get(j));
                            if (tempPersonIdList.size() % 500 != 0) continue;
                            this.psgLevelService.handleLevelDelGate(levelId, tempPersonIdList, (String)deviceIdList.get(i), gateIdList);
                            this.progressCache.setProcess(new ProcessBean((int)((double)j * 100.0 / (double)personSize), total, "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0])));
                            tempPersonIdList = new ArrayList();
                        }
                        if (tempPersonIdList.size() <= 0) continue;
                        this.psgLevelService.handleLevelDelGate(levelId, tempPersonIdList, (String)deviceIdList.get(i), gateIdList);
                        this.progressCache.setProcess(new ProcessBean(100, total, "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0])));
                        tempPersonIdList = new ArrayList();
                    }
                }
            } else {
                this.psgLevelService.delLevelGateByParams(levelId, gateIdList);
            }
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"psg:level:refresh"})
    public DxGrid gateList(PsgLevelGateItem condition) {
        Pager pager = this.psgGateService.psgLevelGateList(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public String validName(String name) {
        PsgLevelItem item = this.psgLevelService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    @RequiresPermissions(value={"psg:level:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        PsgLevelGateItem psgLevelGateItem = new PsgLevelGateItem();
        this.setConditionValue((BaseItem)psgLevelGateItem);
        List psgLevelGateItemList = this.psgGateService.getExportItemList(psgLevelGateItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(psgLevelGateItemList, PsgLevelGateItem.class);
    }

    public ZKResultMsg getPersonCount(String levelId) {
        Long personCount = this.psgLevelService.getLevelPersonCount(levelId);
        return new ZKResultMsg((Object)personCount);
    }
}

