/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.constants.BaseConstants;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtils;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.IpUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.psg.constants.PsgConstants;
import com.zkteco.zkbiosecurity.psg.remote.PsgDeviceRemote;
import com.zkteco.zkbiosecurity.psg.service.PsgBaseDictionaryService;
import com.zkteco.zkbiosecurity.psg.service.PsgDSTimeService;
import com.zkteco.zkbiosecurity.psg.service.PsgDeviceOptionService;
import com.zkteco.zkbiosecurity.psg.service.PsgDeviceService;
import com.zkteco.zkbiosecurity.psg.service.PsgDeviceVerifyModeService;
import com.zkteco.zkbiosecurity.psg.service.PsgParamService;
import com.zkteco.zkbiosecurity.psg.service.PsgPassageService;
import com.zkteco.zkbiosecurity.psg.vo.PsgDSTimeItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgDeviceExportItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgDeviceItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgDeviceOptionItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgDeviceVerifyModeItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgQueryDeviceItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgSearchAddDeviceItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgSearchDeviceItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PsgDeviceController
extends ExportController
implements PsgDeviceRemote {
    private static final Logger log = LoggerFactory.getLogger(PsgDeviceController.class);
    @Autowired
    private PsgDeviceService psgDeviceService;
    @Autowired
    private PsgBaseDictionaryService psgBaseDictionaryService;
    @Autowired
    private PsgParamService psgParamService;
    @Autowired
    private PsgDeviceOptionService psgDeviceOptionService;
    @Autowired
    private PsgDSTimeService psgDSTimeService;
    @Autowired
    private PsgPassageService psgPassageService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private PsgDeviceVerifyModeService psgDeviceVerifyModeService;
    @Value(value="${security.require-ssl:false}")
    private String isSupportHttps;
    @Value(value="${adms.push.port:8088}")
    private int hostPort;
    @Value(value="${server.port:8098}")
    private int serverPort;
    @Value(value="${system.filePath:BioSecurityFile}")
    private String systemFilePath;
    private static final String DEV_UPGRADEFIRMWARE_FILENAME = "emfw.cfg";
    private static final String READER_UPGRADEFIRMWARE_FILENAME = "reader.bin";
    private static final int defWaitCount = 5;
    private static final int maxWaitCount = 12;

    @RequiresPermissions(value={"psg:device"})
    public ModelAndView index() {
        return new ModelAndView("psg/device/psgDevice");
    }

    @RequiresPermissions(value={"psg:device:add", "psg:device:edit"})
    public ModelAndView edit(String id) {
        this.request.setAttribute("psgParams", (Object)this.psgParamService.getPsgParams());
        this.request.setAttribute("persParams", (Object)this.psgParamService.getPersParams());
        if (StringUtils.isNotBlank((CharSequence)id)) {
            PsgDeviceItem psgDeviceItem = this.psgDeviceService.getItemById(id);
            if (Objects.nonNull(psgDeviceItem) && this.psgDeviceOptionService.isSupportFun(psgDeviceItem.getSn(), "TZAdj")) {
                this.request.setAttribute("supportTimeZone", (Object)1);
            }
            this.request.setAttribute("editPage", (Object)true);
            this.request.setAttribute("tempPsgDevice", (Object)psgDeviceItem);
        }
        return new ModelAndView("psg/device/editPsgDevice");
    }

    @RequiresPermissions(value={"psg:device:add", "psg:device:edit"})
    @LogRequest(module="psg_module", object="common_leftMenu_device", opType="common_op_edit", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg save(PsgDeviceItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.psgDeviceService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"psg:device:refresh"})
    public DxGrid list(PsgDeviceItem condition) {
        Pager pager = this.psgDeviceService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"psg:device:del"})
    @LogRequest(module="psg_module", object="common_leftMenu_device", opType="common_op_del", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg delete(String ids) {
        this.psgDeviceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"psg:device:searchDev"})
    public ModelAndView getSearchDevInfo() {
        this.request.setAttribute("psgParams", (Object)this.psgParamService.getPsgParams());
        this.request.setAttribute("persParams", (Object)this.psgParamService.getPersParams());
        this.request.setAttribute("hostPort", (Object)this.hostPort);
        return new ModelAndView("psg/device/opPsgSearchDevice");
    }

    public ZKResultMsg getAllIPSn() {
        JSONObject devInfoJson = new JSONObject();
        List psgDeviceItemList = this.psgDeviceService.getByCondition(new PsgDeviceItem());
        JSONArray ipArray = new JSONArray();
        JSONArray snArray = new JSONArray();
        psgDeviceItemList.stream().forEach(item -> {
            ipArray.add((Object)item.getIpAddress());
            snArray.add((Object)item.getSn());
        });
        devInfoJson.put("ipAddress", (Object)ipArray);
        devInfoJson.put("sn", (Object)snArray);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)devInfoJson));
    }

    @RequiresPermissions(value={"psg:device:searchDev"})
    @LogRequest(module="psg_module", object="common_leftMenu_device", opType="common_dev_searchDev", opContent="common_dev_searchDev")
    public ZKResultMsg searchDevice(Long nowTime) {
        JSONObject devInfoJson = new JSONObject();
        try {
            List deviceItems = this.psgDeviceService.searchDeviceList();
            devInfoJson.put("ret", (Object)"ok");
            devInfoJson.put("devCount", (Object)deviceItems.size());
            JSONArray jsonArray = new JSONArray();
            ArrayList macList = Lists.newArrayList();
            for (PsgSearchDeviceItem item : deviceItems) {
                JSONObject rowData = new JSONObject();
                rowData.put("IP", (Object)item.getIp());
                if (item.getMacAddress() != null && !"".equals(item.getMacAddress())) {
                    if (macList.contains(item.getMacAddress())) {
                        rowData.put("exception", (Object)(I18nUtil.i18nCode((String)"common_dev_macAddress", (Object[])new Object[0]) + I18nUtil.i18nCode((String)"common_dev_duplicateData", (Object[])new Object[0])));
                    } else {
                        rowData.put("MAC", (Object)item.getMacAddress());
                        macList.add(item.getMacAddress());
                    }
                }
                rowData.put("NetMask", (Object)item.getSubnetMask());
                rowData.put("GATEIPAddress", (Object)item.getGateway());
                if (StringUtils.isNotBlank((CharSequence)item.getSn())) {
                    rowData.put("SN", (Object)item.getSn());
                } else {
                    rowData.put("exception", (Object)I18nUtil.i18nCode((String)"common_dev_snNull", (Object[])new Object[0]));
                }
                rowData.put("Device", (Object)item.getDeviceName());
                rowData.put("Authorize", (Object)item.getAuthFlag());
                rowData.put("Protype", (Object)item.getProtype());
                rowData.put("IsSupportSSL", (Object)item.getIsSupportSSL());
                rowData.put("DNSFunOn", (Object)item.getDnsFunOn());
                rowData.put("DNS", (Object)item.getDns());
                if (item.getDns() != null) {
                    rowData.put("DNS", (Object)item.getDns());
                }
                if (item.getServerUrl() != null) {
                    rowData.put("WebServerURL", (Object)item.getServerUrl());
                }
                if (item.getIsSupportMultiCard() != null) {
                    rowData.put("isSupportMultiCard", (Object)item.getIsSupportMultiCard().toString());
                }
                if (item.getMaxMCUCardBits() != null) {
                    rowData.put("MaxMCUCardBits", (Object)item.getMaxMCUCardBits());
                }
                if (item.getMachineType() != null) {
                    rowData.put("MachineType", (Object)item.getMachineType());
                }
                jsonArray.add((Object)rowData);
            }
            devInfoJson.put("devData", (Object)jsonArray);
            devInfoJson.put("nowTime", (Object)nowTime);
            devInfoJson.put("isSupportHttps", (Object)this.isSupportHttps);
            devInfoJson.put("hostAddress", (Object)InetAddress.getLocalHost().getHostAddress());
            devInfoJson.put("hostPort", (Object)this.hostPort);
        }
        catch (Exception e) {
            log.error("search dev error", (Throwable)e);
            throw new ZKBusinessException((Throwable)e);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)devInfoJson));
    }

    @RequiresPermissions(value={"psg:device:updateIpAddr"})
    public ModelAndView getDevIPAddressInfo(String ids, String type) {
        return this.getById(ids, type);
    }

    @RequiresPermissions(value={"psg:device:updateCommPwd"})
    public ModelAndView getDevCommPwdInfo(String ids, String type) {
        return this.getById(ids, type);
    }

    @RequiresPermissions(value={"psg:device:updateMThreshold"})
    public ModelAndView getDevMThresholdInfo(String ids, String type) {
        return this.getById(ids, type);
    }

    public ModelAndView getById(String ids, String type) {
        if (StringUtils.isNotBlank((CharSequence)type)) {
            String status;
            PsgDeviceItem psgDeviceItem = this.psgDeviceService.getItemById(ids);
            this.request.setAttribute("editPage", (Object)true);
            this.request.setAttribute("tempPsgDevice", (Object)psgDeviceItem);
            if (psgDeviceItem != null && !(status = this.psgDeviceService.getStatus(psgDeviceItem.getSn())).equals(String.valueOf(1))) {
                this.request.setAttribute("failedReason", (Object)status);
                return new ModelAndView("psg/device/opDevNotSupportFeatureTips");
            }
            if (type.equals("updateIpAddr")) {
                return new ModelAndView("psg/device/opPsgUpdateIpAddr");
            }
            if (type.equals("updateCommPwd")) {
                boolean isExistOldPwd = true;
                if (psgDeviceItem.getCommPwd() == null || "".equals(psgDeviceItem.getCommPwd()) || "0".equals(psgDeviceItem.getCommPwd())) {
                    isExistOldPwd = false;
                }
                this.request.setAttribute("isExistOldPwd", (Object)isExistOldPwd);
                return new ModelAndView("psg/device/opPsgUpdateCommPwd");
            }
            if (type.equals("updateMThreshold")) {
                boolean supportUpdateMThreshold = this.psgDeviceOptionService.isSupportFun(psgDeviceItem.getSn(), "FingerFunOn");
                if (!supportUpdateMThreshold) {
                    this.request.setAttribute("failedReason", (Object)PsgConstants.DEV_NOT_SUPPORT_FEATURE);
                    return new ModelAndView("psg/device/opDevNotSupportFeatureTips");
                }
                String mThreshold = "";
                PsgDeviceOptionItem psgDeviceOpt = this.psgDeviceOptionService.getDevOptValueBySnAndName(psgDeviceItem.getSn(), "MThreshold");
                if (psgDeviceOpt != null) {
                    mThreshold = psgDeviceOpt.getValue();
                }
                this.request.setAttribute("mThreshold", (Object)mThreshold);
                return new ModelAndView("psg/device/opPsgUpdateMThreshold");
            }
        }
        return null;
    }

    @RequiresPermissions(value={"psg:device:export"})
    @LogRequest(module="psg_module", object="common_leftMenu_device", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        PsgDeviceExportItem psgDeviceItem = new PsgDeviceExportItem();
        this.setConditionValue((BaseItem)psgDeviceItem);
        String areaIds = this.psgDeviceService.getAreaIdsByAuthFilter(request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)areaIds)) {
            psgDeviceItem.setAreaIdIn(areaIds);
        }
        List psgDeviceItemList = this.psgDeviceService.getExportItemList(psgDeviceItem, this.getBeginIndex(), this.getEndIndex());
        HashMap commTypeValue = Maps.newHashMap();
        HashMap netConnectModeValue = Maps.newHashMap();
        HashMap ableValue = Maps.newHashMap();
        commTypeValue.put("1", "TCP/IP");
        commTypeValue.put("3", "HTTP");
        netConnectModeValue.put("0", I18nUtil.i18nCode((String)"psg_dev_netModeWired", (Object[])new Object[0]));
        netConnectModeValue.put("1", I18nUtil.i18nCode((String)"psg_dev_netMode4G", (Object[])new Object[0]));
        netConnectModeValue.put("2", I18nUtil.i18nCode((String)"psg_dev_netModeWifi", (Object[])new Object[0]));
        ableValue.put("0", I18nUtil.i18nCode((String)"common_offline", (Object[])new Object[0]));
        ableValue.put("1", I18nUtil.i18nCode((String)"common_online", (Object[])new Object[0]));
        ableValue.put("2", I18nUtil.i18nCode((String)"common_disable", (Object[])new Object[0]));
        Map authAreaMap = this.psgDeviceService.getAuthAreaByDev(psgDeviceItemList);
        Map passageMap = this.psgPassageService.getPassageByDev(psgDeviceItemList);
        psgDeviceItemList.stream().forEach(item -> {
            if (item.getAuthAreaId() != null) {
                item.setAuthAreaName((String)authAreaMap.get(item.getAuthAreaId()));
            }
            if (item.getPassageId() != null) {
                item.setPassageName((String)passageMap.get(item.getPassageId()));
            }
            item.setCommType((String)commTypeValue.get(item.getCommType()));
            item.setConnectState((String)ableValue.get(this.psgDeviceService.getStatus(item.getSn())));
            if ("0".equals(item.getIsRegistrationDevice()) || "f".equals(item.getIsRegistrationDevice())) {
                item.setIsRegistrationDevice(I18nUtil.i18nCode((String)"common_no", (Object[])new Object[0]));
            } else {
                item.setIsRegistrationDevice(I18nUtil.i18nCode((String)"common_yes", (Object[])new Object[0]));
            }
        });
        this.excelExport(psgDeviceItemList, PsgDeviceExportItem.class);
    }

    @RequiresPermissions(value={"psg:device:enable"})
    @LogRequest(module="psg_module", object="common_leftMenu_device", opType="common_enable", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg enable(String ids) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        try {
            this.psgDeviceService.enableDevice(ids);
        }
        catch (ZKBusinessException e) {
            resultMsg.setRet(e.getLevel());
            resultMsg.setMsg(e.getMessage());
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"psg:device:disable"})
    @LogRequest(module="psg_module", object="common_leftMenu_device", opType="common_disable", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg disable(String ids) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        try {
            this.psgDeviceService.disableDevice(ids);
        }
        catch (ZKBusinessException e) {
            resultMsg.setRet(e.getLevel());
            resultMsg.setMsg(e.getMessage());
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg modifyIPAddress(PsgSearchAddDeviceItem item) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        String mac = item.getMac();
        String options = "";
        if (item.getType().equals("devIP") || item.getType().equals("")) {
            String newIP = item.getNewIP();
            String ip = IpUtil.getLocalIpAddr((HttpServletRequest)this.request);
            List ipList = IpUtil.getAllIPAddr();
            if (newIP.equals(ip) || ipList.contains(newIP)) {
                resultMsg.setRet("500");
                resultMsg.setMsg("psg_dev_addDevIpTip");
                return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
            }
            String subnetMask = item.getSubnetMask();
            String gateway = item.getGateway();
            String commPwd = item.getCommPwd() != null ? item.getCommPwd() : "";
            options = String.format("MAC=%s,ComPwd=%s,IPAddress=%s,GATEIPAddress=%s,NetMask=%s,Reboot=1", mac, commPwd, newIP, gateway, subnetMask);
        } else {
            String webServerIP = item.getWebServerIP();
            String webServerPort = item.getWebServerPort();
            String newPwd = item.getNewPwd();
            String newWebServerType = item.getNewWebServerType();
            String newDNS = item.getNewDNS();
            String newWebServerURL = item.getNewWebServerURL();
            String isSupportSSL = item.getIsSupportSSL();
            options = StringUtils.isNotBlank((CharSequence)newWebServerType) && newWebServerType.equals("2") ? (this.isSupportHttps.equals("true") ? String.format("MAC=%s,ComPwd=%s,WebServerURL=%s,DNS=%s,WebServerURLModel=1", mac, newPwd, "https://" + newWebServerURL + ":" + webServerPort, newDNS) : String.format("MAC=%s,ComPwd=%s,WebServerURL=%s,DNS=%s,WebServerURLModel=1", mac, newPwd, "http://" + newWebServerURL + ":" + webServerPort, newDNS)) : (this.isSupportHttps.equals("true") ? String.format("MAC=%s,ComPwd=%s,WebServerURL=%s,WebServerURLModel=0", mac, newPwd, "https://" + webServerIP + ":" + webServerPort) : (isSupportSSL.equals("true") ? String.format("MAC=%s,ComPwd=%s,WebServerURL=%s,WebServerURLModel=0", mac, newPwd, "http://" + webServerIP + ":" + webServerPort) : String.format("MAC=%s,ComPwd=%s,WebServerIP=%s,WebServerPort=%s,WebServerURLModel=0", mac, newPwd, webServerIP, webServerPort)));
            if (StringUtils.isNotBlank((CharSequence)options)) {
                options = options + ",Reboot=1";
            }
        }
        String msgStr = "psg_dev_rebootAfterOperate";
        int ret = this.psgDeviceService.modifyDeviceOptions(options);
        if (ret < 0) {
            msgStr = "devIP".equals(item.getType()) && "-14".equals(String.valueOf(ret)) ? "common_dev_modifyAndCommPwdError" : ("webServerIP".equals(item.getType()) && "-14".equals(String.valueOf(ret)) ? "common_commStatus_commPwdError" : this.psgBaseDictionaryService.getCommReason(ret));
            if ("".equals(msgStr)) {
                msgStr = I18nUtil.i18nCode((String)"common_unknown", (Object[])new Object[0]);
            }
            resultMsg.setRet("pwdError");
            resultMsg.setMsg(msgStr);
        } else if ("webServerIP".equals(item.getType())) {
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException e) {
                log.error(e.getMessage());
            }
            this.psgDeviceService.authDevice(item.getSn(), item);
            resultMsg.setMsg(msgStr);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public boolean isExistByAlias(String alias) {
        PsgDeviceItem psgDeviceItem = new PsgDeviceItem();
        psgDeviceItem.setAlias(alias);
        return this.psgDeviceService.getByCondition(psgDeviceItem).size() <= 0;
    }

    public boolean checkOperPwd(String operationPwd) {
        String checkPwd = DateUtil.dateToString((Date)new Date(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYYMMDD);
        String key = this.psgParamService.getParamValByName("psg.addDeviceOperKeyword");
        if ((this.encryKey(key) + this.sortStr(checkPwd)).equals(operationPwd)) {
            this.request.getSession().setAttribute("operationPwd", (Object)operationPwd);
            return true;
        }
        this.request.getSession().removeAttribute("operationPwd");
        return false;
    }

    private String encryKey(String key) {
        StringBuffer sb = new StringBuffer("");
        if (!"xxx".equals(key)) {
            String s = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
            int index = 0;
            for (int i = 0; i < key.length(); ++i) {
                index = s.indexOf(key.charAt(i));
                sb.append((index + 1) % 10);
            }
        }
        return sb.toString();
    }

    private String sortStr(String str) {
        char[] s1 = str.toCharArray();
        for (int i = 0; i < s1.length; ++i) {
            for (int j = 0; j < i; ++j) {
                if (s1[i] >= s1[j]) continue;
                char temp = s1[i];
                s1[i] = s1[j];
                s1[j] = temp;
            }
        }
        return String.valueOf(s1);
    }

    public ZKResultMsg validPushDevCount(String sn) {
        ZKResultMsg resultMsg = this.psgDeviceService.validPushDevCount(sn);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public boolean isExistIpAddress(String ipAddress) {
        return this.psgDeviceService.isExistIpAddress(ipAddress);
    }

    public boolean isExistAlias(String alias) {
        return this.psgDeviceService.isExistAlias(alias);
    }

    @RequiresPermissions(value={"psg:device:syncAllData"})
    public ModelAndView getDevIdsBySyncData(String ids, String type) {
        if (type != null && !type.isEmpty()) {
            List list = this.psgDeviceService.getItemByIds(ids);
            StringBuffer devName = new StringBuffer("");
            StringBuffer disabledDevName = new StringBuffer("");
            PsgDeviceItem dev = null;
            StringBuffer retIds = new StringBuffer();
            HashMap<String, StringBuffer> devNameMap = new HashMap<String, StringBuffer>();
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                dev = (PsgDeviceItem)list.get(i);
                short machineType = dev.getMachineType();
                if (this.psgDeviceService.isEnabled(dev.getSn())) {
                    retIds.append(dev.getId()).append(",");
                    String devTypeName = (String)PsgConstants.MACHINETYPE_DEVTYPE.get(machineType);
                    if (devTypeName == null) {
                        devTypeName = (String)PsgConstants.MACHINETYPE_DEVTYPE.get(PsgConstants.DEVICE_CONTROL);
                    }
                    if (devNameMap.containsKey(devTypeName)) {
                        ((StringBuffer)devNameMap.get(devTypeName)).append(dev.getAlias() + "&" + dev.getId() + ",");
                        continue;
                    }
                    StringBuffer devNameBuf = new StringBuffer(devTypeName + "-" + I18nUtil.i18nCode((String)((String)PsgConstants.DEV_NAME_MAP.get(devTypeName)), (Object[])new Object[0]) + ":" + dev.getAlias() + "&" + dev.getId() + ",");
                    devNameMap.put(devTypeName, devNameBuf);
                    continue;
                }
                disabledDevName.append(dev.getAlias() + ",");
            }
            for (StringBuffer nameBuf : devNameMap.values()) {
                devName.append(nameBuf.substring(0, nameBuf.length() - 1) + ";");
            }
            this.request.setAttribute("devIds", retIds.length() > 0 ? retIds.substring(0, retIds.length() - 1) : null);
            this.request.setAttribute("devicesName", devName.length() > 0 ? devName.substring(0, devName.length() - 1) : null);
            this.request.setAttribute("disabledDevName", disabledDevName.length() > 0 ? disabledDevName.substring(0, disabledDevName.length() - 1) : null);
            if ("syncAllData".equals(type)) {
                return new ModelAndView("psg/device/opPsgSyncAllData");
            }
        }
        return null;
    }

    public ZKResultMsg syncAllDataByDevType(String devType, String devId) {
        JSONArray dataArray = new JSONArray();
        LinkedHashSet<String> funcSet = new LinkedHashSet<String>();
        if ("ONEMACHINE".equals(devType) || "CONTROL".equals(devType)) {
            funcSet = new LinkedHashSet(PsgConstants.DEVICE_ACCESS_FUNCTION);
        }
        List devList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)devId) && !devId.equals("undefined")) {
            devList = this.psgDeviceService.getItemByIds(devId);
        }
        for (PsgDeviceItem dev : devList) {
            if (!this.psgDeviceOptionService.isSupportFunList(dev.getSn(), 8)) continue;
            funcSet.add(PsgConstants.PsgSyncDataType.AUXINSET.getValue());
        }
        if (funcSet.size() > 0) {
            for (String func : funcSet) {
                dataArray.add((Object)func);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)dataArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"psg:device:syncAllData"})
    @LogRequest(module="psg_module", object="common_leftMenu_device", opType="common_dev_syncAllDataToDev", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg syncAllData(String devIds, String optBoxValue) {
        try {
            String[] optBox = optBoxValue.split(",");
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            List devList = this.psgDeviceService.getItemByIds(devIds);
            int size = devList.size();
            for (int i = 0; i < size; ++i) {
                PsgDeviceItem dev = (PsgDeviceItem)devList.get(i);
                int total = (int)((float)(i + 1) / (float)size * 100.0f);
                int lastTotal = (int)(((double)i + 0.3) / (double)size * 100.0);
                this.progressCache.setProcess(new ProcessBean(30, lastTotal, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"common_dev_syncPrompt", (Object[])new Object[0]) + "<br/>"));
                this.psgDeviceService.syncDataToDev(dev.getSn(), optBox);
                this.progressCache.setProcess(new ProcessBean(100, total, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"common_dev_syncSuccess", (Object[])new Object[0]) + "<br/>"));
            }
        }
        catch (Exception e) {
            log.error("exception", (Throwable)e);
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "," + I18nUtil.i18nCode((String)"common_progress_syncAllDataTip", (Object[])new Object[0]));
        }
        return null;
    }

    public ZKResultMsg isOnline(String deviceId) {
        List psgDeviceItemList = this.psgDeviceService.getItemByIds(deviceId);
        StringBuffer offLineAlias = new StringBuffer("");
        StringBuffer offLineIds = new StringBuffer("");
        JSONObject retJson = new JSONObject();
        for (PsgDeviceItem dev : psgDeviceItemList) {
            if (!this.psgDeviceService.getStatus(dev.getSn()).equals(String.valueOf(0))) continue;
            offLineIds.append(dev.getId()).append(",");
            offLineAlias.append(dev.getAlias()).append(",");
        }
        retJson.put("ids", (Object)(offLineIds.length() > 0 ? offLineIds.substring(0, offLineIds.length() - 1) : offLineIds.toString()));
        retJson.put("alias", (Object)(offLineAlias.length() > 0 ? offLineAlias.substring(0, offLineAlias.length() - 1) : offLineAlias.toString()));
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)retJson));
    }

    @RequiresPermissions(value={"psg:device:rebootDevice"})
    @LogRequest(module="psg_module", object="common_leftMenu_device", opType="psg_dev_reboot", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg rebootDevice(String ids) {
        String offline = "";
        ArrayList<String> rebootDevIdList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List devList = this.psgDeviceService.getItemByIds(ids);
            for (PsgDeviceItem dev : devList) {
                if (!String.valueOf(1).equals(this.psgDeviceService.getStatus(dev.getSn()))) {
                    offline = offline + dev.getAlias() + I18nUtil.i18nCode((String)"common_dev_offlinePrompt", (Object[])new Object[0]) + ",";
                    continue;
                }
                rebootDevIdList.add(dev.getId());
            }
            this.psgDeviceService.rebootDevice(rebootDevIdList, false);
            if (StringUtils.isNotBlank((CharSequence)offline)) {
                offline = offline.substring(0, offline.length() - 1);
                throw new ZKBusinessException(offline);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"psg:device:getOptFromDev"})
    @LogRequest(module="psg_module", object="common_leftMenu_device", opType="common_dev_getDevOpt", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg getOptFromDev(String ids) {
        StringBuffer failedDev = new StringBuffer("");
        ZKResultMsg resultMsg = new ZKResultMsg();
        String retStr = "ok";
        try {
            if (StringUtils.isNotBlank((CharSequence)ids)) {
                List devList = this.psgDeviceService.getItemByIds(ids);
                ArrayList<Long> cmdIdList = new ArrayList<Long>();
                HashMap<Long, String> cmdIdAndDevNameMap = new HashMap<Long, String>();
                for (PsgDeviceItem dev : devList) {
                    if (!this.psgDeviceService.getStatus(dev.getSn()).equals(String.valueOf(1))) {
                        failedDev.append(dev.getAlias() + "," + I18nUtil.i18nCode((String)"common_dev_offlinePrompt", (Object[])new Object[0]) + "</br>");
                        retStr = "500";
                        resultMsg.setRet(retStr);
                        resultMsg.setMsg(failedDev.substring(0, failedDev.length() - 1));
                        continue;
                    }
                    long cmdIdTemp = 0L;
                    int optionCount = 3;
                    block3: for (int i = 1; i < optionCount; ++i) {
                        List cmdIds = this.psgDeviceService.getOptFromDev(dev.getSn(), i);
                        Iterator iterator = cmdIds.iterator();
                        while (iterator.hasNext()) {
                            long cmdId = (Long)iterator.next();
                            if (cmdId < 0L) {
                                if (cmdIdTemp != 0L) {
                                    cmdIdList.remove(cmdIdTemp);
                                    cmdIdAndDevNameMap.remove(cmdIdTemp);
                                }
                                String describe = i == 1 ? I18nUtil.i18nCode((String)"psg_dev_baseOptionTip", (Object[])new Object[0]) : I18nUtil.i18nCode((String)"psg_dev_funOptionTip", (Object[])new Object[0]);
                                failedDev.append(dev.getAlias() + ":" + describe + "," + I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]));
                                retStr = "400";
                                resultMsg.setRet(retStr);
                                resultMsg.setMsg(I18nUtil.i18nCode((String)"psg_dev_sendComandoTip", (Object[])new Object[0]));
                                continue block3;
                            }
                            cmdIdTemp = cmdId;
                            cmdIdList.add(cmdId);
                            cmdIdAndDevNameMap.put(cmdId, dev.getAlias());
                        }
                    }
                }
                if (cmdIdList.size() > 0) {
                    Iterator iterator = cmdIdList.iterator();
                    while (iterator.hasNext()) {
                        long cmdId = (Long)iterator.next();
                        Map resultMap = this.psgDeviceService.getCmdResultById(Long.valueOf(cmdId), 30);
                        if (!Objects.nonNull(resultMap)) continue;
                        Integer result = Integer.valueOf((String)resultMap.get("result"));
                        if (failedDev.indexOf((String)cmdIdAndDevNameMap.get(cmdId)) != -1) continue;
                        if (Objects.isNull(result)) {
                            failedDev.append((String)cmdIdAndDevNameMap.get(cmdId) + "," + I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + "<br>");
                            retStr = "400";
                            continue;
                        }
                        if (result >= 0) continue;
                        String failedInfo = this.psgBaseDictionaryService.getCommReason(result.intValue());
                        failedInfo = StringUtils.isNotBlank((CharSequence)failedInfo) ? I18nUtil.i18nCode((String)failedInfo, (Object[])new Object[0]) : result.toString();
                        failedDev.append((String)cmdIdAndDevNameMap.get(cmdId) + "," + I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + "," + I18nUtil.i18nCode((String)"common_dev_errorCode", (Object[])new Object[0]) + ":" + failedInfo + "<br>");
                        retStr = "400";
                    }
                    if (retStr.equals("400")) {
                        resultMsg.setRet(retStr);
                        resultMsg.setMsg(I18nUtil.i18nCode((String)"common_dev_getDevOptFails", (Object[])new Object[0]));
                    }
                }
            }
        }
        catch (Exception e) {
            throw ZKBusinessException.errorException((String)I18nUtil.i18nCode((String)"common_dev_getDevOptFails", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"psg:device:syncTime"})
    public ModelAndView getDevSyncTimeInfo(String ids, String type, String checkOffline) {
        return this.getDevIds(ids, type, checkOffline);
    }

    @RequiresPermissions(value={"psg:device:uploadPersonInfo"})
    public ModelAndView getUploadPersonInfo(String ids, String type, String checkOffline) {
        return this.getDevIds(ids, type, checkOffline);
    }

    @RequiresPermissions(value={"psg:device:uploadTransaction"})
    public ModelAndView getUploadTransactionInfo(String ids, String type, String checkOffline) {
        return this.getDevIds(ids, type, checkOffline);
    }

    private ModelAndView getDevIds(String ids, String type, String checkOffline) {
        if (StringUtils.isNotBlank((CharSequence)ids) && StringUtils.isNotBlank((CharSequence)type)) {
            List list = this.psgDeviceService.getItemByIds(ids);
            HashMap<String, String> devNameMap = new HashMap<String, String>();
            StringBuffer disabledDevName = new StringBuffer("");
            StringBuffer warnInfoDevName = new StringBuffer("");
            StringBuffer offlineDevName = new StringBuffer("");
            StringBuffer supportDevFun = new StringBuffer("");
            PsgDeviceItem dev = null;
            StringBuffer retIds = new StringBuffer();
            for (int i = 0; i < list.size(); ++i) {
                String name;
                dev = (PsgDeviceItem)list.get(i);
                if (String.valueOf(1).equals(this.psgDeviceService.getStatus(dev.getSn()))) {
                    name = dev.getDeviceName();
                    if (type.equals("uploadPersonInfo")) {
                        retIds.append(dev.getId()).append(",");
                        if (devNameMap.containsKey(name)) continue;
                        devNameMap.put(name, name);
                        String isRemind = "0";
                        String authority = "1000";
                        if (101 == dev.getMachineType() && Short.valueOf(dev.getCommType()) == 3) {
                            authority = this.psgDeviceService.getFingerFvFaceFunOn(dev.getSn());
                        }
                        String isSupportPalm = "0";
                        if (this.psgDeviceOptionService.isSupportDevParam(dev.getSn(), "PvFunOn")) {
                            isSupportPalm = "1";
                        }
                        String isSupportBiophoto = "0";
                        if (this.psgDeviceOptionService.isSupportDevParam(dev.getSn(), "BioPhotoFun")) {
                            isSupportBiophoto = "1";
                        }
                        supportDevFun.append(name + ":" + authority + isRemind + isSupportBiophoto + isSupportPalm + ",");
                        continue;
                    }
                    if (type.equals("uploadTransaction")) {
                        retIds.append(dev.getId()).append(",");
                        if (devNameMap.containsKey(name)) continue;
                        String isSupportAccount = "0";
                        devNameMap.put(name, name);
                        if (this.psgDeviceOptionService.getPsgSupportFunListVal(dev.getId(), 11)) {
                            isSupportAccount = "1";
                        }
                        supportDevFun.append(name + ":" + isSupportAccount + ",");
                        continue;
                    }
                    retIds.append(dev.getId()).append(",");
                    devNameMap.put(name, name);
                    continue;
                }
                if (String.valueOf(2).equals(this.psgDeviceService.getStatus(dev.getSn()))) {
                    disabledDevName.append(dev.getAlias()).append(",");
                } else if (StringUtils.isNotBlank((CharSequence)checkOffline)) {
                    name = dev.getDeviceName();
                    devNameMap.put(name, name);
                } else {
                    offlineDevName.append(dev.getAlias()).append(",");
                }
                list.remove(i);
                --i;
            }
            StringBuffer devName = new StringBuffer("");
            boolean isNeed = false;
            for (String key : devNameMap.keySet()) {
                devName.append((String)devNameMap.get(key)).append(":");
                int innerLen = list.size();
                for (int j = 0; j < innerLen; ++j) {
                    if (!Pattern.compile(key).matcher(((PsgDeviceItem)list.get(j)).getDeviceName()).find() && !key.equals(((PsgDeviceItem)list.get(j)).getDeviceName()) || !String.valueOf(1).equals(this.psgDeviceService.getStatus(((PsgDeviceItem)list.get(j)).getSn()))) continue;
                    isNeed = true;
                    devName.append(((PsgDeviceItem)list.get(j)).getAlias() + "&" + ((PsgDeviceItem)list.get(j)).getId()).append(",");
                }
                if (isNeed) {
                    devName.append(";");
                    continue;
                }
                if (devName.indexOf(";") < 0) {
                    devName = new StringBuffer("");
                    continue;
                }
                devName.substring(0, devName.lastIndexOf(";") - 1);
            }
            this.request.setAttribute("retIds", (Object)(retIds.toString().equals("") ? "" : retIds.substring(0, retIds.length() - 1)));
            this.request.setAttribute("devicesName", (Object)(devName.toString().equals("") ? "" : devName.substring(0, devName.length() - 1)));
            this.request.setAttribute("disabledDevName", (Object)(disabledDevName.toString().equals("") ? "" : disabledDevName.substring(0, disabledDevName.length() - 1)));
            this.request.setAttribute("offlineDevName", (Object)(offlineDevName.toString().equals("") ? "" : offlineDevName.substring(0, offlineDevName.length() - 1)));
            this.request.setAttribute("warnInfoDevName", (Object)(warnInfoDevName.toString().equals("") ? "" : warnInfoDevName.substring(0, warnInfoDevName.length() - 1)));
            this.request.setAttribute("supportDevFun", (Object)(supportDevFun.toString().equals("") ? "" : supportDevFun.substring(0, supportDevFun.toString().length() - 1)));
            if (StringUtils.isNotBlank((CharSequence)checkOffline)) {
                this.request.setAttribute("checkOffline", (Object)checkOffline);
            }
            switch (type) {
                case "uploadPersonInfo": {
                    return new ModelAndView("psg/device/opPsgUploadPersonInfo");
                }
                case "uploadTransaction": {
                    return new ModelAndView("psg/device/opPsgUploadTransaction");
                }
                case "syncTime": {
                    return new ModelAndView("psg/device/opPsgSyncTime");
                }
                case "upgradeFirmware": {
                    return new ModelAndView("psg/device/opPsgUpgradeFirmware");
                }
            }
        }
        return null;
    }

    @RequiresPermissions(value={"psg:device:uploadPersonInfo"})
    @LogRequest(module="psg_module", object="common_leftMenu_device", opType="common_dev_getPersonInfo", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg uploadPersonInfo(String devIds, String dataType, String dataCountOnly, String tempClientId) {
        if (StringUtils.isNotBlank((CharSequence)dataCountOnly) && "true".equals(dataCountOnly)) {
            this.sendCmdAndGetDataCount(Short.valueOf(dataType), devIds);
        } else if (!tempClientId.equals(this.request.getSession().getAttribute("beforeClientId"))) {
            this.request.getSession().setAttribute("beforeClientId", (Object)tempClientId);
            this.uploadPersonInfoFromDev(devIds, dataType);
        }
        return null;
    }

    private void uploadPersonInfoFromDev(String devIds, String dataType) {
        ArrayList devIdList = Lists.newArrayList((Object[])devIds.split(","));
        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "...<br/>");
        ArrayList cmdIdList = Lists.newArrayList();
        String devId = null;
        Map dataMap = null;
        int total = 0;
        int devSize = devIdList.size();
        for (int i = 0; i < devSize; ++i) {
            devId = (String)devIdList.get(i);
            dataMap = this.psgDeviceService.getPersonInfoFromDev(devId, dataType);
            if (dataMap.containsKey("cmdIds") && !((String)dataMap.get("cmdIds")).equals("")) {
                String[] cmdIdArray;
                String cmdIds = (String)dataMap.get("cmdIds");
                for (String cmdId : cmdIdArray = cmdIds.split(",")) {
                    cmdIdList.add(cmdId);
                }
            }
            this.progressCache.setProcess(new ProcessBean(100, total, (String)dataMap.get("devName") + I18nUtil.i18nCode((String)"common_dev_cmdSendSucceed", (Object[])new Object[0]) + "<br/>"));
        }
        ArrayList cmdIdArray = Lists.newArrayList((Iterable)cmdIdList);
        int ret = this.dealQueryDataFromRedis(cmdIdArray, 1800000, this.progressCache, false, false);
        if (ret == 0) {
            for (String cmdId : cmdIdList) {
                String key = "psg:queryConflictCard:" + cmdId;
                String conflictCard = this.psgDeviceService.getQueryData(key);
                if ("".equals(conflictCard)) continue;
                String msg = I18nUtil.i18nCode((String)"psg_dev_conflictCardNo", (Object[])new Object[]{conflictCard});
                this.progressCache.setProcess(new ProcessBean(100, 99, "<font color='red'>" + msg + "</font><br/>"));
            }
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        } else if (ret == -1) {
            this.progressCache.finishProcess("<font color='red'>" + I18nUtil.i18nCode((String)"common_progress_getDataFailed", (Object[])new Object[0]) + "...</font><br/>");
        } else if (ret == 1) {
            this.progressCache.finishProcess("<font color='#E57A14'>" + I18nUtil.i18nCode((String)"common_progress_busyFailed", (Object[])new Object[0]) + "</font><br/>");
        }
    }

    private int dealQueryDataFromRedis(List<String> cmdIdList, int timeout, ProgressCache dealRate, boolean newLog, boolean isAccount) {
        int ret = 0;
        String key = null;
        PsgDeviceItem dev = null;
        int cmdLen = cmdIdList.size();
        int time = timeout;
        try {
            if (isAccount) {
                this.psgDeviceService.dealAccountDataFromRedis(cmdIdList);
            }
            dealRate.setProcess(new ProcessBean(100, 0, I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "<br/>"));
            int everyProcess = 100 / cmdLen;
            while (time > 0 && cmdIdList.size() != 0) {
                for (int j = 0; j < cmdIdList.size(); ++j) {
                    key = "psg:queryData:" + cmdIdList.get(j);
                    String queryData = this.psgDeviceService.getQueryData(key);
                    if ("".equals(queryData)) continue;
                    JSONObject tempJson = JSONObject.parseObject((String)queryData);
                    dev = this.psgDeviceService.getItemByDevSn(tempJson.getString("sn"));
                    if (tempJson.containsKey((Object)"exception")) {
                        dealRate.setProcess(new ProcessBean(100, 99, "<font color='red'>" + dev.getAlias() + ":" + I18nUtil.i18nCode((String)"psg_dev_getInfoFail", (Object[])new Object[0]) + "</font><br/><font color='red'>" + dev.getAlias() + ":" + I18nUtil.i18nCode((String)tempJson.getString("exception"), (Object[])new Object[0]) + "</font><br/>"));
                        this.psgDeviceService.delQueryData(key);
                        cmdIdList.remove(j);
                        continue;
                    }
                    if (tempJson.getIntValue("packIdx") > tempJson.getIntValue("packCnt")) continue;
                    int process = everyProcess * (cmdLen - cmdIdList.size());
                    if (tempJson.getIntValue("packCnt") != 0) {
                        process = everyProcess * (cmdLen - cmdIdList.size()) + everyProcess * tempJson.getIntValue("packIdx") / tempJson.getIntValue("packCnt");
                    }
                    process = process == 100 ? process - 1 : process;
                    dealRate.setProcess(new ProcessBean(100, process));
                    if (tempJson.getIntValue("packCnt") != tempJson.getIntValue("packIdx")) continue;
                    String tableDesc = "";
                    if (tempJson.containsKey((Object)"table")) {
                        tableDesc = I18nUtil.i18nCode((String)((String)this.psgBaseDictionaryService.getBaseDictionaryMap("opType").get(tempJson.getString("table"))), (Object[])new Object[0]);
                    }
                    StringBuffer desc = new StringBuffer("");
                    if (tempJson.getIntValue("packCnt") == 0) {
                        desc.append(dev.getAlias()).append(":" + I18nUtil.i18nCode((String)"psg_dev_getInfoXSuccess", (Object[])new Object[]{tableDesc}) + "<br/>").append(" " + I18nUtil.i18nCode((String)"psg_dev_noData", (Object[])new Object[0]) + "<br/>");
                    } else if (Long.parseLong(tempJson.getString("count")) == 0L) {
                        desc.append(dev.getAlias()).append(":" + I18nUtil.i18nCode((String)"psg_dev_getInfoXSuccess", (Object[])new Object[]{tableDesc}) + "<br/>");
                        if (tempJson.getString("table").equals("transaction")) {
                            desc.append(" " + I18nUtil.i18nCode((String)"psg_dev_noNewData", (Object[])new Object[0]) + "<br/>");
                        } else {
                            desc.append(" " + I18nUtil.i18nCode((String)"psg_dev_noData", (Object[])new Object[0]) + "<br/>");
                        }
                    } else {
                        desc.append(dev.getAlias()).append(":" + I18nUtil.i18nCode((String)"psg_dev_getInfoXSuccess", (Object[])new Object[]{tableDesc}) + "<br/>").append(I18nUtil.i18nCode((String)"common_dev_getTotal", (Object[])new Object[0]) + " " + Long.parseLong(tempJson.getString("count"))).append(" " + I18nUtil.i18nCode((String)"common_dev_record", (Object[])new Object[0])).append("," + I18nUtil.i18nCode((String)"common_dev_duplicateData", (Object[])new Object[0])).append(" " + (Long.parseLong(tempJson.getString("count")) - Long.parseLong(tempJson.getString("update")) - Long.parseLong(tempJson.getString("insert")))).append(" " + I18nUtil.i18nCode((String)"common_dev_record", (Object[])new Object[0]) + ",").append(I18nUtil.i18nCode((String)"common_dev_insertData", (Object[])new Object[0]) + " " + Long.valueOf(tempJson.getString("insert")) + " ").append(I18nUtil.i18nCode((String)"common_dev_record", (Object[])new Object[0]) + ",").append(I18nUtil.i18nCode((String)"common_dev_updateData", (Object[])new Object[0]) + " " + Long.parseLong(tempJson.getString("update")) + " ").append(I18nUtil.i18nCode((String)"common_dev_record", (Object[])new Object[0]) + "<br/>");
                    }
                    dealRate.setProcess(new ProcessBean(100, process, desc.toString()));
                    this.psgDeviceService.delQueryData(key);
                    cmdIdList.remove(j);
                }
                Thread.sleep(4000L);
                time -= 4000;
            }
            if (time <= 0) {
                ret = 1;
            }
        }
        catch (Exception e) {
            ret = -1;
            log.error("exception", (Throwable)e);
        }
        return ret;
    }

    private void sendCmdAndGetDataCount(Short dataType, String devIds) {
        if (StringUtils.isNotBlank((CharSequence)devIds)) {
            ArrayList devIdList = Lists.newArrayList((Object[])devIds.split(","));
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "...<br/>");
            StringBuffer retCmdBuf = new StringBuffer();
            Map dataMap = null;
            for (String devId : devIdList) {
                int i = 0;
                int lastTotal = (int)(((double)i + 0.3) / (double)devIdList.size() * 100.0);
                dataMap = this.psgDeviceService.sendCmdAndGetDataCount(dataType, devId);
                retCmdBuf.append((String)dataMap.get("cmdIds")).append(",");
                this.progressCache.setProcess(new ProcessBean(100, lastTotal, (String)dataMap.get("devName") + ":" + I18nUtil.i18nCode((String)"common_dev_cmdSendSucceed", (Object[])new Object[0]) + "...<br/>"));
                ++i;
            }
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            String[] cmdIdArray = retCmdBuf.toString().split(",");
            int cmdIdArrayLen = cmdIdArray.length;
            for (int index = 0; index < cmdIdArrayLen; ++index) {
                String cmdId = cmdIdArray[index];
                if ("".equals(cmdId)) continue;
                int total = (int)((double)(index + 1) * 1.0 / (double)cmdIdArrayLen * 100.0);
                total = total == 100 ? 99 : total;
                Map resultMap = this.psgDeviceService.getCmdResultById(Long.valueOf(cmdId), 20);
                if (Objects.nonNull(resultMap)) {
                    Integer result = Integer.valueOf((String)resultMap.get("result"));
                    String sn = (String)resultMap.get("sn");
                    PsgQueryDeviceItem dev = this.psgDeviceService.getQueryItemBySn(sn);
                    String fingerVersion = this.psgDeviceOptionService.getValueByNameAndDevSn(dev.getSn(), "~ZKFPVersion");
                    if (Objects.nonNull(dev)) {
                        if (result >= 0) {
                            if ("".equals(this.psgDeviceService.getQueryData("IS_ERROR_USER"))) {
                                String showText = "";
                                String dataCount = "0";
                                JSONObject dataCountJson = JSONObject.parseObject((String)this.psgDeviceService.getQueryData("psg:dataCount:" + cmdId));
                                if (dataType == PsgConstants.DEV_TYPE_ZERO) {
                                    dataCount = dataCountJson.get((Object)"user").toString();
                                    showText = I18nUtil.i18nCode((String)"psg_dev_getPersonCount", (Object[])new Object[0]) + ":" + dataCount + "<br/>";
                                } else if (dataType == PsgConstants.DEV_TYPE_FIRST) {
                                    dataCount = "12".equals(fingerVersion) ? dataCountJson.get((Object)"biodata").toString() : dataCountJson.get((Object)"templatev10").toString();
                                    showText = I18nUtil.i18nCode((String)"psg_dev_getFPCount", (Object[])new Object[0]) + ":" + dataCount + "<br/>";
                                } else if (dataType == PsgConstants.DEV_TYPE_SECOND) {
                                    dataCount = dataCountJson.get((Object)"facev7").toString();
                                    showText = I18nUtil.i18nCode((String)"psg_dev_getFaceCount", (Object[])new Object[0]) + ":" + Long.parseLong(dataCount) + "<br/>";
                                } else if (dataType == PsgConstants.DEV_TYPE_THIRD) {
                                    dataCount = dataCountJson.get((Object)"fvtemplate").toString();
                                    showText = I18nUtil.i18nCode((String)"psg_dev_getFVCount", (Object[])new Object[0]) + ":" + Long.parseLong(dataCount) + "<br/>";
                                } else if (dataType == 4) {
                                    dataCount = dataCountJson.get((Object)"biophoto").toString();
                                    showText = I18nUtil.i18nCode((String)"psg_dev_getBiophotoCount", (Object[])new Object[0]) + ":" + Long.parseLong(dataCount) + "<br/>";
                                } else if (dataType == 5) {
                                    dataCount = dataCountJson.get((Object)"biodata").toString();
                                    showText = I18nUtil.i18nCode((String)"psg_dev_getPalmCount", (Object[])new Object[0]) + ":" + Long.parseLong(dataCount) + "<br/>";
                                }
                                if (!"".equals(this.psgDeviceService.getQueryData("SUM_RECORD_USER"))) {
                                    this.progressCache.setProcess(new ProcessBean(100, total, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"psg_dev_getInfoSuccess", (Object[])new Object[0]) + "<br/>" + showText));
                                    this.psgDeviceService.delQueryData("SUM_RECORD_USER");
                                } else {
                                    this.progressCache.setProcess(new ProcessBean(100, total, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"psg_dev_getInfoSuccess", (Object[])new Object[0]) + "<br/>" + showText));
                                }
                            } else {
                                this.progressCache.setProcess(new ProcessBean(100, total, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"psg_dev_getInfoFail", (Object[])new Object[0]) + "<br/>" + I18nUtil.i18nCode((String)"common_dev_errorCode", (Object[])new Object[0]) + ":" + this.psgDeviceService.getQueryData("IS_ERROR_USER") + "</br>"));
                                this.psgDeviceService.delQueryData("IS_ERROR_USER");
                            }
                            this.psgDeviceService.delQueryData("psg:dataCount:" + cmdId);
                            continue;
                        }
                        String failedInfo = this.psgBaseDictionaryService.getCommReason(result.intValue());
                        failedInfo = StringUtils.isNotBlank((CharSequence)failedInfo) ? I18nUtil.i18nCode((String)failedInfo, (Object[])new Object[0]) : result.toString();
                        this.progressCache.setProcess(new ProcessBean(100, total, "<font color='red'>" + dev.getAlias() + ":" + I18nUtil.i18nCode((String)"psg_dev_getInfoFail", (Object[])new Object[0]) + "</font>," + I18nUtil.i18nCode((String)"common_dev_errorCode", (Object[])new Object[0]) + ":" + failedInfo + "</br>"));
                        continue;
                    }
                    this.progressCache.setProcess(new ProcessBean(100, total, "<font color='red'>" + I18nUtil.i18nCode((String)"common_dev_notExistDev", (Object[])new Object[0]) + ", SN=" + sn + "</font><br/>"));
                    continue;
                }
                this.progressCache.setProcess(new ProcessBean(100, total, "<font color='red'>" + I18nUtil.i18nCode((String)"psg_dev_getInfoFail", (Object[])new Object[0]) + "</font></br>"));
            }
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        }
    }

    @RequiresPermissions(value={"psg:device:uploadTransaction"})
    @LogRequest(module="psg_module", object="common_leftMenu_device", opType="common_dev_getTrans", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg uploadTransaction(String devIds, String records) {
        String[] devIdArray;
        boolean newLog = "1".equals(records);
        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "...<br/>");
        ArrayList<String> cmdIdList = new ArrayList<String>();
        int total = 0;
        for (String devId : devIdArray = devIds.split(",")) {
            Map devDataMap = this.psgDeviceService.uploadTransaction(devId, records);
            cmdIdList.addAll(Lists.newArrayList((Object[])((String)devDataMap.get("cmdId")).split(",")));
            this.progressCache.setProcess(new ProcessBean(100, total, (String)devDataMap.get("alias") + ":" + I18nUtil.i18nCode((String)"common_dev_cmdSendSucceed", (Object[])new Object[0]) + "<br/>"));
        }
        int ret = this.dealQueryDataFromRedis(cmdIdList, 3600000, this.progressCache, newLog, "3".equals(records));
        if (ret == 0) {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        } else if (ret == -1) {
            this.progressCache.finishProcess("<font color='red'>" + I18nUtil.i18nCode((String)"common_commStatus_getEventFailed", (Object[])new Object[0]) + "...</font><br/>");
        } else if (ret == 1) {
            this.progressCache.finishProcess("<font color='#E57A14'>" + I18nUtil.i18nCode((String)"common_progress_busyFailed", (Object[])new Object[0]) + "</font><br/>");
        }
        return null;
    }

    @RequiresPermissions(value={"psg:device:syncTime"})
    @LogRequest(module="psg_module", object="common_leftMenu_device", opType="common_dev_syncTime", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg syncTime(String devIds) {
        List psgDeviceItemList;
        if (StringUtils.isNotBlank((CharSequence)devIds) && (psgDeviceItemList = this.psgDeviceService.getItemByIds(devIds)) != null && !psgDeviceItemList.isEmpty()) {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            StringBuffer cmdIdBuf = new StringBuffer();
            HashMap<String, String> getAliasBySnMap = new HashMap<String, String>();
            PsgDeviceItem dev = null;
            int len = psgDeviceItemList.size();
            for (int i = 0; i < len; ++i) {
                dev = (PsgDeviceItem)psgDeviceItemList.get(i);
                getAliasBySnMap.put(dev.getSn(), dev.getAlias());
                int total = (int)((double)(i + 1) * 0.5 / (double)psgDeviceItemList.size() * 100.0);
                cmdIdBuf.append(this.psgDeviceService.syncTime(dev.getSn())).append(",");
                this.progressCache.setProcess(new ProcessBean(100, total, dev.getAlias() + " : " + I18nUtil.i18nCode((String)"common_dev_cmdSendSucceed", (Object[])new Object[0]) + "...<br/>"));
            }
            this.progressCache.setProcess(new ProcessBean(10, 50, I18nUtil.i18nCode((String)"common_dev_syncTime", (Object[])new Object[0]) + "...<br/>"));
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        }
        return null;
    }

    public ZKResultMsg checkPwd(String oldCommPwd, String devId) {
        PsgDeviceItem tempDevice;
        ZKResultMsg resultMsg = new ZKResultMsg();
        boolean isExist = false;
        if (StringUtils.isNotBlank((CharSequence)oldCommPwd) && StringUtils.isNotBlank((CharSequence)devId) && (tempDevice = this.psgDeviceService.getItemById(devId)) != null && (tempDevice.getCommPwd() == null || oldCommPwd.equals(tempDevice.getCommPwd()) || oldCommPwd.equals(""))) {
            isExist = true;
        }
        resultMsg.setData((Object)isExist);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"psg:device:updateCommPwd"})
    @LogRequest(module="psg_module", object="common_leftMenu_device", opType="common_dev_modifyCommPwd", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg updateCommPwd(String devId, String newCommPwd) {
        Map resultMap;
        PsgDeviceItem device = this.psgDeviceService.getItemById(devId);
        int ret = -1;
        Long cmdId = this.psgDeviceService.updateCommPwd(devId, newCommPwd);
        if (cmdId != null && cmdId > 0L && Objects.nonNull(resultMap = this.psgDeviceService.getCmdResultById(cmdId, 20))) {
            ret = Integer.parseInt((String)resultMap.get("result"));
        }
        if (ret < 0) {
            throw new ZKBusinessException("400", "common_op_failed");
        }
        device.setCommPwd(newCommPwd);
        this.psgDeviceService.updateItemByParam(device);
        this.psgDeviceService.updateAdmsDeviecPwd(device.getSn(), newCommPwd);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    public ZKResultMsg isExistsIp(String id, String ipAddress) {
        boolean isExist = true;
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            isExist = this.psgDeviceService.isExistsIp(id, ipAddress);
        }
        resultMsg.setData((Object)isExist);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"psg:device:updateIpAddr"})
    @LogRequest(module="psg_module", object="common_leftMenu_device", opType="common_dev_modifyIPAddress", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg updateIpAddr(String devId, String ipAddress, String subnetMask, String gateway) {
        Map resultMap;
        ZKResultMsg resultMsg = new ZKResultMsg();
        int result = -1;
        PsgDeviceItem device = this.psgDeviceService.getItemById(devId);
        Long updateIpAddrCmdId = this.psgDeviceService.updateIpAddr(devId, ipAddress, subnetMask, gateway);
        if (updateIpAddrCmdId != null && updateIpAddrCmdId > 0L && Objects.nonNull(resultMap = this.psgDeviceService.getCmdResultById(updateIpAddrCmdId, 20))) {
            result = Integer.parseInt((String)resultMap.get("result"));
        }
        if (result < 0) {
            throw new ZKBusinessException("400", "common_op_failed");
        }
        device.setIpAddress(ipAddress);
        device.setSubnetMask(subnetMask);
        device.setGateway(gateway);
        this.psgDeviceService.updateItemByParam(device);
        this.psgDeviceService.updateAdmsDevIpAddr(device.getSn(), ipAddress, subnetMask, gateway);
        this.psgDeviceService.rebootDevice((List)Lists.newArrayList((Object[])new String[]{devId}), false);
        resultMsg.setMsg("psg_dev_rebootAfterOperate");
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"psg:device:updateMThreshold"})
    @LogRequest(module="psg_module", object="common_leftMenu_device", opType="common_dev_modifyFPThreshold", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg updateMThreshold(String devId, String mThreshold) {
        Long cmdId;
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)devId) && StringUtils.isNotBlank((CharSequence)mThreshold) && (cmdId = this.psgDeviceService.updateMThreshold(devId, mThreshold)) != null && cmdId > 0L) {
            Map resultMap = this.psgDeviceService.getCmdResultById(cmdId, 20);
            if (Objects.nonNull(resultMap)) {
                Integer ret = Integer.valueOf((String)resultMap.get("result"));
                if (ret < 0) {
                    String failedInfo = this.psgBaseDictionaryService.getCommReason(ret.intValue());
                    failedInfo = StringUtils.isNotBlank((CharSequence)failedInfo) ? I18nUtil.i18nCode((String)failedInfo, (Object[])new Object[0]) : ret.toString();
                    String msgStr = I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + I18nUtil.i18nCode((String)"common_dev_errorCode", (Object[])new Object[0]) + ":" + failedInfo;
                    throw new ZKBusinessException("400", msgStr);
                }
                this.psgDeviceOptionService.setDevOptValByName(devId, "MThreshold", mThreshold);
                this.psgDeviceService.rebootDevice((List)Lists.newArrayList((Object[])new String[]{devId}), false);
                resultMsg.setMsg("psg_dev_rebootAfterOperate");
            } else {
                throw new ZKBusinessException("400", I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]));
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"psg:device:setRegistrationDevice"})
    public ModelAndView getDevIdsBySetRegistrationDevice(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            PsgDeviceItem psgDeviceItem = this.psgDeviceService.getItemById(ids);
            if (psgDeviceItem.getMachineType() != 101 || Short.valueOf(psgDeviceItem.getCommType()) != 3) {
                this.request.setAttribute("failedReason", (Object)PsgConstants.DEV_NOT_SUPPORT_FEATURE);
                return new ModelAndView("psg/device/opDevNotSupportFeatureTips");
            }
            this.request.setAttribute("isRegistrationDevice", (Object)psgDeviceItem.getIsRegistrationDevice());
            this.request.setAttribute("alias", (Object)psgDeviceItem.getAlias());
            this.request.setAttribute("editPage", (Object)true);
            this.request.setAttribute("devId", (Object)ids);
            return new ModelAndView("psg/device/opPsgSetRegistrationDevice");
        }
        return null;
    }

    @RequiresPermissions(value={"psg:device:setRegistrationDevice"})
    @LogRequest(module="psg_module", object="common_leftMenu_device", opType="psg_dev_setRegistrationDevice", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg setRegistrationDevice(String devId, String isRegistrationSel) {
        if (StringUtils.isNotBlank((CharSequence)devId) && StringUtils.isNotBlank((CharSequence)isRegistrationSel)) {
            boolean isRegist = Boolean.valueOf(isRegistrationSel);
            this.psgDeviceService.setRegistrationDevice(devId, isRegist);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"psg:device:queryDevUsage"})
    @LogRequest(module="psg_module", object="common_leftMenu_device", opType="psg_dev_queryDevVolume", requestParams={"alias"}, opContent="common_dev_name")
    public ModelAndView queryDevUsage(String ids) {
        List retList = this.psgDeviceService.queryDevUsage(ids);
        this.request.setAttribute("retList", (Object)retList);
        StringBuffer devIds = new StringBuffer();
        for (List list : retList) {
            if (list.get(7) == null || list.get(7) != "") continue;
            devIds.append((String)list.get(6) + ",");
        }
        if (devIds.length() > 0) {
            this.request.setAttribute("devIds", (Object)devIds.substring(0, devIds.length() - 1));
        } else {
            this.request.setAttribute("getAll", (Object)"disabled='disabled'");
        }
        return new ModelAndView("psg/device/opPsgQueryDevUsage");
    }

    public ZKResultMsg getDevUsage(String devId) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        JSONObject retObject = new JSONObject();
        JSONObject userJson = new JSONObject();
        JSONObject fingerJson = new JSONObject();
        JSONObject fvJson = new JSONObject();
        JSONObject faceJson = new JSONObject();
        JSONObject palmJson = new JSONObject();
        retObject.put("id", (Object)devId);
        PsgDeviceItem dev = this.psgDeviceService.getItemById(devId);
        Map cmdMap = this.psgDeviceService.getDevUserAndTempCounts(devId);
        String fingerVersion = this.psgDeviceOptionService.getValueByNameAndDevSn(dev.getSn(), "~ZKFPVersion");
        boolean supportFinger = this.psgDeviceOptionService.isSupportFun(dev.getSn(), "FingerFunOn");
        for (String key : cmdMap.keySet()) {
            Integer ret;
            Map resultMap;
            String[] cmdIdKey = key.split("_");
            Long cmdId = (Long)cmdMap.get(key);
            if (cmdId <= 0L || !Objects.nonNull(resultMap = this.psgDeviceService.getCmdResultById(cmdId, 20)) || (ret = Integer.valueOf((String)resultMap.get("result"))) < 0) continue;
            if ("".equals(this.psgDeviceService.getQueryData("IS_ERROR_USER"))) {
                JSONObject dataCountJson = null;
                if (!"".equals(this.psgDeviceService.getQueryData("psg:dataCount:" + cmdId))) {
                    dataCountJson = JSONObject.parseObject((String)this.psgDeviceService.getQueryData("psg:dataCount:" + cmdId));
                    if (dataCountJson.containsKey((Object)"user")) {
                        String maxUserCountOpt = this.psgDeviceOptionService.getValueByNameAndDevSn(dev.getSn(), "~MaxUserCount");
                        int maxUserCount = Integer.parseInt(!"0".equals(maxUserCountOpt) ? maxUserCountOpt : (Short.valueOf(dev.getCommType()) == 3 ? "90" : "300"));
                        userJson.put(devId, (Object)(dataCountJson.get((Object)"user").toString() + "/" + maxUserCount * 100));
                        if (!supportFinger) {
                            fingerJson.put(devId, (Object)"false");
                        }
                        if (!this.psgDeviceOptionService.isSupportFun(dev.getSn(), "FvFunOn")) {
                            fvJson.put(devId, (Object)"false");
                        }
                        if (!this.psgDeviceOptionService.isSupportFun(dev.getSn(), "FaceFunOn")) {
                            faceJson.put(devId, (Object)"false");
                        }
                        if (!this.psgDeviceOptionService.isSupportFun(dev.getSn(), "PvFunOn")) {
                            palmJson.put(devId, (Object)"false");
                        }
                    } else if (dataCountJson.containsKey((Object)"templatev10") || dataCountJson.containsKey((Object)"biodata") && cmdIdKey.length > 1 && BaseConstants.BaseBioType.FP_BIO_TYPE == Short.parseShort(cmdIdKey[1])) {
                        String maxFingerCountOpt = this.psgDeviceOptionService.getValueByNameAndDevSn(dev.getSn(), "~MaxFingerCount");
                        int maxFingerCount = Integer.parseInt(!"0".equals(maxFingerCountOpt) ? maxFingerCountOpt : "30");
                        if ("12".equals(fingerVersion)) {
                            fingerJson.put(devId, (Object)(dataCountJson.get((Object)"biodata").toString() + "/" + maxFingerCount * 100));
                        } else {
                            fingerJson.put(devId, (Object)(dataCountJson.get((Object)"templatev10").toString() + "/" + maxFingerCount * 100));
                        }
                    } else if (dataCountJson.containsKey((Object)"fvtemplate")) {
                        String maxFvCountOpt = this.psgDeviceOptionService.getValueByNameAndDevSn(dev.getSn(), "~MaxFvCount");
                        int maxFvCount = Integer.parseInt(!"0".equals(maxFvCountOpt) ? maxFvCountOpt : "10");
                        fvJson.put(devId, (Object)(dataCountJson.get((Object)"fvtemplate").toString() + "/" + maxFvCount * 100));
                    } else if (dataCountJson.containsKey((Object)"biophoto")) {
                        String maxBiophotoCountOpt = this.psgDeviceOptionService.getValueByNameAndDevSn(dev.getSn(), "~MaxBioPhotoCount");
                        int maxBiophotoCount = Integer.parseInt(!"0".equals(maxBiophotoCountOpt) ? maxBiophotoCountOpt : "1500");
                        faceJson.put(devId, (Object)(dataCountJson.get((Object)"biophoto").toString() + "/" + maxBiophotoCount));
                    } else if (dataCountJson.containsKey((Object)"facev7")) {
                        String maxFaceCountOpt = this.psgDeviceOptionService.getValueByNameAndDevSn(dev.getSn(), "~MaxFaceCount");
                        int maxFaceCount = Integer.parseInt(!"0".equals(maxFaceCountOpt) ? maxFaceCountOpt : "1500");
                        faceJson.put(devId, (Object)(dataCountJson.get((Object)"facev7").toString() + "/" + maxFaceCount));
                    } else if (dataCountJson.containsKey((Object)"biodata") && cmdIdKey.length > 1 && BaseConstants.BaseBioType.PALM_BIO_TYPE == Short.parseShort(cmdIdKey[1])) {
                        String maxPalmCountOpt = this.psgDeviceOptionService.getValueByNameAndDevSn(dev.getSn(), "~MaxPvCount");
                        int maxPalmCount = Integer.parseInt(!"0".equals(maxPalmCountOpt) ? maxPalmCountOpt : "300");
                        palmJson.put(devId + "", (Object)(dataCountJson.get((Object)"biodata").toString() + "/" + maxPalmCount));
                    }
                    this.psgDeviceService.delQueryData("psg:dataCount:" + cmdId);
                }
                this.psgDeviceService.delQueryData("SUM_RECORD_USER");
            }
            this.psgDeviceService.delQueryData("IS_ERROR_USER");
        }
        retObject.put("user", (Object)userJson);
        retObject.put("finger", (Object)fingerJson);
        retObject.put("fv", (Object)fvJson);
        retObject.put("face", (Object)faceJson);
        retObject.put("palm", (Object)palmJson);
        resultMsg.setData((Object)retObject);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"psg:device:upgradeFirmware"})
    public ModelAndView getDevIdsByUpgradeFirmware(String type, String checkOffline, String ids) {
        if (type != null && !type.isEmpty()) {
            List list = this.psgDeviceService.getItemByIds(ids);
            HashMap<String, String> devNameMap = new HashMap<String, String>(16);
            StringBuffer disabledDevName = new StringBuffer("");
            StringBuffer offlineDevName = new StringBuffer("");
            StringBuffer supportDevFun = new StringBuffer("");
            PsgDeviceItem dev = null;
            StringBuffer retIds = new StringBuffer();
            for (int i = 0; i < list.size(); ++i) {
                String value;
                String name;
                dev = (PsgDeviceItem)list.get(i);
                if (String.valueOf(1).equals(this.psgDeviceService.getStatus(dev.getSn()))) {
                    value = name = dev.getDeviceName();
                    retIds.append(dev.getId()).append(",");
                    devNameMap.put(name, value);
                    continue;
                }
                if (String.valueOf(2).equals(this.psgDeviceService.getStatus(dev.getSn()))) {
                    disabledDevName.append(dev.getAlias()).append(",");
                } else if (StringUtils.isNotBlank((CharSequence)checkOffline)) {
                    value = name = dev.getDeviceName();
                    devNameMap.put(name, value);
                } else {
                    offlineDevName.append(dev.getAlias()).append(",");
                }
                list.remove(i);
                --i;
            }
            StringBuffer devName = new StringBuffer("");
            boolean isNeed = false;
            for (String key : devNameMap.keySet()) {
                devName.append((String)devNameMap.get(key)).append(":");
                int innerLen = list.size();
                for (int j = 0; j < innerLen; ++j) {
                    if (!Pattern.compile(key).matcher(((PsgDeviceItem)list.get(j)).getDeviceName()).find() && !key.equals(((PsgDeviceItem)list.get(j)).getDeviceName()) || !String.valueOf(1).equals(this.psgDeviceService.getStatus(((PsgDeviceItem)list.get(j)).getSn()))) continue;
                    isNeed = true;
                    devName.append(((PsgDeviceItem)list.get(j)).getAlias() + "&" + ((PsgDeviceItem)list.get(j)).getId()).append(",");
                }
                if (isNeed) {
                    devName.append(";");
                    continue;
                }
                if (devName.indexOf(";") < 0) {
                    devName = new StringBuffer("");
                    continue;
                }
                devName.substring(0, devName.lastIndexOf(";") - 1);
            }
            this.request.setAttribute("retIds", (Object)(retIds.toString().equals("") ? "" : retIds.substring(0, retIds.length() - 1)));
            this.request.setAttribute("devicesName", (Object)(devName.toString().equals("") ? "" : devName.substring(0, devName.length() - 1)));
            this.request.setAttribute("disabledDevName", (Object)(disabledDevName.toString().equals("") ? "" : disabledDevName.substring(0, disabledDevName.length() - 1)));
            this.request.setAttribute("offlineDevName", (Object)(offlineDevName.toString().equals("") ? "" : offlineDevName.substring(0, offlineDevName.length() - 1)));
            this.request.setAttribute("supportDevFun", (Object)(supportDevFun.toString().equals("") ? "" : supportDevFun.substring(0, supportDevFun.toString().length() - 1)));
            if (StringUtils.isNotBlank((CharSequence)checkOffline)) {
                this.request.setAttribute("checkOffline", (Object)checkOffline);
            }
            if ("upgradeFirmware".equals(type)) {
                return new ModelAndView("psg/device/opPsgUpgradeFirmware");
            }
            if ("upgradeLCDFirmware".equals(type)) {
                return new ModelAndView("psg/device/opPsgUpgradeLCDFirmware");
            }
        }
        return null;
    }

    public ZKResultMsg grantAuthority(PsgSearchAddDeviceItem item) {
        if (StringUtils.isNotBlank((CharSequence)item.getClearAllData())) {
            item.setClearAllData("true");
        }
        this.psgDeviceService.grantAuthority(item);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    public ZKResultMsg checkPinLenAndCardLen(String commTypeVal, String maxMCUCardBits) {
        String pinLen = this.psgParamService.getParamValByName("pers.pinLen");
        String cardLen = this.psgParamService.getParamValByName("pers.cardLen");
        String pinSupportLetter = this.psgParamService.getParamValByName("pers.pinSupportLetter");
        if (Integer.parseInt(maxMCUCardBits) < Integer.parseInt(cardLen)) {
            throw new ZKBusinessException(I18nUtil.i18nCode((String)"common_dev_beyondCardLen", (Object[])new Object[]{maxMCUCardBits}));
        }
        if ((commTypeVal.equals("1") || commTypeVal.equals("2")) && (Integer.parseInt(pinLen) > 9 || pinSupportLetter.equals("true"))) {
            throw new ZKBusinessException(I18nUtil.i18nCode((String)"common_dev_deviceNotSupportPin", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"psg:device:upgradeFirmware"})
    public ZKResultMsg upgradeFirmware(String devIds, MultipartFile devFile, String upgradeType, String devRadio) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)devIds) && StringUtils.isNotBlank((CharSequence)upgradeType)) {
            String ret = "ok";
            try {
                this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>");
                List deviceItemList = this.psgDeviceService.getItemByIds(devIds);
                this.progressCache.setProcess(new ProcessBean(100, 0, "<font color='black'>" + I18nUtil.i18nCode((String)"psg_dev_transferFilesTip", (Object[])new Object[0]) + "...</font><br/>"));
                File filePath = null;
                if (devFile.getName() != null && devFile != null) {
                    String fileName = "";
                    switch (upgradeType) {
                        case "device": {
                            fileName = DEV_UPGRADEFIRMWARE_FILENAME;
                            break;
                        }
                        case "reader": {
                            fileName = READER_UPGRADEFIRMWARE_FILENAME;
                        }
                    }
                    filePath = this.saveFile(devFile, fileName, devRadio);
                }
                this.progressCache.setProcess(new ProcessBean(100, 45, "<font color='black'>" + I18nUtil.i18nCode((String)"common_dev_fileUploadSuccess", (Object[])new Object[0]) + "...</font><br/>"));
                List cmdIdList = this.psgDeviceService.upgradeFirmware(devIds, filePath, "localhost", this.serverPort);
                this.progressCache.setProcess(new ProcessBean(100, 50, "<font color='black'>" + I18nUtil.i18nCode((String)"common_dev_cmdSendSucceed", (Object[])new Object[0]) + "," + I18nUtil.i18nCode((String)"common_dev_upgrade", (Object[])new Object[0]) + "...</font><br/>"));
                if (StringUtils.isNotBlank((CharSequence)upgradeType) && !upgradeType.equals("device")) {
                    String string = I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
                    return string;
                }
                ArrayList<PsgDeviceItem> successDevList = new ArrayList<PsgDeviceItem>();
                ArrayList<String> devIdList = new ArrayList<String>();
                for (int index = 0; index < cmdIdList.size(); ++index) {
                    long cmdId = (Long)cmdIdList.get(index);
                    Map resultMap = this.psgDeviceService.getCmdResultById(Long.valueOf(cmdId), 600);
                    if (!Objects.nonNull(resultMap)) continue;
                    int total = 50 / deviceItemList.size() * (index + 1) + 30;
                    Integer result = Integer.parseInt((String)resultMap.get("result"));
                    PsgDeviceItem dev = this.psgDeviceService.getItemByDevSn((String)resultMap.get("sn"));
                    if (result >= 0) {
                        this.progressCache.setProcess(new ProcessBean(70, total, "<font color='black'>" + dev.getAlias() + ":" + I18nUtil.i18nCode((String)"common_dev_upgradeSuccess", (Object[])new Object[0]) + "," + I18nUtil.i18nCode((String)"common_dev_reboot", (Object[])new Object[0]) + "...</font><br/>"));
                        PsgDeviceItem psgDev = (PsgDeviceItem)deviceItemList.get(index);
                        successDevList.add(dev);
                        devIdList.add(dev.getId());
                        continue;
                    }
                    String failedInfo = this.psgBaseDictionaryService.getCommReason(result.intValue());
                    failedInfo = StringUtils.isNotBlank((CharSequence)failedInfo) ? I18nUtil.i18nCode((String)failedInfo, (Object[])new Object[0]) : result.toString();
                    this.progressCache.setProcess(new ProcessBean(total + 20, total + 20, "<font color='red'>" + dev.getAlias() + ":" + I18nUtil.i18nCode((String)"common_dev_upgradeFail", (Object[])new Object[0]) + "," + I18nUtil.i18nCode((String)"common_dev_errorCode", (Object[])new Object[0]) + ":" + failedInfo + "...</font><br/>"));
                }
                if (devIdList.size() > 0) {
                    this.psgDeviceService.rebootDevice(devIdList, true);
                }
                if (successDevList.size() > 0) {
                    int count = 5;
                    for (int i = 1; i <= count; ++i) {
                        if (i == 12) {
                            this.progressCache.setProcess(new ProcessBean(70 + i, 70 + i, "<font color='black'>...</font><br/>"));
                            break;
                        }
                        if (i == 1) {
                            this.progressCache.setProcess(new ProcessBean(70 + i, 70 + i, "<font color='black'>" + I18nUtil.i18nCode((String)"common_devOpType_connect", (Object[])new Object[0]) + "...</font><br/>"));
                            this.progressCache.setProcess(new ProcessBean(70 + i, 70 + i, I18nUtil.i18nCode((String)"common_dev_dealTimeout", (Object[])new Object[]{3 + I18nUtil.i18nCode((String)"common_minutes", (Object[])new Object[0])}) + "<br/>"));
                        } else {
                            this.progressCache.setProcess(new ProcessBean(70 + i, 70 + i));
                            if (Short.parseShort(this.psgDeviceService.getStatus(((PsgDeviceItem)deviceItemList.get(0)).getSn())) != 1) {
                                ++count;
                            }
                        }
                        Thread.sleep(15000L);
                    }
                    for (PsgDeviceItem dev : successDevList) {
                        this.progressCache.setProcess(new ProcessBean(85, 85, "<font color='black'>" + dev.getAlias() + ":" + I18nUtil.i18nCode((String)"common_devOpType_dataUpdate", (Object[])new Object[0]) + "...</font><br/>"));
                        int optionCount = 3;
                        for (int i = 1; i < optionCount; ++i) {
                            this.psgDeviceService.getOptFromDev(dev.getSn(), i);
                        }
                        this.progressCache.setProcess(new ProcessBean(90, 90, "<font color='black'>" + dev.getAlias() + ":" + I18nUtil.i18nCode((String)"common_dev_upgradeSuccess", (Object[])new Object[0]) + "</font><br/>"));
                    }
                }
            }
            catch (Exception e) {
                ret = "error";
                resultMsg.setRet(ret);
                resultMsg.setMsg("common_dev_upgradeFail");
                log.error("exception", (Throwable)e);
            }
            finally {
                if (ret.equals("error")) {
                    this.progressCache.finishProcess("<font color='red'>" + I18nUtil.i18nCode((String)"common_dev_upgradeFail", (Object[])new Object[0]) + "...</font><br/>");
                } else {
                    this.progressCache.finishProcess("<font color='black'>" + I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "</font><br/>");
                }
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"psg:device:setTimeZone"})
    public ModelAndView getDevIdsBySetTimeZone(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List psgDeviceItemList = this.psgDeviceService.getItemByIds(ids);
            StringBuffer devName = new StringBuffer("");
            StringBuffer disabledDevName = new StringBuffer("");
            StringBuffer warnInfoDevName = new StringBuffer("");
            StringBuffer noSupportDevName = new StringBuffer("");
            ArrayList timeZoneKeyList = Lists.newArrayList();
            StringBuffer devIds = new StringBuffer();
            HashMap tzNameMap = Maps.newHashMap();
            psgDeviceItemList.stream().forEach(dev -> {
                String status = this.psgDeviceService.getStatus(dev.getSn());
                if (!String.valueOf(2).equals(status)) {
                    if (this.psgDeviceOptionService.isSupportFun(dev.getSn(), "TZAdj")) {
                        devIds.append(dev.getId()).append(",");
                        String tzVal = dev.getTimeZone();
                        if (StringUtils.isNotBlank((CharSequence)tzVal)) {
                            String tzKey = this.getTZKeyByVal(tzVal);
                            if (!timeZoneKeyList.contains(tzVal)) {
                                timeZoneKeyList.add(tzVal);
                            }
                            if (tzNameMap.containsKey(tzKey)) {
                                ((StringBuffer)tzNameMap.get(tzKey)).append(dev.getAlias() + "&" + dev.getId() + ",");
                            } else {
                                StringBuffer dstNameBuf = new StringBuffer(tzKey + ":" + dev.getAlias() + "&" + dev.getId() + ",");
                                tzNameMap.put(tzKey, dstNameBuf);
                            }
                        } else {
                            String tzNotSet = I18nUtil.i18nCode((String)"psg_dev_notSetDst", (Object[])new Object[0]);
                            if (tzNameMap.containsKey(tzNotSet)) {
                                ((StringBuffer)tzNameMap.get(tzNotSet)).append(dev.getAlias() + "&" + dev.getId() + ",");
                            } else {
                                StringBuffer tzNameBuf = new StringBuffer(tzNotSet + ":" + dev.getAlias() + "&" + dev.getId() + ",");
                                tzNameMap.put(tzNotSet, tzNameBuf);
                            }
                        }
                    } else {
                        noSupportDevName.append(dev.getAlias()).append(",");
                    }
                } else {
                    disabledDevName.append(dev.getAlias()).append(",");
                }
            });
            tzNameMap.forEach((k, v) -> devName.append(v.substring(0, v.length() - 1) + ";"));
            this.request.setAttribute("timeZoneKey", devName.length() > 0 ? (timeZoneKeyList.size() > 0 ? timeZoneKeyList.get(0) : "+0800") : "");
            this.request.setAttribute("devIds", devIds.length() > 0 ? devIds.substring(0, devIds.length() - 1) : null);
            this.request.setAttribute("devicesName", devName.length() > 0 ? devName.substring(0, devName.length() - 1) : null);
            this.request.setAttribute("disabledDevName", disabledDevName.length() > 0 ? disabledDevName.substring(0, disabledDevName.length() - 1) : null);
            this.request.setAttribute("warnInfoDevName", warnInfoDevName.length() > 0 ? warnInfoDevName.substring(0, warnInfoDevName.length() - 1) : null);
            this.request.setAttribute("noSupportDevName", noSupportDevName.length() > 0 ? noSupportDevName.substring(0, noSupportDevName.length() - 1) : null);
            return new ModelAndView("psg/device/opPsgDevSetTimeZone");
        }
        return null;
    }

    @RequiresPermissions(value={"psg:device:setTimeZone"})
    @LogRequest(module="psg_module", object="common_leftMenu_device", opType="psg_dev_setTimeZone", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg setTimeZone(String devIds, String timeZone) {
        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
        List psgDeviceItemList = this.psgDeviceService.getItemByIds(devIds);
        int size = psgDeviceItemList.size();
        PsgDeviceItem dev = null;
        for (int i = 0; i < size; ++i) {
            dev = (PsgDeviceItem)psgDeviceItemList.get(i);
            int total = (int)((float)(i + 1) / (float)size * 100.0f);
            int lastTotal = (int)(((double)i + 0.3) / (double)size * 100.0);
            this.progressCache.setProcess(new ProcessBean(30, lastTotal, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"psg_dev_timeZoneSetting", (Object[])new Object[0]) + "<br/>"));
            this.psgDeviceService.setDeviceTimeZoneToDev(dev, timeZone);
            this.progressCache.setProcess(new ProcessBean(100, total, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"psg_dev_timeZoneCmdSuccess", (Object[])new Object[0]) + "<br/>"));
        }
        this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ModelAndView getDevIdsBySetDstimeSortByDstime(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            StringBuffer devName = new StringBuffer("");
            StringBuffer disabledDevName = new StringBuffer("");
            StringBuffer noSupportDevName = new StringBuffer("");
            StringBuffer warnInfoDevName = new StringBuffer("");
            StringBuffer devIds = new StringBuffer();
            List psgDeviceItemLists = this.psgDeviceService.getItemByIds(ids);
            HashMap dstNameMap = Maps.newHashMap();
            psgDeviceItemLists.stream().forEach(dev -> {
                String status = this.psgDeviceService.getStatus(dev.getSn());
                if (!String.valueOf(2).equals(status)) {
                    if (this.psgDeviceOptionService.isSupportDevParam(dev.getSn(), "DSTFunOn") || this.psgDeviceOptionService.isSupportDevParam(dev.getSn(), "~DSTF")) {
                        String devDSTimeName;
                        devIds.append(dev.getId()).append(",");
                        String string = devDSTimeName = StringUtils.isNotBlank((CharSequence)dev.getPsgDSTimeId()) ? this.psgDSTimeService.getItemById(dev.getPsgDSTimeId()).getName() : null;
                        if (devDSTimeName == null) {
                            String dstNotSet = I18nUtil.i18nCode((String)"psg_dev_notSetDst", (Object[])new Object[0]);
                            if (dstNameMap.containsKey(dstNotSet)) {
                                ((StringBuffer)dstNameMap.get(dstNotSet)).append(dev.getAlias() + "&" + dev.getId() + ",");
                            } else {
                                StringBuffer dstNameBuf = new StringBuffer(dstNotSet + ":" + dev.getAlias() + "&" + dev.getId() + ",");
                                dstNameMap.put(dstNotSet, dstNameBuf);
                            }
                        } else {
                            String dstKey = devDSTimeName + "-" + dev.getPsgDSTimeId();
                            if (dstNameMap.containsKey(dstKey)) {
                                ((StringBuffer)dstNameMap.get(dstKey)).append(dev.getAlias() + "&" + dev.getId() + ",");
                            } else {
                                StringBuffer dstNameBuf = new StringBuffer(dstKey + ":" + dev.getAlias() + "&" + dev.getId() + ",");
                                dstNameMap.put(dstKey, dstNameBuf);
                            }
                        }
                    } else {
                        noSupportDevName.append(dev.getAlias()).append(",");
                    }
                } else {
                    disabledDevName.append(dev.getAlias()).append(",");
                }
            });
            dstNameMap.forEach((k, v) -> devName.append(v.substring(0, v.length() - 1) + ";"));
            this.request.setAttribute("devIds", devIds.length() > 0 ? devIds.substring(0, devIds.length() - 1) : null);
            this.request.setAttribute("devicesName", devName.length() > 0 ? devName.substring(0, devName.length() - 1) : null);
            this.request.setAttribute("disabledDevName", disabledDevName.length() > 0 ? disabledDevName.substring(0, disabledDevName.length() - 1) : null);
            this.request.setAttribute("warnInfoDevName", warnInfoDevName.length() > 0 ? warnInfoDevName.substring(0, warnInfoDevName.length() - 1) : null);
            this.request.setAttribute("noSupportDevName", noSupportDevName.length() > 0 ? noSupportDevName.substring(0, noSupportDevName.length() - 1) : null);
            return new ModelAndView("psg/device/opPsgDevSetDstime");
        }
        return null;
    }

    private String getTZKeyByVal(String tzVal) {
        int tempNum = Integer.parseInt(tzVal);
        String deliveryVal = "";
        if (tempNum % 100 != 0) {
            deliveryVal = Math.abs(tempNum % 100) + "";
        }
        return "UTC" + tzVal.substring(0, 1) + Math.abs(tempNum / 100) + deliveryVal + "_" + tzVal;
    }

    private String getKeyValue(String keyName, MultipartFile devFile) {
        String retVal = "";
        try {
            InputStream inputStre = devFile.getInputStream();
            Properties pro = new Properties();
            pro.load(inputStre);
            String keyVal = (String)pro.get(keyName);
            if (keyVal != null) {
                retVal = keyVal;
            }
            inputStre.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    private File saveFile(MultipartFile devFile, String fileName, String fileType) throws Exception {
        File file;
        String realPath = this.systemFilePath + "/upload/psg/fireware/" + fileType.toLowerCase();
        File tempFile = new File(realPath);
        if (!tempFile.isAbsolute()) {
            realPath = ClassUtil.getRootPath() + "/" + realPath;
            tempFile = new File(realPath);
        }
        if (!tempFile.exists()) {
            tempFile.mkdirs();
        }
        if ((file = new File(realPath + "/" + fileName)).exists()) {
            file.delete();
        }
        devFile.transferTo(file);
        return file;
    }

    public ZKResultMsg checkDevExist() {
        int count = this.psgDeviceService.getByCondition(new PsgDeviceItem()).size();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)count));
    }

    public ZKResultMsg getDevTreeJson(String type, String getDstime) {
        boolean getTime = StringUtils.isNotBlank((CharSequence)getDstime);
        JSONObject devsJson = new JSONObject();
        devsJson.put("id", (Object)0);
        JSONArray devJsonArray = new JSONArray();
        PsgDeviceItem psgDeviceItem = new PsgDeviceItem();
        String areaIds = this.psgDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)areaIds)) {
            psgDeviceItem.setAreaIdIn(areaIds);
        }
        List psgDeviceItemList = this.psgDeviceService.getByCondition(psgDeviceItem);
        JSONObject devInfoJson = null;
        for (PsgDeviceItem dev : psgDeviceItemList) {
            if (getTime) {
                if (!this.psgDeviceOptionService.isSupportFun(dev.getSn(), "DSTFunOn") && !this.psgDeviceOptionService.isSupportFun(dev.getSn(), "~DSTF")) continue;
                devInfoJson = new JSONObject();
                devInfoJson.put("id", (Object)dev.getId());
                devInfoJson.put("text", (Object)dev.getAlias());
                devInfoJson.put("open", (Object)1);
                devJsonArray.add((Object)devInfoJson);
                continue;
            }
            devInfoJson = new JSONObject();
            devInfoJson.put("id", (Object)dev.getId());
            devInfoJson.put("text", (Object)dev.getAlias());
            devInfoJson.put("open", (Object)1);
            devJsonArray.add((Object)devInfoJson);
        }
        if (type != null && type.equals("all")) {
            if (devJsonArray.size() > 0) {
                JSONObject childJson = new JSONObject();
                JSONArray childArray = new JSONArray();
                childJson.put("id", (Object)"-1");
                childJson.put("open", (Object)"1");
                childJson.put("text", (Object)I18nUtil.i18nCode((String)"common_all", (Object[])new Object[0]));
                childJson.put("item", (Object)devJsonArray);
                childArray.add((Object)childJson);
                devsJson.put("item", (Object)childArray);
            } else {
                devsJson.put("item", (Object)new JSONArray());
            }
        } else {
            devsJson.put("item", (Object)devJsonArray);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)devsJson));
    }

    public ZKResultMsg setDSTime(String devIds, String dstimeId) {
        if (StringUtils.isNotBlank((CharSequence)devIds)) {
            List psgDeviceItemList = this.psgDeviceService.getItemByIds(devIds);
            PsgDSTimeItem psgDSTimeItem = null;
            if (StringUtils.isNotBlank((CharSequence)dstimeId)) {
                psgDSTimeItem = this.psgDSTimeService.getItemById(dstimeId);
            }
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            int size = psgDeviceItemList.size();
            PsgDeviceItem dev = null;
            for (int i = 0; i < size; ++i) {
                dev = (PsgDeviceItem)psgDeviceItemList.get(i);
                int total = (int)((float)(i + 1) / (float)size * 100.0f);
                int lastTotal = (int)(((double)i + 0.3) / (double)size * 100.0);
                if (psgDSTimeItem != null) {
                    this.progressCache.setProcess(new ProcessBean(30, lastTotal, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"psg_dev_dstSettingTip", (Object[])new Object[0]) + "<br/>"));
                    this.psgDeviceService.setOrDelDST(dev, psgDSTimeItem, "set");
                } else {
                    this.progressCache.setProcess(new ProcessBean(30, lastTotal, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"psg_dev_dstDelTip", (Object[])new Object[0]) + "<br/>"));
                    this.psgDeviceService.setOrDelDST(dev, psgDSTimeItem, "del");
                }
                this.psgDeviceService.saveDSTime(dev, psgDSTimeItem);
                this.progressCache.setProcess(new ProcessBean(100, total, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"psg_dev_dstCmdSuccess", (Object[])new Object[0]) + "<br/>"));
            }
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg isOnlineByDevSn(String devSns) {
        ZKResultMsg zkResultMsg = ZKResultMsg.failMsg();
        if (StringUtils.isNotBlank((CharSequence)devSns)) {
            JSONArray stateArray = new JSONArray();
            ArrayList snList = Lists.newArrayList((Object[])devSns.split(","));
            snList.stream().forEach(sn -> {
                JSONObject devStatus = new JSONObject();
                String status = this.psgDeviceService.getStatus(sn);
                devStatus.put("connectState", (Object)status);
                devStatus.put("sn", sn);
                stateArray.add((Object)devStatus);
            });
            zkResultMsg = ZKResultMsg.successMsg();
            zkResultMsg.setData((Object)stateArray);
        }
        return zkResultMsg;
    }

    public TreeItem getDeviceVerifyModeTree() {
        List verifyModeItemList = this.psgDeviceVerifyModeService.getAllVerifyModeDistinct();
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        for (PsgDeviceVerifyModeItem verifyModeItem : verifyModeItemList) {
            TreeItem item = new TreeItem();
            item.setId(verifyModeItem.getName());
            item.setText(I18nUtil.i18nCode((String)verifyModeItem.getName(), (Object[])new Object[0]));
            item.setParent(new TreeItem("0"));
            items.add(item);
        }
        TreeItem newItem = new TreeItem();
        newItem.setId("common_verifyMode_other");
        newItem.setText(I18nUtil.i18nCode((String)"common_verifyMode_other", (Object[])new Object[0]));
        newItem.setParent(new TreeItem("0"));
        items.add(newItem);
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    @RequiresPermissions(value={"psg:device:setLcdDisplayIn"})
    public ModelAndView getDevIdsBySetLcdDisplay(String ids, String accessType) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            PsgDeviceItem psgDeviceItem = this.psgDeviceService.getItemById(ids);
            String status = this.psgDeviceService.getStatus(psgDeviceItem.getSn());
            if (!status.equals(String.valueOf(1))) {
                this.request.setAttribute("failedReason", (Object)status);
                return new ModelAndView("psg/device/opDevNotSupportFeatureTips");
            }
            String adScreenFunOn = this.psgDeviceOptionService.getValueByNameAndDevId(ids, "ADScreenFunOn");
            String isSupportADScreen = this.psgDeviceOptionService.getValueByNameAndDevId(ids, "IsSupportADScreen");
            if ("0".equals(adScreenFunOn) || "0".equals(isSupportADScreen)) {
                this.request.setAttribute("failedReason", (Object)PsgConstants.DEV_NOT_SUPPORT_FEATURE);
                return new ModelAndView("psg/device/opDevNotSupportFeatureTips");
            }
            this.request.setAttribute("item", (Object)psgDeviceItem);
            this.request.setAttribute("accessType", (Object)accessType);
            if ("zh_CN".equals(LocaleMessageSourceUtil.language)) {
                String playInterval = "";
                if ("0".equals(accessType)) {
                    playInterval = this.psgDeviceOptionService.getValueByNameAndDevSn(psgDeviceItem.getSn(), "InPlayInterval");
                } else if ("1".equals(accessType)) {
                    playInterval = this.psgDeviceOptionService.getValueByNameAndDevSn(psgDeviceItem.getSn(), "OutPlayInterval");
                }
                this.request.setAttribute("playInterval", (Object)playInterval);
                return new ModelAndView("psg/device/opPsgSetLcdDisplayZH");
            }
            return new ModelAndView("psg/device/opPsgSetLcdDisplay");
        }
        return null;
    }

    public ZKResultMsg saveLcdDisplayFiles(String devSn, MultipartFile[] uploadFile, String interval, String areaType, String accessType, String fileType) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        String filePath = "";
        Long currentTime = System.currentTimeMillis();
        if (Objects.nonNull(uploadFile) && uploadFile.length > 0) {
            String fileName = "";
            for (MultipartFile file : uploadFile) {
                fileName = file.getOriginalFilename().toLowerCase();
                if ("1".equals(areaType)) {
                    filePath = "upload/psg/area" + areaType + '/' + currentTime;
                    FileUtil.saveMultipartFile((String)filePath, (String)fileName, (MultipartFile)file, (boolean)false);
                    continue;
                }
                if ("2".equals(areaType)) {
                    filePath = "upload/psg/area" + areaType + '/' + currentTime;
                    FileUtil.saveMultipartFile((String)filePath, (String)fileName, (MultipartFile)file, (boolean)false);
                    continue;
                }
                if (!"3".equals(areaType)) continue;
                filePath = "upload/psg/area" + areaType + '/' + currentTime;
                FileUtil.saveMultipartFile((String)filePath, (String)fileName, (MultipartFile)file, (boolean)false);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("filePath", filePath);
        map.put("currentTime", String.valueOf(currentTime));
        map.put("interval", interval);
        map.put("areaType", areaType);
        map.put("accessType", accessType);
        map.put("fileType", fileType);
        Map dataMap = this.psgDeviceService.setLcdDisplayFiles(devSn, map);
        if (dataMap.containsKey("cmdId") && !"".equals(dataMap.get("cmdId"))) {
            String cmdId = (String)dataMap.get("cmdId");
            Map resultMap = this.psgDeviceService.getCmdResultById(Long.valueOf(Long.parseLong(cmdId)), 300);
            if (Objects.nonNull(resultMap)) {
                Integer result = Integer.valueOf((String)resultMap.get("result"));
                if (result < 0) {
                    String failedInfo = this.psgBaseDictionaryService.getCommReason(result.intValue());
                    failedInfo = StringUtils.isNotBlank((CharSequence)failedInfo) ? I18nUtil.i18nCode((String)failedInfo, (Object[])new Object[0]) : result.toString();
                    resultMsg.setMsg(I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + "," + I18nUtil.i18nCode((String)"common_dev_errorCode", (Object[])new Object[0]) + ":" + failedInfo);
                    resultMsg.setRet("400");
                }
            } else {
                resultMsg.setMsg(I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]));
                resultMsg.setRet("400");
            }
            FileUtils.deleteDirectory((String)FileUtil.getLocalFullPath((String)filePath));
            FileUtils.deleteFile((String)FileUtil.getLocalFullPath((String)(filePath + ".zip")));
        }
        return resultMsg;
    }

    public ZKResultMsg clearLCDAreaFile(String devSn, String accessType, String areaType) {
        ZKResultMsg ret = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)areaType)) {
            ret = this.psgDeviceService.clearLCDAreaFile(devSn, accessType, areaType);
        }
        return ret;
    }

    @RequiresPermissions(value={"psg:device:clearLCDCountArea"})
    @LogRequest(module="psg_module", object="common_leftMenu_device", opType="psg_dev_clearLCDCountArea", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg clearLCDCountArea(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            String offline = "";
            ArrayList<String> devIdList = new ArrayList<String>();
            List psgDeviceItemList = this.psgDeviceService.getItemByIds(ids);
            for (PsgDeviceItem dev : psgDeviceItemList) {
                if (!String.valueOf(1).equals(this.psgDeviceService.getStatus(dev.getSn()))) {
                    offline = offline + dev.getAlias() + I18nUtil.i18nCode((String)"common_dev_offlinePrompt", (Object[])new Object[0]) + ",";
                    continue;
                }
                devIdList.add(dev.getId());
            }
            this.psgDeviceService.clearLCDCountArea(devIdList, false);
            if (StringUtils.isNotBlank((CharSequence)offline)) {
                offline = offline.substring(0, offline.length() - 1);
                throw new ZKBusinessException(offline);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"psg:device:upgradeLCDFirmware"})
    public ZKResultMsg upgradeLCDFirmware(String devIds, MultipartFile upgradeFile, String devRadio) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)devIds)) {
            String ret = "ok";
            try {
                this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>");
                List deviceItemList = this.psgDeviceService.getItemByIds(devIds);
                this.progressCache.setProcess(new ProcessBean(100, 0, "<font color='black'>" + I18nUtil.i18nCode((String)"psg_dev_transferFilesTip", (Object[])new Object[0]) + "...</font><br/>"));
                String filePath = null;
                if (Objects.nonNull(upgradeFile)) {
                    filePath = FileUtil.saveFileToServer((String)"psg", (String)"device/upgrade", (String)upgradeFile.getOriginalFilename(), (MultipartFile)upgradeFile);
                }
                this.progressCache.setProcess(new ProcessBean(100, 45, "<font color='black'>" + I18nUtil.i18nCode((String)"common_dev_fileUploadSuccess", (Object[])new Object[0]) + "...</font><br/>"));
                List cmdIdList = this.psgDeviceService.upgradeLCDFirmware(devIds, filePath);
                this.progressCache.setProcess(new ProcessBean(100, 50, "<font color='black'>" + I18nUtil.i18nCode((String)"common_dev_cmdSendSucceed", (Object[])new Object[0]) + "," + I18nUtil.i18nCode((String)"common_dev_upgrade", (Object[])new Object[0]) + "...</font><br/>"));
                for (int index = 0; index < cmdIdList.size(); ++index) {
                    long cmdId = (Long)cmdIdList.get(index);
                    Map resultMap = this.psgDeviceService.getCmdResultById(Long.valueOf(cmdId), 600);
                    if (Objects.nonNull(resultMap)) {
                        int total = 50 / deviceItemList.size() * (index + 1) + 30;
                        Integer result = Integer.parseInt((String)resultMap.get("result"));
                        PsgDeviceItem dev = this.psgDeviceService.getItemByDevSn((String)resultMap.get("sn"));
                        if (result >= 0) {
                            this.progressCache.setProcess(new ProcessBean(70, total, "<font color='black'>" + dev.getAlias() + ":" + I18nUtil.i18nCode((String)"common_dev_upgradeSuccess", (Object[])new Object[0]) + "...</font><br/>"));
                            continue;
                        }
                        String failedInfo = this.psgBaseDictionaryService.getCommReason(result.intValue());
                        failedInfo = StringUtils.isNotBlank((CharSequence)failedInfo) ? I18nUtil.i18nCode((String)failedInfo, (Object[])new Object[0]) : result.toString();
                        this.progressCache.setProcess(new ProcessBean(total + 20, total + 20, "<font color='red'>" + dev.getAlias() + ":" + I18nUtil.i18nCode((String)"common_dev_upgradeFail", (Object[])new Object[0]) + "," + I18nUtil.i18nCode((String)"common_dev_errorCode", (Object[])new Object[0]) + ":" + failedInfo + "...</font><br/>"));
                        continue;
                    }
                    this.progressCache.finishProcess("<font color='red'>" + I18nUtil.i18nCode((String)"common_dev_upgradeFail", (Object[])new Object[0]) + "," + I18nUtil.i18nCode((String)"common_commStatus_cmdTimeOut", (Object[])new Object[0]) + "...</font><br/>");
                }
            }
            catch (Exception e) {
                ret = "error";
                resultMsg.setRet(ret);
                resultMsg.setMsg("common_dev_upgradeFail");
            }
            finally {
                if ("error".equals(ret)) {
                    this.progressCache.finishProcess("<font color='red'>" + I18nUtil.i18nCode((String)"common_dev_upgradeFail", (Object[])new Object[0]) + "...</font><br/>");
                } else {
                    this.progressCache.finishProcess("<font color='black'>" + I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "</font><br/>");
                }
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }
}

