/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.psg.remote.PsgAuxInRemote;
import com.zkteco.zkbiosecurity.psg.service.PsgAuxInService;
import com.zkteco.zkbiosecurity.psg.service.PsgChannelService;
import com.zkteco.zkbiosecurity.psg.vo.PsgAuxInItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PsgAuxInController
extends BaseController
implements PsgAuxInRemote {
    @Autowired
    private PsgAuxInService psgAuxInService;
    @Autowired
    private PsgChannelService psgChannelService;

    @RequiresPermissions(value={"psg:auxIn"})
    public ModelAndView index() {
        return new ModelAndView("psg/auxIn/psgAuxIn");
    }

    @RequiresPermissions(value={"psg:auxIn:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.psgAuxInService.getItemById(id));
        }
        return new ModelAndView("psg/auxIn/editPsgAuxIn");
    }

    @RequiresPermissions(value={"psg:auxIn:edit"})
    @LogRequest(module="psg_module", object="common_leftMenu_auxIn", opType="common_op_edit", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg save(PsgAuxInItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.psgAuxInService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"psg:auxIn:refresh"})
    public DxGrid list(PsgAuxInItem condition) {
        Pager pager = this.psgAuxInService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"psg:auxIn:del"})
    public ZKResultMsg delete(String ids) {
        this.psgAuxInService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isExist(PsgAuxInItem item) {
        String auxInName = this.request.getParameter("auxInName");
        if (!auxInName.equals(item.getName())) {
            return this.psgAuxInService.isExist(item.getName());
        }
        return true;
    }

    public ModelAndView getChannelByEntityId() {
        String entityId = this.request.getParameter("entityId");
        this.request.setAttribute("entityId", (Object)entityId);
        this.request.setAttribute("entityName", (Object)"PsgAuxIn");
        String channel2EntityIds = this.psgChannelService.getBindChannelIds(Arrays.asList(entityId), "PsgAuxIn");
        this.request.setAttribute("value", (Object)channel2EntityIds);
        return new ModelAndView("psg/auxIn/psgAuxInSelectChannelContent");
    }

    @RequiresPermissions(value={"psg:auxIn:bindChannel"})
    @LogRequest(module="psg_module", object="common_leftMenu_auxIn", opType="psg_common_bindOrUnbindChannel", requestParams={}, opContent="psg_common_bindOrUnbindChannel")
    public ZKResultMsg bindOrUnbindChannel() {
        String entityId = this.request.getParameter("entityId");
        String entityName = this.request.getParameter("entityName");
        String channelIds = this.request.getParameter("channelIds");
        ZKResultMsg ret = this.psgChannelService.bindOrUnbindChannel(channelIds, entityName, entityId);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }
}

