/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.StringUtils;

public class DateUtil {
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final int SEMI_MONTH = 1001;
    private static final int[][] fields = new int[][]{{14}, {13}, {12}, {11, 10}, {5, 5, 9}, {2, 1001}, {1}, {0}};
    public static final int RANGE_WEEK_SUNDAY = 1;
    public static final int RANGE_WEEK_MONDAY = 2;
    public static final int RANGE_WEEK_RELATIVE = 3;
    public static final int RANGE_WEEK_CENTER = 4;
    public static final int RANGE_MONTH_SUNDAY = 5;
    public static final int RANGE_MONTH_MONDAY = 6;
    private static final int MODIFY_TRUNCATE = 0;
    private static final int MODIFY_ROUND = 1;
    private static final int MODIFY_CEILING = 2;

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return DateUtil.isSameDay(cal1, cal2);
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static boolean isSameInstant(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return date1.getTime() == date2.getTime();
    }

    public static boolean isSameInstant(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return cal1.getTime().getTime() == cal2.getTime().getTime();
    }

    public static boolean isSameLocalTime(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return cal1.get(14) == cal2.get(14) && cal1.get(13) == cal2.get(13) && cal1.get(12) == cal2.get(12) && cal1.get(11) == cal2.get(11) && cal1.get(6) == cal2.get(6) && cal1.get(1) == cal2.get(1) && cal1.get(0) == cal2.get(0) && cal1.getClass() == cal2.getClass();
    }

    public static Date parseDate(String str, String ... parsePatterns) throws ParseException {
        return DateUtil.parseDate(str, null, parsePatterns);
    }

    public static Date parseDate(String str, Locale locale, String ... parsePatterns) throws ParseException {
        return DateUtil.parseDateWithLeniency(str, locale, parsePatterns, true);
    }

    public static Date parseDateStrictly(String str, String ... parsePatterns) throws ParseException {
        return DateUtil.parseDateStrictly(str, null, parsePatterns);
    }

    public static Date parseDateStrictly(String str, Locale locale, String ... parsePatterns) throws ParseException {
        return DateUtil.parseDateWithLeniency(str, null, parsePatterns, false);
    }

    private static Date parseDateWithLeniency(String str, Locale locale, String[] parsePatterns, boolean lenient) throws ParseException {
        if (str == null || parsePatterns == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        SimpleDateFormat parser = locale == null ? new SimpleDateFormat() : new SimpleDateFormat("", locale);
        parser.setLenient(lenient);
        ParsePosition pos = new ParsePosition(0);
        String[] stringArray = parsePatterns;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            Date date;
            String parsePattern;
            String pattern = parsePattern = stringArray[i];
            if (parsePattern.endsWith("ZZ")) {
                pattern = pattern.substring(0, pattern.length() - 1);
            }
            parser.applyPattern(pattern);
            pos.setIndex(0);
            String str2 = str;
            if (parsePattern.endsWith("ZZ")) {
                str2 = str.replaceAll("([-+][0-9][0-9]):([0-9][0-9])$", "$1$2");
            }
            if ((date = parser.parse(str2, pos)) == null || pos.getIndex() != str2.length()) continue;
            return date;
        }
        throw new ParseException("Unable to parse the date: " + str, -1);
    }

    public static Date addYears(Date date, int amount) {
        return DateUtil.add(date, 1, amount);
    }

    public static Date addMonths(Date date, int amount) {
        return DateUtil.add(date, 2, amount);
    }

    public static Date addWeeks(Date date, int amount) {
        return DateUtil.add(date, 3, amount);
    }

    public static Date addDays(Date date, int amount) {
        return DateUtil.add(date, 5, amount);
    }

    public static Date addHours(Date date, int amount) {
        return DateUtil.add(date, 11, amount);
    }

    public static Date addMinutes(Date date, int amount) {
        return DateUtil.add(date, 12, amount);
    }

    public static Date addSeconds(Date date, int amount) {
        return DateUtil.add(date, 13, amount);
    }

    public static Date addMilliseconds(Date date, int amount) {
        return DateUtil.add(date, 14, amount);
    }

    private static Date add(Date date, int calendarField, int amount) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    public static Date setYears(Date date, int amount) {
        return DateUtil.set(date, 1, amount);
    }

    public static Date setMonths(Date date, int amount) {
        return DateUtil.set(date, 2, amount);
    }

    public static Date setDays(Date date, int amount) {
        return DateUtil.set(date, 5, amount);
    }

    public static Date setHours(Date date, int amount) {
        return DateUtil.set(date, 11, amount);
    }

    public static Date setMinutes(Date date, int amount) {
        return DateUtil.set(date, 12, amount);
    }

    public static Date setSeconds(Date date, int amount) {
        return DateUtil.set(date, 13, amount);
    }

    public static Date setMilliseconds(Date date, int amount) {
        return DateUtil.set(date, 14, amount);
    }

    private static Date set(Date date, int calendarField, int amount) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar c = Calendar.getInstance();
        c.setLenient(false);
        c.setTime(date);
        c.set(calendarField, amount);
        return c.getTime();
    }

    public static Calendar toCalendar(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c;
    }

    public static Date round(Date date, int field) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar gval = Calendar.getInstance();
        gval.setTime(date);
        DateUtil.modify(gval, field, 1);
        return gval.getTime();
    }

    public static Calendar round(Calendar date, int field) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar rounded = (Calendar)date.clone();
        DateUtil.modify(rounded, field, 1);
        return rounded;
    }

    public static Date round(Object date, int field) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (date instanceof Date) {
            return DateUtil.round((Date)date, field);
        }
        if (date instanceof Calendar) {
            return DateUtil.round((Calendar)date, field).getTime();
        }
        throw new ClassCastException("Could not round " + date);
    }

    public static Date truncate(Date date, int field) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar gval = Calendar.getInstance();
        gval.setTime(date);
        DateUtil.modify(gval, field, 0);
        return gval.getTime();
    }

    public static Calendar truncate(Calendar date, int field) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar truncated = (Calendar)date.clone();
        DateUtil.modify(truncated, field, 0);
        return truncated;
    }

    public static Date truncate(Object date, int field) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (date instanceof Date) {
            return DateUtil.truncate((Date)date, field);
        }
        if (date instanceof Calendar) {
            return DateUtil.truncate((Calendar)date, field).getTime();
        }
        throw new ClassCastException("Could not truncate " + date);
    }

    public static Date ceiling(Date date, int field) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar gval = Calendar.getInstance();
        gval.setTime(date);
        DateUtil.modify(gval, field, 2);
        return gval.getTime();
    }

    public static Calendar ceiling(Calendar date, int field) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar ceiled = (Calendar)date.clone();
        DateUtil.modify(ceiled, field, 2);
        return ceiled;
    }

    public static Date ceiling(Object date, int field) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (date instanceof Date) {
            return DateUtil.ceiling((Date)date, field);
        }
        if (date instanceof Calendar) {
            return DateUtil.ceiling((Calendar)date, field).getTime();
        }
        throw new ClassCastException("Could not find ceiling of for type: " + date.getClass());
    }

    private static void modify(Calendar val, int field, int modType) {
        if (val.get(1) > 280000000) {
            throw new ArithmeticException("Calendar value too large for accurate calculations");
        }
        if (field == 14) {
            return;
        }
        Date date = val.getTime();
        long time = date.getTime();
        boolean done = false;
        int millisecs = val.get(14);
        if (0 == modType || millisecs < 500) {
            time -= (long)millisecs;
        }
        if (field == 13) {
            done = true;
        }
        int seconds = val.get(13);
        if (!(done || 0 != modType && seconds >= 30)) {
            time -= (long)seconds * 1000L;
        }
        if (field == 12) {
            done = true;
        }
        int minutes = val.get(12);
        if (!(done || 0 != modType && minutes >= 30)) {
            time -= (long)minutes * 60000L;
        }
        if (date.getTime() != time) {
            date.setTime(time);
            val.setTime(date);
        }
        boolean roundUp = false;
        int[][] nArray = fields;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] aField;
            for (int element : aField = nArray[i]) {
                if (element != field) continue;
                if (modType == 2 || modType == 1 && roundUp) {
                    if (field == 1001) {
                        if (val.get(5) == 1) {
                            val.add(5, 15);
                        } else {
                            val.add(5, -15);
                            val.add(2, 1);
                        }
                    } else if (field == 9) {
                        if (val.get(11) == 0) {
                            val.add(11, 12);
                        } else {
                            val.add(11, -12);
                            val.add(5, 1);
                        }
                    } else {
                        val.add(aField[0], 1);
                    }
                }
                return;
            }
            int offset = 0;
            boolean offsetSet = false;
            switch (field) {
                case 1001: {
                    if (aField[0] != 5) break;
                    offset = val.get(5) - 1;
                    if (offset >= 15) {
                        offset -= 15;
                    }
                    roundUp = offset > 7;
                    offsetSet = true;
                    break;
                }
                case 9: {
                    if (aField[0] != 11) break;
                    offset = val.get(11);
                    if (offset >= 12) {
                        offset -= 12;
                    }
                    roundUp = offset >= 6;
                    offsetSet = true;
                }
            }
            if (!offsetSet) {
                int min = val.getActualMinimum(aField[0]);
                int max = val.getActualMaximum(aField[0]);
                offset = val.get(aField[0]) - min;
                boolean bl = roundUp = offset > (max - min) / 2;
            }
            if (offset == 0) continue;
            val.set(aField[0], val.get(aField[0]) - offset);
        }
        throw new IllegalArgumentException("The field " + field + " is not supported");
    }

    public static Iterator<Calendar> iterator(Date focus, int rangeStyle) {
        if (focus == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar gval = Calendar.getInstance();
        gval.setTime(focus);
        return DateUtil.iterator(gval, rangeStyle);
    }

    public static Iterator<Calendar> iterator(Calendar focus, int rangeStyle) {
        if (focus == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar start = null;
        Calendar end = null;
        int startCutoff = 1;
        int endCutoff = 7;
        switch (rangeStyle) {
            case 5: 
            case 6: {
                start = DateUtil.truncate(focus, 2);
                end = (Calendar)start.clone();
                end.add(2, 1);
                end.add(5, -1);
                if (rangeStyle != 6) break;
                startCutoff = 2;
                endCutoff = 1;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                start = DateUtil.truncate(focus, 5);
                end = DateUtil.truncate(focus, 5);
                switch (rangeStyle) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        startCutoff = 2;
                        endCutoff = 1;
                        break;
                    }
                    case 3: {
                        startCutoff = focus.get(7);
                        endCutoff = startCutoff - 1;
                        break;
                    }
                    case 4: {
                        startCutoff = focus.get(7) - 3;
                        endCutoff = focus.get(7) + 3;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("The range style " + rangeStyle + " is not valid.");
            }
        }
        if (startCutoff < 1) {
            startCutoff += 7;
        }
        if (startCutoff > 7) {
            startCutoff -= 7;
        }
        if (endCutoff < 1) {
            endCutoff += 7;
        }
        if (endCutoff > 7) {
            endCutoff -= 7;
        }
        while (start.get(7) != startCutoff) {
            start.add(5, -1);
        }
        while (end.get(7) != endCutoff) {
            end.add(5, 1);
        }
        return new DateIterator(start, end);
    }

    public static Iterator<?> iterator(Object focus, int rangeStyle) {
        if (focus == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (focus instanceof Date) {
            return DateUtil.iterator((Date)focus, rangeStyle);
        }
        if (focus instanceof Calendar) {
            return DateUtil.iterator((Calendar)focus, rangeStyle);
        }
        throw new ClassCastException("Could not iterate based on " + focus);
    }

    public static long getFragmentInMilliseconds(Date date, int fragment) {
        return DateUtil.getFragment(date, fragment, 14);
    }

    public static long getFragmentInSeconds(Date date, int fragment) {
        return DateUtil.getFragment(date, fragment, 13);
    }

    public static long getFragmentInMinutes(Date date, int fragment) {
        return DateUtil.getFragment(date, fragment, 12);
    }

    public static long getFragmentInHours(Date date, int fragment) {
        return DateUtil.getFragment(date, fragment, 11);
    }

    public static long getFragmentInDays(Date date, int fragment) {
        return DateUtil.getFragment(date, fragment, 6);
    }

    public static long getFragmentInMilliseconds(Calendar calendar, int fragment) {
        return DateUtil.getFragment(calendar, fragment, 14);
    }

    public static long getFragmentInSeconds(Calendar calendar, int fragment) {
        return DateUtil.getFragment(calendar, fragment, 13);
    }

    public static long getFragmentInMinutes(Calendar calendar, int fragment) {
        return DateUtil.getFragment(calendar, fragment, 12);
    }

    public static long getFragmentInHours(Calendar calendar, int fragment) {
        return DateUtil.getFragment(calendar, fragment, 11);
    }

    public static long getFragmentInDays(Calendar calendar, int fragment) {
        return DateUtil.getFragment(calendar, fragment, 6);
    }

    private static long getFragment(Date date, int fragment, int unit) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtil.getFragment(calendar, fragment, unit);
    }

    private static long getFragment(Calendar calendar, int fragment, int unit) {
        if (calendar == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        long millisPerUnit = DateUtil.getMillisPerUnit(unit);
        long result = 0L;
        switch (fragment) {
            case 1: {
                result += (long)calendar.get(6) * 86400000L / millisPerUnit;
                break;
            }
            case 2: {
                result += (long)calendar.get(5) * 86400000L / millisPerUnit;
            }
        }
        switch (fragment) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                result += (long)calendar.get(11) * 3600000L / millisPerUnit;
            }
            case 11: {
                result += (long)calendar.get(12) * 60000L / millisPerUnit;
            }
            case 12: {
                result += (long)calendar.get(13) * 1000L / millisPerUnit;
            }
            case 13: {
                result += (long)(calendar.get(14) * 1) / millisPerUnit;
                break;
            }
            case 14: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The fragment " + fragment + " is not supported");
            }
        }
        return result;
    }

    public static boolean truncatedEquals(Calendar cal1, Calendar cal2, int field) {
        return DateUtil.truncatedCompareTo(cal1, cal2, field) == 0;
    }

    public static boolean truncatedEquals(Date date1, Date date2, int field) {
        return DateUtil.truncatedCompareTo(date1, date2, field) == 0;
    }

    public static int truncatedCompareTo(Calendar cal1, Calendar cal2, int field) {
        Calendar truncatedCal1 = DateUtil.truncate(cal1, field);
        Calendar truncatedCal2 = DateUtil.truncate(cal2, field);
        return truncatedCal1.compareTo(truncatedCal2);
    }

    public static int truncatedCompareTo(Date date1, Date date2, int field) {
        Date truncatedDate1 = DateUtil.truncate(date1, field);
        Date truncatedDate2 = DateUtil.truncate(date2, field);
        return truncatedDate1.compareTo(truncatedDate2);
    }

    private static long getMillisPerUnit(int unit) {
        long result = Long.MAX_VALUE;
        switch (unit) {
            case 5: 
            case 6: {
                result = 86400000L;
                break;
            }
            case 11: {
                result = 3600000L;
                break;
            }
            case 12: {
                result = 60000L;
                break;
            }
            case 13: {
                result = 1000L;
                break;
            }
            case 14: {
                result = 1L;
                break;
            }
            default: {
                throw new IllegalArgumentException("The unit " + unit + " cannot be represented is milleseconds");
            }
        }
        return result;
    }

    private static SimpleDateFormat getDateFormat(String parttern) throws RuntimeException {
        return new SimpleDateFormat(parttern);
    }

    private static int getInteger(Date date, int dateType) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(dateType);
    }

    private static String addInteger(String date, int dateType, int amount) {
        String dateString = null;
        DateStyle dateStyle = DateUtil.getDateStyle(date);
        if (dateStyle != null) {
            Date myDate = DateUtil.stringToDate(date, dateStyle);
            myDate = DateUtil.addInteger(myDate, dateType, amount);
            dateString = DateUtil.dateToString(myDate, dateStyle);
        }
        return dateString;
    }

    private static Date addInteger(Date date, int dateType, int amount) {
        Date myDate = null;
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(dateType, amount);
            myDate = calendar.getTime();
        }
        return myDate;
    }

    private static Date getAccurateDate(List<Long> timestamps) {
        Date date = null;
        long timestamp = 0L;
        HashMap<Long, long[]> map = new HashMap<Long, long[]>();
        ArrayList<Long> absoluteValues = new ArrayList<Long>();
        if (timestamps != null && timestamps.size() > 0) {
            if (timestamps.size() > 1) {
                for (int i = 0; i < timestamps.size(); ++i) {
                    for (int j = i + 1; j < timestamps.size(); ++j) {
                        long absoluteValue = Math.abs(timestamps.get(i) - timestamps.get(j));
                        absoluteValues.add(absoluteValue);
                        long[] timestampTmp = new long[]{timestamps.get(i), timestamps.get(j)};
                        map.put(absoluteValue, timestampTmp);
                    }
                }
                long minAbsoluteValue = -1L;
                if (!absoluteValues.isEmpty()) {
                    minAbsoluteValue = (Long)absoluteValues.get(0);
                }
                for (int i = 0; i < absoluteValues.size(); ++i) {
                    for (int j = i + 1; j < absoluteValues.size(); ++j) {
                        minAbsoluteValue = (Long)absoluteValues.get(i) > (Long)absoluteValues.get(j) ? ((Long)absoluteValues.get(j)).longValue() : ((Long)absoluteValues.get(i)).longValue();
                    }
                }
                if (minAbsoluteValue != -1L) {
                    long[] timestampsLastTmp = (long[])map.get(minAbsoluteValue);
                    if (absoluteValues.size() > 1) {
                        timestamp = Math.max(timestampsLastTmp[0], timestampsLastTmp[1]);
                    } else if (absoluteValues.size() == 1) {
                        long now;
                        long dateOne = timestampsLastTmp[0];
                        long dateTwo = timestampsLastTmp[1];
                        timestamp = Math.abs(dateOne - dateTwo) < 100000000000L ? Math.max(timestampsLastTmp[0], timestampsLastTmp[1]) : (Math.abs(dateOne - (now = new Date().getTime())) <= Math.abs(dateTwo - now) ? dateOne : dateTwo);
                    }
                }
            } else {
                timestamp = timestamps.get(0);
            }
        }
        if (timestamp != 0L) {
            date = new Date(timestamp);
        }
        return date;
    }

    public static boolean isDate(String date) {
        boolean isDate = false;
        if (date != null && DateUtil.stringToDate(date) != null) {
            isDate = true;
        }
        return isDate;
    }

    public static DateStyle getDateStyle(String date) {
        DateStyle dateStyle = null;
        HashMap<Long, DateStyle> map = new HashMap<Long, DateStyle>();
        ArrayList<Long> timestamps = new ArrayList<Long>();
        for (DateStyle style : DateStyle.values()) {
            Date dateTmp = DateUtil.stringToDate(date, style.getValue());
            if (dateTmp == null) continue;
            timestamps.add(dateTmp.getTime());
            map.put(dateTmp.getTime(), style);
        }
        dateStyle = (DateStyle)((Object)map.get(DateUtil.getAccurateDate(timestamps).getTime()));
        return dateStyle;
    }

    public static DateStyle getNewDateStyle(String date) {
        for (DateStyle style : DateStyle.values()) {
            if (!DateUtil.isValidDateStyle(date, style)) continue;
            return style;
        }
        return null;
    }

    public static Date stringToDate(String date) {
        DateStyle dateStyle = null;
        return DateUtil.stringToDate(date, dateStyle);
    }

    public static Date stringToDate(String date, String parttern) {
        Date myDate = null;
        if (date != null) {
            try {
                myDate = DateUtil.getDateFormat(parttern).parse(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return myDate;
    }

    public static Date stringToDate(String date, DateStyle dateStyle) {
        Date myDate = null;
        myDate = dateStyle == null ? DateUtil.stringToDate(date, DateStyle.YYYY_MM_DD_HH_MM_SS) : DateUtil.stringToDate(date, dateStyle.getValue());
        return myDate;
    }

    public static String dateToString(Date date, String parttern) {
        String dateString = null;
        if (date != null) {
            try {
                dateString = DateUtil.getDateFormat(parttern).format(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dateString;
    }

    public static String dateToString(Date date, DateStyle dateStyle) {
        String dateString = null;
        if (dateStyle != null) {
            dateString = DateUtil.dateToString(date, dateStyle.getValue());
        }
        return dateString;
    }

    public static String stringToString(String date, String parttern) {
        return DateUtil.stringToString(date, null, parttern);
    }

    public static String stringToString(String date, DateStyle dateStyle) {
        return DateUtil.stringToString(date, null, dateStyle);
    }

    public static String stringToString(String date, String olddParttern, String newParttern) {
        String dateString = null;
        if (olddParttern == null) {
            DateStyle style = DateUtil.getNewDateStyle(date);
            String string = olddParttern = style == null ? newParttern : style.getValue();
            if (StringUtils.isNotBlank((CharSequence)olddParttern)) {
                Date myDate = DateUtil.stringToDate(date, olddParttern);
                dateString = DateUtil.dateToString(myDate, newParttern);
            }
        } else {
            Date myDate = DateUtil.stringToDate(date, olddParttern);
            dateString = DateUtil.dateToString(myDate, newParttern);
        }
        return dateString;
    }

    public static String stringToString(String date, DateStyle olddDteStyle, DateStyle newDateStyle) {
        String dateString = null;
        if (olddDteStyle == null) {
            DateStyle style = DateUtil.getNewDateStyle(date);
            style = style == null ? newDateStyle : style;
            dateString = DateUtil.stringToString(date, style.getValue(), newDateStyle.getValue());
        } else {
            dateString = DateUtil.stringToString(date, olddDteStyle.getValue(), newDateStyle.getValue());
        }
        return dateString;
    }

    public static String addYear(String date, int yearAmount) {
        return DateUtil.addInteger(date, 1, yearAmount);
    }

    public static Date addYear(Date date, int yearAmount) {
        return DateUtil.addInteger(date, 1, yearAmount);
    }

    public static String addMonth(String date, int yearAmount) {
        return DateUtil.addInteger(date, 2, yearAmount);
    }

    public static Date addMonth(Date date, int yearAmount) {
        return DateUtil.addInteger(date, 2, yearAmount);
    }

    public static String addDay(String date, int dayAmount) {
        return DateUtil.addInteger(date, 5, dayAmount);
    }

    public static Date addDay(Date date, int dayAmount) {
        return DateUtil.addInteger(date, 5, dayAmount);
    }

    public static String addHour(String date, int hourAmount) {
        return DateUtil.addInteger(date, 11, hourAmount);
    }

    public static Date addHour(Date date, int hourAmount) {
        return DateUtil.addInteger(date, 11, hourAmount);
    }

    public static String addMinute(String date, int hourAmount) {
        return DateUtil.addInteger(date, 12, hourAmount);
    }

    public static Date addMinute(Date date, int hourAmount) {
        return DateUtil.addInteger(date, 12, hourAmount);
    }

    public static String addSecond(String date, int hourAmount) {
        return DateUtil.addInteger(date, 13, hourAmount);
    }

    public static Date addSecond(Date date, int hourAmount) {
        return DateUtil.addInteger(date, 13, hourAmount);
    }

    public static int getYear(String date) {
        return DateUtil.getYear(DateUtil.stringToDate(date));
    }

    public static int getYear(Date date) {
        return DateUtil.getInteger(date, 1);
    }

    public static int getMonth(String date) {
        return DateUtil.getMonth(DateUtil.stringToDate(date));
    }

    public static int getMonth(Date date) {
        return DateUtil.getInteger(date, 2);
    }

    public static int getDay(String date) {
        return DateUtil.getDay(DateUtil.stringToDate(date));
    }

    public static int getDay(Date date) {
        return DateUtil.getInteger(date, 5);
    }

    public static int getHour(String date) {
        return DateUtil.getHour(DateUtil.stringToDate(date));
    }

    public static int getHour(Date date) {
        return DateUtil.getInteger(date, 11);
    }

    public static int getMinute(String date) {
        return DateUtil.getMinute(DateUtil.stringToDate(date));
    }

    public static int getMinute(Date date) {
        return DateUtil.getInteger(date, 12);
    }

    public static int getSecond(String date) {
        return DateUtil.getSecond(DateUtil.stringToDate(date));
    }

    public static int getSecond(Date date) {
        return DateUtil.getInteger(date, 13);
    }

    public static String getDate(String date) {
        return DateUtil.stringToString(date, DateStyle.YYYY_MM_DD);
    }

    public static String getDate(Date date) {
        return DateUtil.dateToString(date, DateStyle.YYYY_MM_DD);
    }

    public static String getDate(Date date, DateStyle style) {
        return DateUtil.dateToString(date, style);
    }

    public static String getTime(String date) {
        return DateUtil.stringToString(date, DateStyle.HH_MM_SS);
    }

    public static String getTime(Date date) {
        return DateUtil.dateToString(date, DateStyle.HH_MM_SS);
    }

    public static Week getWeek(String date) {
        Week week = null;
        DateStyle dateStyle = DateUtil.getDateStyle(date);
        if (dateStyle != null) {
            Date myDate = DateUtil.stringToDate(date, dateStyle);
            week = DateUtil.getWeek(myDate);
        }
        return week;
    }

    public static Week getWeek(Date date) {
        Week week = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int weekNumber = calendar.get(7) - 1;
        switch (weekNumber) {
            case 0: {
                week = Week.SUNDAY;
                break;
            }
            case 1: {
                week = Week.MONDAY;
                break;
            }
            case 2: {
                week = Week.TUESDAY;
                break;
            }
            case 3: {
                week = Week.WEDNESDAY;
                break;
            }
            case 4: {
                week = Week.THURSDAY;
                break;
            }
            case 5: {
                week = Week.FRIDAY;
                break;
            }
            case 6: {
                week = Week.SATURDAY;
            }
        }
        return week;
    }

    public static int getIntervalDays(String date, String otherDate) {
        return DateUtil.getIntervalDays(DateUtil.stringToDate(date), DateUtil.stringToDate(otherDate));
    }

    public static int getIntervalDays(Date date, Date otherDate) {
        date = DateUtil.stringToDate(DateUtil.getDate(date));
        long time = Math.abs(date.getTime() - otherDate.getTime());
        return (int)time / 86400000;
    }

    public static Timestamp getCurrentTime() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static String getTodayBetweenTime(Date date, int flag) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        long millisecond = hour * 60 * 60 * 1000 + minute * 60 * 1000 + second * 1000;
        cal.setTimeInMillis(cal.getTimeInMillis() - millisecond);
        if (flag == 0) {
            return DateUtil.getDate(cal.getTime(), DateStyle.YYYY_MM_DD_HH_MM_SS);
        }
        if (flag == 1) {
            cal.setTimeInMillis(cal.getTimeInMillis() + 82800000L + 3540000L + 59000L);
        }
        return DateUtil.getDate(cal.getTime(), DateStyle.YYYY_MM_DD_HH_MM_SS);
    }

    public static String plusDay(int num, String newDate) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date currdate = format.parse(newDate);
        Calendar ca = Calendar.getInstance();
        ca.setTime(currdate);
        ca.add(5, num);
        currdate = ca.getTime();
        String enddate = format.format(currdate);
        return enddate;
    }

    public static String plusYear(int num, String newDate) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date currdate = format.parse(newDate);
        Calendar ca = Calendar.getInstance();
        ca.setTime(currdate);
        ca.add(1, num);
        currdate = ca.getTime();
        String enddate = format.format(currdate);
        return enddate;
    }

    public static Date getStartMonthDate(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, cal.getMinimum(5));
        cal.set(5, cal.getMinimum(5));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String last = format.format(cal.getTime());
        return DateUtil.stringToDate(last + " 00:00:00", DateStyle.YYYY_MM_DD_HH_MM_SS);
    }

    public static Date getEndMonthDate(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, cal.getActualMaximum(5));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String last = format.format(cal.getTime());
        return DateUtil.stringToDate(last + " 23:59:59", DateStyle.YYYY_MM_DD_HH_MM_SS);
    }

    public static Date getDateBefore(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) - day);
        return now.getTime();
    }

    public static Date getDateAfter(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) + day);
        return now.getTime();
    }

    public static Date getTodayBeginTime() {
        return DateUtil.getDayBeginTime(new Date());
    }

    public static Date getDayBeginTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getTodayEndTime() {
        return DateUtil.getDayEndTime(new Date());
    }

    public static Date getDayEndTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    private static boolean isValidDateStyle(String date, DateStyle dateStyle) {
        boolean convertSuccess = date.length() <= dateStyle.getValue().length();
        SimpleDateFormat format = new SimpleDateFormat(dateStyle.getValue());
        try {
            format.setLenient(false);
            format.parse(date);
        }
        catch (ParseException e) {
            convertSuccess = false;
        }
        return convertSuccess;
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.stringToString("2020-08-03 10:10:10.325", DateStyle.YYYY_MM_DD_HH_MM_SS));
    }

    public static enum DateStyle {
        MM_DD("MM-dd"),
        YYYY_MM("yyyy-MM"),
        YYYY_MM_DD("yyyy-MM-dd"),
        MM_DD_HH_MM("MM-dd HH:mm"),
        MM_DD_HH_MM_SS("MM-dd HH:mm:ss"),
        YYYY_MM_DD_HH_MM("yyyy-MM-dd HH:mm"),
        YYYY_MM_DD_HH_MM_SS("yyyy-MM-dd HH:mm:ss"),
        YYYY_MM_DD_HH_MM_SS_SSS("yyyy-MM-dd HH:mm:ss.SSS"),
        YYYY_MM_DD_T_HH_MM_SS_XXX("yyyy-MM-dd'T'HH:mm:ssXXX"),
        YYYYMMDDHHMMSS("yyyyMMddHHmmss"),
        YYYYMMDDHHMMSSSSS("yyyyMMddHHmmssSSS"),
        YYYYMMDD("yyyyMMdd"),
        MM_DD_EN("MM/dd"),
        YYYY_MM_EN("yyyy/MM"),
        YYYY_MM_DD_EN("yyyy/MM/dd"),
        MM_DD_YYYY_EN("MM/dd/yyyy"),
        MM_DD_HH_MM_EN("MM/dd HH:mm"),
        MM_DD_HH_MM_SS_EN("MM/dd HH:mm:ss"),
        YYYY_MM_DD_HH_MM_EN("yyyy/MM/dd HH:mm"),
        YYYY_MM_DD_HH_MM_SS_EN("yyyy/MM/dd HH:mm:ss"),
        YYYY_MM_DD_HH_MM_SS_SSS_EN("yyyy/MM/dd HH:mm:ss.SSS"),
        MM_DD_CN("MM\u6708dd\u65e5"),
        YYYY_MM_CN("yyyy\u5e74MM\u6708"),
        YYYY_MM_DD_CN("yyyy\u5e74MM\u6708dd\u65e5"),
        MM_DD_HH_MM_CN("MM\u6708dd\u65e5 HH:mm"),
        MM_DD_HH_MM_SS_CN("MM\u6708dd\u65e5 HH:mm:ss"),
        YYYY_MM_DD_HH_MM_CN("yyyy\u5e74MM\u6708dd\u65e5 HH:mm"),
        YYYY_MM_DD_HH_MM_SS_CN("yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss"),
        YYYY_MM_DD_HH_MM_SS_SSS_CN("yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss.SSS"),
        HH_MM("HH:mm"),
        HH_MM_SS("HH:mm:ss");

        private String value;

        private DateStyle(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Week {
        MONDAY("\u661f\u671f\u4e00", "Monday", "Mon.", 1),
        TUESDAY("\u661f\u671f\u4e8c", "Tuesday", "Tues.", 2),
        WEDNESDAY("\u661f\u671f\u4e09", "Wednesday", "Wed.", 3),
        THURSDAY("\u661f\u671f\u56db", "Thursday", "Thur.", 4),
        FRIDAY("\u661f\u671f\u4e94", "Friday", "Fri.", 5),
        SATURDAY("\u661f\u671f\u516d", "Saturday", "Sat.", 6),
        SUNDAY("\u661f\u671f\u65e5", "Sunday", "Sun.", 7);

        String name_cn;
        String name_en;
        String name_enShort;
        int number;

        private Week(String name_cn, String name_en, String name_enShort, int number) {
            this.name_cn = name_cn;
            this.name_en = name_en;
            this.name_enShort = name_enShort;
            this.number = number;
        }

        public String getChineseName() {
            return this.name_cn;
        }

        public String getName() {
            return this.name_en;
        }

        public String getShortName() {
            return this.name_enShort;
        }

        public int getNumber() {
            return this.number;
        }
    }

    static class DateIterator
    implements Iterator<Calendar> {
        private final Calendar endFinal;
        private final Calendar spot;

        DateIterator(Calendar startFinal, Calendar endFinal) {
            this.endFinal = endFinal;
            this.spot = startFinal;
            this.spot.add(5, -1);
        }

        @Override
        public boolean hasNext() {
            return this.spot.before(this.endFinal);
        }

        @Override
        public Calendar next() {
            if (this.spot.equals(this.endFinal)) {
                throw new NoSuchElementException();
            }
            this.spot.add(5, 1);
            return (Calendar)this.spot.clone();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

