/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.posid.remote.PosIDModifiedDataRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDAccountKindService;
import com.zkteco.zkbiosecurity.posid.service.PosIDAccountService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDAccountKindItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDModifiedDataController
extends BaseController
implements PosIDModifiedDataRemote {
    @Autowired
    private PosIDAccountKindService posIDAccountKindService;
    @Autowired
    private PosIDAccountService posIDAccountService;

    @RequiresPermissions(value={"posid:modifiedData"})
    public ModelAndView index() {
        return new ModelAndView("posid/modifiedData/posIDModifiedData");
    }

    @RequiresPermissions(value={"posid:modifiedData:edit"})
    public ModelAndView edit(String id) {
        HashMap<String, String> param = new HashMap<String, String>();
        String cardKindId = ((PosIDAccountKindItem)this.posIDAccountKindService.getByCondition(new PosIDAccountKindItem()).get(0)).getId();
        param.put("posCardKindId", cardKindId);
        return new ModelAndView("posid/modifiedData/editPosIDModifiedData", param);
    }

    @RequiresPermissions(value={"posid:modifiedData:edit"})
    public ZKResultMsg editAccountType(String ids, String posAccountKindId) {
        ZKResultMsg res = this.posIDAccountService.editAccountType(ids, posAccountKindId);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"posid:modifiedData:del"})
    @LogRequest(module="posid_module", object="posid_op_modifiedData", opType="common_op_del", requestParams={"ids"}, opContent="posid_common_id")
    public ZKResultMsg delete(String ids) {
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"posid:modifiedData:save"})
    @LogRequest(module="posid_module", object="posid_leftMenu_cardBusiness", opType="posid_op_modifiedData", requestParams={"deptName"}, opContent="posid_card_personNum")
    public ZKResultMsg save() {
        String sysCardNo = this.request.getParameter("sysCardNo");
        String issueDate = this.request.getParameter("issueDate");
        String posAccountKind = this.request.getParameter("posAccountKindId");
        ZKResultMsg res = this.posIDAccountService.modify(sysCardNo, null, issueDate, posAccountKind);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }
}

