/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.posid.remote.PosIDBatchTimeRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDBatchTimeService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDBatchTimeItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDBatchTimeController
extends BaseController
implements PosIDBatchTimeRemote {
    @Autowired
    private PosIDBatchTimeService posIDBatchTimeService;

    @RequiresPermissions(value={"posid:batchTime"})
    public ModelAndView index() {
        return new ModelAndView("posid/batchTime/posIDBatchTime");
    }

    @RequiresPermissions(value={"posid:batchTime:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.posIDBatchTimeService.getItemById(id));
        }
        return new ModelAndView("posid/batchTime/editPosIDBatchTime");
    }

    @RequiresPermissions(value={"posid:batchTime:edit"})
    @LogRequest(module="posid_module", object="posid_leftMenu_batchTime", opType="common_op_edit", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg save(PosIDBatchTimeItem item) {
        ZKResultMsg res = new ZKResultMsg();
        boolean oldIsValid = Boolean.parseBoolean(this.request.getParameter("oldIsValid"));
        this.posIDBatchTimeService.saveItem(item, oldIsValid);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"posid:batchTime:refresh"})
    public DxGrid list(PosIDBatchTimeItem codition) {
        Pager pager = this.posIDBatchTimeService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"posid:batchTime:del"})
    @LogRequest(module="posid_module", object="posid_leftMenu_batchTime", opType="common_op_del", requestParams={"ids"}, opContent="posid_common_id")
    public ZKResultMsg delete(String ids) {
        this.posIDBatchTimeService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getBatchTimeList() {
        return new ZKResultMsg((Object)this.posIDBatchTimeService.getBatchTimeList());
    }

    public ZKResultMsg checkTimeseg() {
        String id = this.request.getParameter("posBatchTimeId");
        String posBatchName = this.request.getParameter("posBatchName");
        String startStr = this.request.getParameter("startTime");
        String endStr = this.request.getParameter("endTime");
        boolean available = Boolean.parseBoolean(this.request.getParameter("available"));
        return this.posIDBatchTimeService.checkTimeseg(id, startStr, endStr, available, posBatchName);
    }
}

