/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;
import java.util.UUID;

@From(after="POSID_OUT_STOCK o")
@GroupBy(after="o.PRODUCT_ID, o.PRODUCT_NAME")
@GridConfig(operate=true, idField="id", winHeight=360, winWidth=450)
public class PosIDOutStockSumExportItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @GridColumn(show=false)
    private String id = UUID.randomUUID().toString();
    @Column(name="o.PRODUCT_NAME")
    @GridColumn(label="posid_storeDetail_name", width="200")
    private String productName;
    @Column(name="SUM(o.NUM)")
    @GridColumn(label="posid_outStock_num", width="180")
    private Integer num;
    @Column(name="SUM(o.TOTAL_PRICE)")
    @GridColumn(label="posid_outStock_total", width="200", columnType="custom", convert="convertFen2Yuan")
    private Double totalPrice;
    @Column(name="SUM(o.TOTAL_COST)")
    @GridColumn(label="posid_profit_price", width="200", columnType="custom", convert="convertFen2Yuan")
    private Double totalCost;
    @Column(name="SUM(o.TOTAL_PROFIT)")
    @GridColumn(label="posid_profit_profit", width="200", columnType="custom", convert="convertFen2Yuan")
    private Double totalProfit;
    @Condition(value="o.CREATE_TIME", equalTag=">=", toDate=true)
    private Date startDatetimeBegin;
    @Condition(value="o.CREATE_TIME", equalTag="<=", toDate=true)
    private Date startDatetimeEnd;
    @Condition(value="o.PRODUCT_NAME", equalTag="like")
    private String likeName;
    @Condition(value="o.STATUS", equalTag="=")
    private Integer status;
    private String outStockTime;
    @GridColumn(label="posid_countTable_conTimeStr", minWidth="160", width="170", sort="na")
    private String posTime;

    public String getId() {
        return this.id;
    }

    public String getProductName() {
        return this.productName;
    }

    public Integer getNum() {
        return this.num;
    }

    public Double getTotalPrice() {
        return this.totalPrice;
    }

    public Double getTotalCost() {
        return this.totalCost;
    }

    public Double getTotalProfit() {
        return this.totalProfit;
    }

    public Date getStartDatetimeBegin() {
        return this.startDatetimeBegin;
    }

    public Date getStartDatetimeEnd() {
        return this.startDatetimeEnd;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getOutStockTime() {
        return this.outStockTime;
    }

    public String getPosTime() {
        return this.posTime;
    }

    public PosIDOutStockSumExportItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDOutStockSumExportItem setProductName(String productName) {
        this.productName = productName;
        return this;
    }

    public PosIDOutStockSumExportItem setNum(Integer num) {
        this.num = num;
        return this;
    }

    public PosIDOutStockSumExportItem setTotalPrice(Double totalPrice) {
        this.totalPrice = totalPrice;
        return this;
    }

    public PosIDOutStockSumExportItem setTotalCost(Double totalCost) {
        this.totalCost = totalCost;
        return this;
    }

    public PosIDOutStockSumExportItem setTotalProfit(Double totalProfit) {
        this.totalProfit = totalProfit;
        return this;
    }

    public PosIDOutStockSumExportItem setStartDatetimeBegin(Date startDatetimeBegin) {
        this.startDatetimeBegin = startDatetimeBegin;
        return this;
    }

    public PosIDOutStockSumExportItem setStartDatetimeEnd(Date startDatetimeEnd) {
        this.startDatetimeEnd = startDatetimeEnd;
        return this;
    }

    public PosIDOutStockSumExportItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PosIDOutStockSumExportItem setStatus(Integer status) {
        this.status = status;
        return this;
    }

    public PosIDOutStockSumExportItem setOutStockTime(String outStockTime) {
        this.outStockTime = outStockTime;
        return this;
    }

    public PosIDOutStockSumExportItem setPosTime(String posTime) {
        this.posTime = posTime;
        return this;
    }

    public String toString() {
        return "PosIDOutStockSumExportItem(id=" + this.getId() + ", productName=" + this.getProductName() + ", num=" + this.getNum() + ", totalPrice=" + this.getTotalPrice() + ", totalCost=" + this.getTotalCost() + ", totalProfit=" + this.getTotalProfit() + ", startDatetimeBegin=" + this.getStartDatetimeBegin() + ", startDatetimeEnd=" + this.getStartDatetimeEnd() + ", likeName=" + this.getLikeName() + ", status=" + this.getStatus() + ", outStockTime=" + this.getOutStockTime() + ", posTime=" + this.getPosTime() + ")";
    }
}

