/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccPersonLimitRemote;
import com.zkteco.zkbiosecurity.acc.service.AccAdvancedPersonService;
import com.zkteco.zkbiosecurity.acc.service.AccPersonLimitService;
import com.zkteco.zkbiosecurity.acc.vo.AccAdvancedPersonListItem;
import com.zkteco.zkbiosecurity.acc.vo.AccPersonLimitItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccPersonLimitController
extends BaseController
implements AccPersonLimitRemote {
    @Autowired
    private AccPersonLimitService accPersonLimitService;
    @Autowired
    private AccAdvancedPersonService accAdvancedPersonService;

    @RequiresPermissions(value={"acc:personLimitZone:setZoneProperty"})
    public ModelAndView index() {
        return new ModelAndView("acc/personLimit/accPersonLimit");
    }

    @RequiresPermissions(value={"acc:personLimitZone:setZoneProperty"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.accPersonLimitService.getItemById(id));
        }
        return new ModelAndView("acc/personLimit/editAccPersonLimit");
    }

    @LogRequest(module="acc_module", object="acc_personLimit_setZoneProperty", opType="common_op_edit", requestParams={"name"}, opContent="acc_personLimit_zoneProperty")
    public ZKResultMsg save(AccPersonLimitItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.accPersonLimitService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(AccPersonLimitItem codition) {
        Pager pager = this.accPersonLimitService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="acc_module", object="acc_personLimit_setZoneProperty", opType="common_op_del", requestParams={"names"}, opContent="acc_personLimit_zoneProperty")
    public ZKResultMsg del(String ids) {
        this.accPersonLimitService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getPersonLimitList() {
        String tempZoneId = this.request.getParameter("tempZoneId");
        String tempRuleId = this.request.getParameter("tempRuleId");
        tempZoneId = tempZoneId == null || "".equals(tempZoneId) ? "0" : tempZoneId;
        tempRuleId = tempRuleId == null || "".equals(tempRuleId) ? "0" : tempRuleId;
        String zoneId = "".equals(this.request.getParameter("zoneId")) ? "0" : this.request.getParameter("zoneId");
        String ruleId = "".equals(this.request.getParameter("ruleId")) ? "0" : this.request.getParameter("ruleId");
        ruleId = tempRuleId.equals("0") ? ruleId : tempRuleId;
        return new ZKResultMsg((Object)this.accPersonLimitService.getPersonLimitList(zoneId, ruleId, tempZoneId));
    }

    public DxGrid personList(AccAdvancedPersonListItem codition) {
        codition.setModelType("ACC_PERSONLIMIT");
        Pager pager = this.accAdvancedPersonService.getPersonItemList(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="acc_module", object="acc_personLimit_setZoneProperty", opType="pers_common_addPerson", requestParams={"personLimitName", "personPins"}, opContent="pers_person_pin")
    public ZKResultMsg addPerson(String personLimitId, String personIds, String deptIds) {
        ZKResultMsg ret = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)deptIds)) {
            personIds = this.accAdvancedPersonService.getPersonIdsByDeptIds(deptIds);
        }
        if (StringUtils.isNotBlank((CharSequence)personLimitId) && StringUtils.isNotBlank((CharSequence)personIds)) {
            ArrayList<String> personIdList = new ArrayList<String>(Arrays.asList(personIds.split(",")));
            List existPersonIds = this.accPersonLimitService.getExistPersonIds();
            if (existPersonIds.size() > 0) {
                personIdList.removeAll(existPersonIds);
            }
            if (personIdList.isEmpty()) {
                ret.setRet("500");
                ret.setMsg("acc_personLimit_addPersonRepeatTip");
            } else {
                this.accPersonLimitService.addPerson(personLimitId, personIdList);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    @LogRequest(module="acc_module", object="acc_personLimit_setZoneProperty", opType="pers_common_delPerson", requestParams={"personLimitName", "personPins"}, opContent="pers_person_pin")
    public ZKResultMsg delPerson(String personLimitId, String personIds) {
        this.accPersonLimitService.delPerson(personLimitId, personIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String valid(String name) {
        AccPersonLimitItem item = this.accPersonLimitService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    public ZKResultMsg getPersonLimitDetail(String id) {
        String ret = "";
        AccPersonLimitItem accPersonLimitItem = this.accPersonLimitService.getItemById(id);
        if (accPersonLimitItem != null) {
            if (accPersonLimitItem.getValidType().toString().equals("3")) {
                ret = accPersonLimitItem.getValidTimes() + " " + I18nUtil.i18nCode((String)"common_times", (Object[])new Object[0]);
            } else if (accPersonLimitItem.getValidType().toString().equals("2")) {
                ret = accPersonLimitItem.getValidDays() + " " + I18nUtil.i18nCode((String)"common_days", (Object[])new Object[0]);
            } else if (accPersonLimitItem.getValidType().toString().equals("1")) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                ret = I18nUtil.i18nCode((String)"acc_personLimit_userDateTo", (Object[])new Object[0]) + " " + dateFormat.format(accPersonLimitItem.getValidDate());
            }
        }
        return new ZKResultMsg((Object)ret);
    }
}

