/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccGlobalInterlockGroupRemote;
import com.zkteco.zkbiosecurity.acc.service.AccGlobalInterlockGroupService;
import com.zkteco.zkbiosecurity.acc.vo.AccGlobalInterlockGroupItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccGlobalInterlockGroupController
extends BaseController
implements AccGlobalInterlockGroupRemote {
    @Autowired
    private AccGlobalInterlockGroupService accGlobalInterlockGroupService;

    @RequiresPermissions(value={"acc:globalInterlockGroup"})
    public ModelAndView index() {
        return new ModelAndView("acc/globalInterlockGroup/accGlobalInterlockGroup");
    }

    @RequiresPermissions(value={"acc:globalInterlockGroup:add", "acc:globalInterlockGroup:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.accGlobalInterlockGroupService.getItemById(id));
        }
        return new ModelAndView("acc/globalInterlockGroup/editAccGlobalInterlockGroup");
    }

    @RequiresPermissions(value={"acc:globalInterlockGroup:add", "acc:globalInterlockGroup:edit"})
    @LogRequest(module="acc_module", object="acc_leftMeue_globalInterlockGroup", opType="common_op_edit", requestParams={"name"}, opContent="acc_combOpen_personGroupName")
    public ZKResultMsg save(AccGlobalInterlockGroupItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.accGlobalInterlockGroupService.saveItem(item);
        res.setData((Object)item.getId());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:globalInterlockGroup:refresh"})
    public DxGrid list(AccGlobalInterlockGroupItem codition) {
        Pager pager = this.accGlobalInterlockGroupService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:globalInterlockGroup:del"})
    @LogRequest(module="acc_module", object="acc_leftMeue_globalInterlockGroup", opType="common_op_del", requestParams={"name"}, opContent="acc_combOpen_personGroupName")
    public ZKResultMsg del(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        if (this.accGlobalInterlockGroupService.isExistInterLock(ids)) {
            res.setRet("false");
            res.setMsg(I18nUtil.i18nCode((String)"acc_globalInterlock_refuseDeleteGroupMessage", (Object[])new Object[0]));
        } else {
            this.accGlobalInterlockGroupService.deleteByIds(ids);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public boolean isExist(AccGlobalInterlockGroupItem item) {
        String groupName = this.request.getParameter("groupName");
        if (StringUtils.isNotBlank((CharSequence)groupName) && groupName.equals(item.getName())) {
            return true;
        }
        return this.accGlobalInterlockGroupService.isExist(item.getName());
    }

    @RequiresPermissions(value={"acc:globalInterlockGroup:addDoor"})
    @LogRequest(module="acc_module", object="acc_leftMeue_globalInterlockGroup", opType="acc_map_addDoor", requestParams={"groupName", "doorNames"}, opContent="acc_door_name")
    public ZKResultMsg addDoors(String groupId, String doorIds) {
        ZKResultMsg res = new ZKResultMsg();
        this.accGlobalInterlockGroupService.addDoors(groupId, doorIds);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg checkDevIssueVerify(String doorIds) {
        ZKResultMsg res = new ZKResultMsg();
        String devIds = this.accGlobalInterlockGroupService.checkDevIssueVerify(doorIds);
        if (devIds.length() > 0) {
            res.setRet("false");
            res.setData((Object)devIds);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg convertAccGlobalInterlockCount(String value) {
        return this.accGlobalInterlockGroupService.getDoorCount(this.request.getSession().getId(), value);
    }
}

