/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.client.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.ApiPermissions;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.CollectionUtil;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseClientService;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonItem;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.vis.client.utils.VisUploadPageUtil;
import com.zkteco.zkbiosecurity.vis.constants.VisConstants;
import com.zkteco.zkbiosecurity.vis.service.VisCloudService;
import com.zkteco.zkbiosecurity.vis.service.VisReservationService;
import com.zkteco.zkbiosecurity.vis.service.VisVisitedPersonService;
import com.zkteco.zkbiosecurity.vis.vo.VisReservationItem;
import com.zkteco.zkbiosecurity.vis.vo.VisVisitedPersonItem;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(value={"vis.visReservationMessageHandle.isExecute"}, havingValue="true", matchIfMissing=true)
@Component
public class VisReservationMessageHandle {
    private static final Logger logger = LoggerFactory.getLogger(VisReservationMessageHandle.class);
    @Autowired
    private PersPersonService persPersonService;
    @Autowired
    private VisReservationService visReservationService;
    @Autowired
    private VisVisitedPersonService visVisitedPersonService;
    @Autowired
    private BaseLicenseService baseLicenseService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private BaseLicenseClientService baseLicenseClientService;
    @Autowired
    private VisCloudService visCloudService;

    @Scheduled(cron="0 0 0/1 * * ?")
    public ZKResultMsg visMessageUpload() {
        if (StringUtils.isNotBlank((CharSequence)this.baseLicenseService.getAppId()) && this.visCloudService.isActiveLicense()) {
            ZKMessage zkMessage = new ZKMessage();
            Long pushTime = this.visReservationService.getLastPushTime();
            zkMessage.setModuleCode("vis");
            zkMessage.setMessageId("visCloudReservationHandleMessage#visitedPersonMessageHandle");
            if (pushTime == null || pushTime == 0L) {
                Long visitedPersonCount = this.visVisitedPersonService.getVisitedPersonCount();
                int pageNo = VisUploadPageUtil.getPage(visitedPersonCount);
                for (int i = 0; i < pageNo; ++i) {
                    Pager pager = this.visVisitedPersonService.getItemsByPage((BaseItem)new VisVisitedPersonItem(), i, 30);
                    List visVisitedPersonItemList = pager.getData();
                    zkMessage.setListContent(visVisitedPersonItemList);
                    this.baseLicenseClientService.sendMessage(zkMessage);
                }
            } else {
                Date lastUpdate = new Date(pushTime);
                List visVisitedPersonItemList = this.visVisitedPersonService.getUpdatePersonItem(lastUpdate = DateUtil.addMinute((Date)lastUpdate, (int)-1));
                if (visVisitedPersonItemList != null && !visVisitedPersonItemList.isEmpty()) {
                    List visitedPersonItemList = CollectionUtil.split((Collection)visVisitedPersonItemList, (int)30);
                    for (List visitedPersonItems : visitedPersonItemList) {
                        zkMessage.setListContent(visitedPersonItems);
                        this.baseLicenseClientService.sendMessage(zkMessage);
                    }
                }
            }
            this.visReservationService.setLastPushTime();
        }
        return ZKResultMsg.successMsg();
    }

    @ApiPermissions(moduleCode="vis", moduleName="vis_module")
    public ZKResultMsg sendVisReservationMessage(ZKMessage zkMessage) {
        List visReservationMessageList = zkMessage.getListContent();
        if (visReservationMessageList != null && visReservationMessageList.size() > 0) {
            List visReservationItems = JSONArray.parseArray((String)visReservationMessageList.toString(), VisReservationItem.class);
            visReservationItems.forEach(visReservationItem -> {
                try {
                    PersPersonItem persPersonItem = this.persPersonService.getItemByPin(visReservationItem.getVisitEmpPin());
                    if (persPersonItem != null) {
                        ZKResultMsg visVisitorMsg = this.visReservationService.loadVisInfo(visReservationItem.getCertType(), visReservationItem.getCertNumber());
                        if (visVisitorMsg.getData() != null) {
                            JSONObject visitorInfo = (JSONObject)visVisitorMsg.getData();
                            visReservationItem.setVisitorId(visitorInfo.containsKey((Object)"id") ? visitorInfo.getString("id") : null);
                            visReservationItem.setVisitorPin(visitorInfo.containsKey((Object)"pin") ? visitorInfo.getString("pin") : null);
                        }
                        visReservationItem.setVisitEmpDeptId(persPersonItem.getDeptId());
                        visReservationItem.setVisitEmpDeptName(persPersonItem.getDeptName());
                        visReservationItem.setVisitedEmpId(persPersonItem.getId());
                        VisReservationItem oldVisReservationItem = this.visReservationService.getItemByCertAndVisitDate(visReservationItem.getCertType(), visReservationItem.getCertNumber(), visReservationItem.getVisitDate(), visReservationItem.getVisitEndDate());
                        if (oldVisReservationItem != null) {
                            visReservationItem.setId(oldVisReservationItem.getId());
                            visReservationItem.setGender(oldVisReservationItem.getGender());
                            visReservationItem.setCarPlate(oldVisReservationItem.getCarPlate());
                            visReservationItem.setPhotoPath(oldVisReservationItem.getPhotoPath());
                            visReservationItem.setCropPhotoPath(oldVisReservationItem.getCropPhotoPath());
                        }
                        visReservationItem.setCardNo(visReservationItem.getVisitCode());
                        if (visReservationItem.getAuditStatus() == null) {
                            if ("1".equals(this.baseSysParamService.getValByName("vis.reservation.audit")) && "h5_web".equals(visReservationItem.getIsFrom())) {
                                visReservationItem.setAuditStatus(VisConstants.RESERVATION_AUDIT);
                                visReservationItem.setAuditTime(DateUtil.stringToDate((String)DateUtil.dateToString((Date)new Date(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS)));
                            } else {
                                visReservationItem.setAuditStatus(VisConstants.RESERVATION_NOT_AUDIT);
                            }
                        } else if (VisConstants.RESERVATION_AUDIT.equals(visReservationItem.getAuditStatus()) && visReservationItem.getAuditTime() == null) {
                            visReservationItem.setAuditTime(DateUtil.stringToDate((String)DateUtil.dateToString((Date)new Date(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS)));
                        }
                        visReservationItem = this.visReservationService.saveItem(visReservationItem);
                    }
                }
                catch (Exception e) {
                    logger.error("visCloud sendVisReservationMessage error: ", (Throwable)e);
                }
            });
        }
        return ZKResultMsg.successMsg();
    }

    @ApiPermissions(moduleCode="vis", moduleName="vis_module")
    public ZKResultMsg sendCancelVisReservationMessage(ZKMessage zkMessage) {
        List visReservationMessageList = zkMessage.getListContent();
        if (visReservationMessageList != null && visReservationMessageList.size() > 0) {
            List visReservationItems = JSONArray.parseArray((String)visReservationMessageList.toString(), VisReservationItem.class);
            for (VisReservationItem item : visReservationItems) {
                VisReservationItem visReservationItem = new VisReservationItem();
                if (StringUtils.isNotBlank((CharSequence)item.getVisitDate())) {
                    visReservationItem.setVisitDateEQ(item.getVisitDate());
                }
                if (StringUtils.isNotBlank((CharSequence)item.getVisitDate())) {
                    visReservationItem.setVisitEndDateEQ(item.getVisitEndDate());
                }
                visReservationItem.setCertType(item.getCertType());
                visReservationItem.setCertNumber(item.getCertNumber());
                List visReservationItemList = this.visReservationService.getByCondition(visReservationItem);
                for (VisReservationItem reservationItem : visReservationItemList) {
                    reservationItem.setIsVisited("2");
                    this.visReservationService.updateReservationItem(reservationItem);
                }
            }
        }
        return ZKResultMsg.successMsg();
    }
}

